<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bill Structure
 * @subpackage Structs
 */
class Bill extends AbstractStructBase
{
    /**
     * The billID
     * @var int
     */
    public $billID;
    /**
     * The billingDate
     * @var string
     */
    public $billingDate;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The sumAmount
     * @var float
     */
    public $sumAmount;
    /**
     * The billPDF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billPDF;
    /**
     * The billEntries
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var BillEntry[]
     */
    public $billEntries;
    /**
     * Constructor method for bill
     * @uses Bill::setBillID()
     * @uses Bill::setBillingDate()
     * @uses Bill::setDueDate()
     * @uses Bill::setSumAmount()
     * @uses Bill::setBillPDF()
     * @uses Bill::setBillEntries()
     * @param int $billID
     * @param string $billingDate
     * @param string $dueDate
     * @param float $sumAmount
     * @param string $billPDF
     * @param BillEntry[] $billEntries
     */
    public function __construct($billID = null, $billingDate = null, $dueDate = null, $sumAmount = null, $billPDF = null, array $billEntries = array())
    {
        $this
            ->setBillID($billID)
            ->setBillingDate($billingDate)
            ->setDueDate($dueDate)
            ->setSumAmount($sumAmount)
            ->setBillPDF($billPDF)
            ->setBillEntries($billEntries);
    }
    /**
     * Get billID value
     * @return int|null
     */
    public function getBillID()
    {
        return $this->billID;
    }
    /**
     * Set billID value
     * @param int $billID
     * @return Bill
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !(is_int($billID) || ctype_digit($billID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($billID, true), gettype($billID)), __LINE__);
        }
        $this->billID = $billID;
        return $this;
    }
    /**
     * Get billingDate value
     * @return string|null
     */
    public function getBillingDate()
    {
        return $this->billingDate;
    }
    /**
     * Set billingDate value
     * @param string $billingDate
     * @return Bill
     */
    public function setBillingDate($billingDate = null)
    {
        // validation for constraint: string
        if (!is_null($billingDate) && !is_string($billingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDate, true), gettype($billingDate)), __LINE__);
        }
        $this->billingDate = $billingDate;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return Bill
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get sumAmount value
     * @return float|null
     */
    public function getSumAmount()
    {
        return $this->sumAmount;
    }
    /**
     * Set sumAmount value
     * @param float $sumAmount
     * @return Bill
     */
    public function setSumAmount($sumAmount = null)
    {
        // validation for constraint: float
        if (!is_null($sumAmount) && !(is_float($sumAmount) || is_numeric($sumAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sumAmount, true), gettype($sumAmount)), __LINE__);
        }
        $this->sumAmount = $sumAmount;
        return $this;
    }
    /**
     * Get billPDF value
     * @return string|null
     */
    public function getBillPDF()
    {
        return $this->billPDF;
    }
    /**
     * Set billPDF value
     * @param string $billPDF
     * @return Bill
     */
    public function setBillPDF($billPDF = null)
    {
        // validation for constraint: string
        if (!is_null($billPDF) && !is_string($billPDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billPDF, true), gettype($billPDF)), __LINE__);
        }
        $this->billPDF = $billPDF;
        return $this;
    }
    /**
     * Get billEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return BillEntry[]|null
     */
    public function getBillEntries()
    {
        return isset($this->billEntries) ? $this->billEntries : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBillEntries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillEntries method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillEntriesForArrayConstraintsFromSetBillEntries(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billBillEntriesItem) {
            // validation for constraint: itemType
            if (!$billBillEntriesItem instanceof BillEntry) {
                $invalidValues[] = is_object($billBillEntriesItem) ? get_class($billBillEntriesItem) : sprintf('%s(%s)', gettype($billBillEntriesItem), var_export($billBillEntriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The billEntries property can only contain items of type BillEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set billEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param BillEntry[] $billEntries
     * @return Bill
     */
    public function setBillEntries(array $billEntries = array())
    {
        // validation for constraint: array
        if ('' !== ($billEntriesArrayErrorMessage = self::validateBillEntriesForArrayConstraintsFromSetBillEntries($billEntries))) {
            throw new \InvalidArgumentException($billEntriesArrayErrorMessage, __LINE__);
        }
        if (is_null($billEntries) || (is_array($billEntries) && empty($billEntries))) {
            unset($this->billEntries);
        } else {
            $this->billEntries = $billEntries;
        }
        return $this;
    }
    /**
     * Add item to billEntries value
     * @throws \InvalidArgumentException
     * @param BillEntry $item
     * @return Bill
     */
    public function addToBillEntries(BillEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof BillEntry) {
            throw new \InvalidArgumentException(sprintf('The billEntries property can only contain items of type BillEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->billEntries[] = $item;
        return $this;
    }
}
