<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for trackResponseType Structure
 * @subpackage Structs
 */
class TrackResponseType extends AbstractStructBase
{
    /**
     * The status
     * @var Status
     */
    public $status;
    /**
     * The trackConsignmentResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var TrackConsignmentResponse[]
     */
    public $trackConsignmentResponses;
    /**
     * Constructor method for trackResponseType
     * @uses TrackResponseType::setStatus()
     * @uses TrackResponseType::setTrackConsignmentResponses()
     * @param Status $status
     * @param TrackConsignmentResponse[] $trackConsignmentResponses
     */
    public function __construct(Status $status = null, array $trackConsignmentResponses = array())
    {
        $this
            ->setStatus($status)
            ->setTrackConsignmentResponses($trackConsignmentResponses);
    }
    /**
     * Get status value
     * @return Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param Status $status
     * @return TrackResponseType
     */
    public function setStatus(Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get trackConsignmentResponses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return TrackConsignmentResponse[]|null
     */
    public function getTrackConsignmentResponses()
    {
        return isset($this->trackConsignmentResponses) ? $this->trackConsignmentResponses : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTrackConsignmentResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackConsignmentResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrackConsignmentResponsesForArrayConstraintsFromSetTrackConsignmentResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackResponseTypeTrackConsignmentResponsesItem) {
            // validation for constraint: itemType
            if (!$trackResponseTypeTrackConsignmentResponsesItem instanceof TrackConsignmentResponse) {
                $invalidValues[] = is_object($trackResponseTypeTrackConsignmentResponsesItem) ? get_class($trackResponseTypeTrackConsignmentResponsesItem) : sprintf('%s(%s)', gettype($trackResponseTypeTrackConsignmentResponsesItem), var_export($trackResponseTypeTrackConsignmentResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The trackConsignmentResponses property can only contain items of type TrackConsignmentResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set trackConsignmentResponses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param TrackConsignmentResponse[] $trackConsignmentResponses
     * @return TrackResponseType
     */
    public function setTrackConsignmentResponses(array $trackConsignmentResponses = array())
    {
        // validation for constraint: array
        if ('' !== ($trackConsignmentResponsesArrayErrorMessage = self::validateTrackConsignmentResponsesForArrayConstraintsFromSetTrackConsignmentResponses($trackConsignmentResponses))) {
            throw new \InvalidArgumentException($trackConsignmentResponsesArrayErrorMessage, __LINE__);
        }
        if (is_null($trackConsignmentResponses) || (is_array($trackConsignmentResponses) && empty($trackConsignmentResponses))) {
            unset($this->trackConsignmentResponses);
        } else {
            $this->trackConsignmentResponses = $trackConsignmentResponses;
        }
        return $this;
    }
    /**
     * Add item to trackConsignmentResponses value
     * @throws \InvalidArgumentException
     * @param TrackConsignmentResponse $item
     * @return TrackResponseType
     */
    public function addToTrackConsignmentResponses(TrackConsignmentResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TrackConsignmentResponse) {
            throw new \InvalidArgumentException(sprintf('The trackConsignmentResponses property can only contain items of type TrackConsignmentResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->trackConsignmentResponses[] = $item;
        return $this;
    }
}
