<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for trackRequest Structure
 * @subpackage Structs
 */
class TrackRequest extends AbstractStructBase
{
    /**
     * The credentials
     * @var Credential
     */
    public $credentials;
    /**
     * The consignmentIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $consignmentIDs;
    /**
     * The noActivities
     * @var bool
     */
    public $noActivities;
    /**
     * Constructor method for trackRequest
     * @uses TrackRequest::setCredentials()
     * @uses TrackRequest::setConsignmentIDs()
     * @uses TrackRequest::setNoActivities()
     * @param Credential $credentials
     * @param int[] $consignmentIDs
     * @param bool $noActivities
     */
    public function __construct(Credential $credentials = null, array $consignmentIDs = array(), $noActivities = null)
    {
        $this
            ->setCredentials($credentials)
            ->setConsignmentIDs($consignmentIDs)
            ->setNoActivities($noActivities);
    }
    /**
     * Get credentials value
     * @return Credential|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param Credential $credentials
     * @return TrackRequest
     */
    public function setCredentials(Credential $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get consignmentIDs value
     * @return int[]|null
     */
    public function getConsignmentIDs()
    {
        return $this->consignmentIDs;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignmentIDs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignmentIDs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentIDsForArrayConstraintsFromSetConsignmentIDs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackRequestConsignmentIDsItem) {
            // validation for constraint: itemType
            if (!(is_int($trackRequestConsignmentIDsItem) || ctype_digit($trackRequestConsignmentIDsItem))) {
                $invalidValues[] = is_object($trackRequestConsignmentIDsItem) ? get_class($trackRequestConsignmentIDsItem) : sprintf('%s(%s)', gettype($trackRequestConsignmentIDsItem), var_export($trackRequestConsignmentIDsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consignmentIDs property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consignmentIDs value
     * @throws \InvalidArgumentException
     * @param int[] $consignmentIDs
     * @return TrackRequest
     */
    public function setConsignmentIDs(array $consignmentIDs = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentIDsArrayErrorMessage = self::validateConsignmentIDsForArrayConstraintsFromSetConsignmentIDs($consignmentIDs))) {
            throw new \InvalidArgumentException($consignmentIDsArrayErrorMessage, __LINE__);
        }
        $this->consignmentIDs = $consignmentIDs;
        return $this;
    }
    /**
     * Add item to consignmentIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return TrackRequest
     */
    public function addToConsignmentIDs($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The consignmentIDs property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->consignmentIDs[] = $item;
        return $this;
    }
    /**
     * Get noActivities value
     * @return bool|null
     */
    public function getNoActivities()
    {
        return $this->noActivities;
    }
    /**
     * Set noActivities value
     * @param bool $noActivities
     * @return TrackRequest
     */
    public function setNoActivities($noActivities = null)
    {
        // validation for constraint: boolean
        if (!is_null($noActivities) && !is_bool($noActivities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noActivities, true), gettype($noActivities)), __LINE__);
        }
        $this->noActivities = $noActivities;
        return $this;
    }
}
