<?php
use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for packagingType Enums
 * @subpackage Enumerations
 */
class PackagingType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'UNPACKED'
     * @return string 'UNPACKED'
     */
    const VALUE_UNPACKED = 'UNPACKED';
    /**
     * Constant for value 'ENVELOPE'
     * @return string 'ENVELOPE'
     */
    const VALUE_ENVELOPE = 'ENVELOPE';
    /**
     * Constant for value 'CARTON'
     * @return string 'CARTON'
     */
    const VALUE_CARTON = 'CARTON';
    /**
     * Constant for value 'PALLET'
     * @return string 'PALLET'
     */
    const VALUE_PALLET = 'PALLET';
    /**
     * Constant for value 'OWN_PACKAGING'
     * @return string 'OWN_PACKAGING'
     */
    const VALUE_OWN_PACKAGING = 'OWN_PACKAGING';
    /**
     * Return allowed values
     * @uses self::VALUE_UNPACKED
     * @uses self::VALUE_ENVELOPE
     * @uses self::VALUE_CARTON
     * @uses self::VALUE_PALLET
     * @uses self::VALUE_OWN_PACKAGING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNPACKED,
            self::VALUE_ENVELOPE,
            self::VALUE_CARTON,
            self::VALUE_PALLET,
            self::VALUE_OWN_PACKAGING,
        );
    }
}
