<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for labelsResponseType Structure
 * @subpackage Structs
 */
class LabelsResponseType extends AbstractStructBase
{
    /**
     * The status
     * @var Status
     */
    public $status;
    /**
     * The labelsResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var LabelsResponse[]
     */
    public $labelsResponses;
    /**
     * Constructor method for labelsResponseType
     * @uses LabelsResponseType::setStatus()
     * @uses LabelsResponseType::setLabelsResponses()
     * @param Status $status
     * @param LabelsResponse[] $labelsResponses
     */
    public function __construct(Status $status = null, array $labelsResponses = array())
    {
        $this
            ->setStatus($status)
            ->setLabelsResponses($labelsResponses);
    }
    /**
     * Get status value
     * @return Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param Status $status
     * @return LabelsResponseType
     */
    public function setStatus(Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get labelsResponses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return LabelsResponse[]|null
     */
    public function getLabelsResponses()
    {
        return isset($this->labelsResponses) ? $this->labelsResponses : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLabelsResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelsResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelsResponsesForArrayConstraintsFromSetLabelsResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $labelsResponseTypeLabelsResponsesItem) {
            // validation for constraint: itemType
            if (!$labelsResponseTypeLabelsResponsesItem instanceof LabelsResponse) {
                $invalidValues[] = is_object($labelsResponseTypeLabelsResponsesItem) ? get_class($labelsResponseTypeLabelsResponsesItem) : sprintf('%s(%s)', gettype($labelsResponseTypeLabelsResponsesItem), var_export($labelsResponseTypeLabelsResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The labelsResponses property can only contain items of type LabelsResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set labelsResponses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param LabelsResponse[] $labelsResponses
     * @return LabelsResponseType
     */
    public function setLabelsResponses(array $labelsResponses = array())
    {
        // validation for constraint: array
        if ('' !== ($labelsResponsesArrayErrorMessage = self::validateLabelsResponsesForArrayConstraintsFromSetLabelsResponses($labelsResponses))) {
            throw new \InvalidArgumentException($labelsResponsesArrayErrorMessage, __LINE__);
        }
        if (is_null($labelsResponses) || (is_array($labelsResponses) && empty($labelsResponses))) {
            unset($this->labelsResponses);
        } else {
            $this->labelsResponses = $labelsResponses;
        }
        return $this;
    }
    /**
     * Add item to labelsResponses value
     * @throws \InvalidArgumentException
     * @param LabelsResponse $item
     * @return LabelsResponseType
     */
    public function addToLabelsResponses(LabelsResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof LabelsResponse) {
            throw new \InvalidArgumentException(sprintf('The labelsResponses property can only contain items of type LabelsResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->labelsResponses[] = $item;
        return $this;
    }
}
