<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for costResponseType Structure
 * @subpackage Structs
 */
class CostResponseType extends AbstractStructBase
{
    /**
     * The status
     * @var Status
     */
    public $status;
    /**
     * The costResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var CostResponse[]
     */
    public $costResponse;
    /**
     * Constructor method for costResponseType
     * @uses CostResponseType::setStatus()
     * @uses CostResponseType::setCostResponse()
     * @param Status $status
     * @param CostResponse[] $costResponse
     */
    public function __construct(Status $status = null, array $costResponse = array())
    {
        $this
            ->setStatus($status)
            ->setCostResponse($costResponse);
    }
    /**
     * Get status value
     * @return Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param Status $status
     * @return CostResponseType
     */
    public function setStatus(Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get costResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return CostResponse[]|null
     */
    public function getCostResponse()
    {
        return isset($this->costResponse) ? $this->costResponse : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCostResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostResponseForArrayConstraintsFromSetCostResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costResponseTypeCostResponseItem) {
            // validation for constraint: itemType
            if (!$costResponseTypeCostResponseItem instanceof CostResponse) {
                $invalidValues[] = is_object($costResponseTypeCostResponseItem) ? get_class($costResponseTypeCostResponseItem) : sprintf('%s(%s)', gettype($costResponseTypeCostResponseItem), var_export($costResponseTypeCostResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The costResponse property can only contain items of type CostResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set costResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param CostResponse[] $costResponse
     * @return CostResponseType
     */
    public function setCostResponse(array $costResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($costResponseArrayErrorMessage = self::validateCostResponseForArrayConstraintsFromSetCostResponse($costResponse))) {
            throw new \InvalidArgumentException($costResponseArrayErrorMessage, __LINE__);
        }
        if (is_null($costResponse) || (is_array($costResponse) && empty($costResponse))) {
            unset($this->costResponse);
        } else {
            $this->costResponse = $costResponse;
        }
        return $this;
    }
    /**
     * Add item to costResponse value
     * @throws \InvalidArgumentException
     * @param CostResponse $item
     * @return CostResponseType
     */
    public function addToCostResponse(CostResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof CostResponse) {
            throw new \InvalidArgumentException(sprintf('The costResponse property can only contain items of type CostResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->costResponse[] = $item;
        return $this;
    }
}
