<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for costResponse Structure
 * @subpackage Structs
 */
class CostResponse extends AbstractStructBase
{
    /**
     * The consignmentID
     * @var int
     */
    public $consignmentID;
    /**
     * The totalCost
     * @var float
     */
    public $totalCost;
    /**
     * The costStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costStatus;
    /**
     * The costPositions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var CostPosition[]
     */
    public $costPositions;
    /**
     * Constructor method for costResponse
     * @uses CostResponse::setConsignmentID()
     * @uses CostResponse::setTotalCost()
     * @uses CostResponse::setCostStatus()
     * @uses CostResponse::setCostPositions()
     * @param int $consignmentID
     * @param float $totalCost
     * @param string $costStatus
     * @param CostPosition[] $costPositions
     */
    public function __construct($consignmentID = null, $totalCost = null, $costStatus = null, array $costPositions = array())
    {
        $this
            ->setConsignmentID($consignmentID)
            ->setTotalCost($totalCost)
            ->setCostStatus($costStatus)
            ->setCostPositions($costPositions);
    }
    /**
     * Get consignmentID value
     * @return int|null
     */
    public function getConsignmentID()
    {
        return $this->consignmentID;
    }
    /**
     * Set consignmentID value
     * @param int $consignmentID
     * @return CostResponse
     */
    public function setConsignmentID($consignmentID = null)
    {
        // validation for constraint: int
        if (!is_null($consignmentID) && !(is_int($consignmentID) || ctype_digit($consignmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consignmentID, true), gettype($consignmentID)), __LINE__);
        }
        $this->consignmentID = $consignmentID;
        return $this;
    }
    /**
     * Get totalCost value
     * @return float|null
     */
    public function getTotalCost()
    {
        return $this->totalCost;
    }
    /**
     * Set totalCost value
     * @param float $totalCost
     * @return CostResponse
     */
    public function setTotalCost($totalCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalCost) && !(is_float($totalCost) || is_numeric($totalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCost, true), gettype($totalCost)), __LINE__);
        }
        $this->totalCost = $totalCost;
        return $this;
    }
    /**
     * Get costStatus value
     * @return string|null
     */
    public function getCostStatus()
    {
        return $this->costStatus;
    }
    /**
     * Set costStatus value
     * @uses CostStatus::valueIsValid()
     * @uses CostStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costStatus
     * @return CostResponse
     */
    public function setCostStatus($costStatus = null)
    {
        // validation for constraint: enumeration
        if (!CostStatus::valueIsValid($costStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class CostStatus', is_array($costStatus) ? implode(', ', $costStatus) : var_export($costStatus, true), implode(', ', CostStatus::getValidValues())), __LINE__);
        }
        $this->costStatus = $costStatus;
        return $this;
    }
    /**
     * Get costPositions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return CostPosition[]|null
     */
    public function getCostPositions()
    {
        return isset($this->costPositions) ? $this->costPositions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCostPositions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostPositions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostPositionsForArrayConstraintsFromSetCostPositions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costResponseCostPositionsItem) {
            // validation for constraint: itemType
            if (!$costResponseCostPositionsItem instanceof CostPosition) {
                $invalidValues[] = is_object($costResponseCostPositionsItem) ? get_class($costResponseCostPositionsItem) : sprintf('%s(%s)', gettype($costResponseCostPositionsItem), var_export($costResponseCostPositionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The costPositions property can only contain items of type CostPosition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set costPositions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param CostPosition[] $costPositions
     * @return CostResponse
     */
    public function setCostPositions(array $costPositions = array())
    {
        // validation for constraint: array
        if ('' !== ($costPositionsArrayErrorMessage = self::validateCostPositionsForArrayConstraintsFromSetCostPositions($costPositions))) {
            throw new \InvalidArgumentException($costPositionsArrayErrorMessage, __LINE__);
        }
        if (is_null($costPositions) || (is_array($costPositions) && empty($costPositions))) {
            unset($this->costPositions);
        } else {
            $this->costPositions = $costPositions;
        }
        return $this;
    }
    /**
     * Add item to costPositions value
     * @throws \InvalidArgumentException
     * @param CostPosition $item
     * @return CostResponse
     */
    public function addToCostPositions(CostPosition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof CostPosition) {
            throw new \InvalidArgumentException(sprintf('The costPositions property can only contain items of type CostPosition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->costPositions[] = $item;
        return $this;
    }
}
