<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for billEntry Structure
 * @subpackage Structs
 */
class BillEntry extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The amount
     * @var float
     */
    public $amount;
    /**
     * The taxable
     * @var bool
     */
    public $taxable;
    /**
     * The consignmentID
     * @var int
     */
    public $consignmentID;
    /**
     * The consignmentRefernce
     * @var int
     */
    public $consignmentRefernce;
    /**
     * The reference1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference1;
    /**
     * The reference2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference2;
    /**
     * Constructor method for billEntry
     * @uses BillEntry::setName()
     * @uses BillEntry::setAmount()
     * @uses BillEntry::setTaxable()
     * @uses BillEntry::setConsignmentID()
     * @uses BillEntry::setConsignmentRefernce()
     * @uses BillEntry::setReference1()
     * @uses BillEntry::setReference2()
     * @param string $name
     * @param float $amount
     * @param bool $taxable
     * @param int $consignmentID
     * @param int $consignmentRefernce
     * @param string $reference1
     * @param string $reference2
     */
    public function __construct($name = null, $amount = null, $taxable = null, $consignmentID = null, $consignmentRefernce = null, $reference1 = null, $reference2 = null)
    {
        $this
            ->setName($name)
            ->setAmount($amount)
            ->setTaxable($taxable)
            ->setConsignmentID($consignmentID)
            ->setConsignmentRefernce($consignmentRefernce)
            ->setReference1($reference1)
            ->setReference2($reference2);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return BillEntry
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return BillEntry
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get taxable value
     * @return bool|null
     */
    public function getTaxable()
    {
        return $this->taxable;
    }
    /**
     * Set taxable value
     * @param bool $taxable
     * @return BillEntry
     */
    public function setTaxable($taxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxable) && !is_bool($taxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxable, true), gettype($taxable)), __LINE__);
        }
        $this->taxable = $taxable;
        return $this;
    }
    /**
     * Get consignmentID value
     * @return int|null
     */
    public function getConsignmentID()
    {
        return $this->consignmentID;
    }
    /**
     * Set consignmentID value
     * @param int $consignmentID
     * @return BillEntry
     */
    public function setConsignmentID($consignmentID = null)
    {
        // validation for constraint: int
        if (!is_null($consignmentID) && !(is_int($consignmentID) || ctype_digit($consignmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consignmentID, true), gettype($consignmentID)), __LINE__);
        }
        $this->consignmentID = $consignmentID;
        return $this;
    }
    /**
     * Get consignmentRefernce value
     * @return int|null
     */
    public function getConsignmentRefernce()
    {
        return $this->consignmentRefernce;
    }
    /**
     * Set consignmentRefernce value
     * @param int $consignmentRefernce
     * @return BillEntry
     */
    public function setConsignmentRefernce($consignmentRefernce = null)
    {
        // validation for constraint: int
        if (!is_null($consignmentRefernce) && !(is_int($consignmentRefernce) || ctype_digit($consignmentRefernce))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consignmentRefernce, true), gettype($consignmentRefernce)), __LINE__);
        }
        $this->consignmentRefernce = $consignmentRefernce;
        return $this;
    }
    /**
     * Get reference1 value
     * @return string|null
     */
    public function getReference1()
    {
        return $this->reference1;
    }
    /**
     * Set reference1 value
     * @param string $reference1
     * @return BillEntry
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference1, true), gettype($reference1)), __LINE__);
        }
        $this->reference1 = $reference1;
        return $this;
    }
    /**
     * Get reference2 value
     * @return string|null
     */
    public function getReference2()
    {
        return $this->reference2;
    }
    /**
     * Set reference2 value
     * @param string $reference2
     * @return BillEntry
     */
    public function setReference2($reference2 = null)
    {
        // validation for constraint: string
        if (!is_null($reference2) && !is_string($reference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference2, true), gettype($reference2)), __LINE__);
        }
        $this->reference2 = $reference2;
        return $this;
    }
}
