<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Advogado StructType
 * @subpackage Structs
 */
class Advogado extends BaseModel
{
    /**
     * The inscricaoOAB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inscricaoOAB;
    /**
     * The idUnica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idUnica;
    /**
     * The ufInscricaoOAB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ufInscricaoOAB;
    /**
     * Constructor method for Advogado
     * @uses Advogado::setInscricaoOAB()
     * @uses Advogado::setIdUnica()
     * @uses Advogado::setUfInscricaoOAB()
     * @param string $inscricaoOAB
     * @param int $idUnica
     * @param string $ufInscricaoOAB
     */
    public function __construct($inscricaoOAB = null, $idUnica = null, $ufInscricaoOAB = null)
    {
        $this
            ->setInscricaoOAB($inscricaoOAB)
            ->setIdUnica($idUnica)
            ->setUfInscricaoOAB($ufInscricaoOAB);
    }
    /**
     * Get inscricaoOAB value
     * @return string|null
     */
    public function getInscricaoOAB()
    {
        return $this->inscricaoOAB;
    }
    /**
     * Set inscricaoOAB value
     * @param string $inscricaoOAB
     * @return \StructType\Advogado
     */
    public function setInscricaoOAB($inscricaoOAB = null)
    {
        // validation for constraint: string
        if (!is_null($inscricaoOAB) && !is_string($inscricaoOAB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inscricaoOAB, true), gettype($inscricaoOAB)), __LINE__);
        }
        $this->inscricaoOAB = $inscricaoOAB;
        return $this;
    }
    /**
     * Get idUnica value
     * @return int|null
     */
    public function getIdUnica()
    {
        return $this->idUnica;
    }
    /**
     * Set idUnica value
     * @param int $idUnica
     * @return \StructType\Advogado
     */
    public function setIdUnica($idUnica = null)
    {
        // validation for constraint: int
        if (!is_null($idUnica) && !(is_int($idUnica) || ctype_digit($idUnica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idUnica, true), gettype($idUnica)), __LINE__);
        }
        $this->idUnica = $idUnica;
        return $this;
    }
    /**
     * Get ufInscricaoOAB value
     * @return string|null
     */
    public function getUfInscricaoOAB()
    {
        return $this->ufInscricaoOAB;
    }
    /**
     * Set ufInscricaoOAB value
     * @param string $ufInscricaoOAB
     * @return \StructType\Advogado
     */
    public function setUfInscricaoOAB($ufInscricaoOAB = null)
    {
        // validation for constraint: string
        if (!is_null($ufInscricaoOAB) && !is_string($ufInscricaoOAB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ufInscricaoOAB, true), gettype($ufInscricaoOAB)), __LINE__);
        }
        $this->ufInscricaoOAB = $ufInscricaoOAB;
        return $this;
    }
}
