<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rubrica StructType
 * @subpackage Structs
 */
class Rubrica_1 extends AbstractStructBase
{
    /**
     * The anoMesFichaFinanceira
     * @var int
     */
    public $anoMesFichaFinanceira;
    /**
     * The codigoOrgao
     * @var int
     */
    public $codigoOrgao;
    /**
     * The codigoRubrica
     * @var int
     */
    public $codigoRubrica;
    /**
     * The indRendimentoDesconto
     * @var string
     */
    public $indRendimentoDesconto;
    /**
     * The nroSequenciaRubrica
     * @var string
     */
    public $nroSequenciaRubrica;
    /**
     * The numeroMatriculaBeneficiario
     * @var int
     */
    public $numeroMatriculaBeneficiario;
    /**
     * The numeroMatriculaServidor
     * @var int
     */
    public $numeroMatriculaServidor;
    /**
     * The tipoFolha
     * @var string
     */
    public $tipoFolha;
    /**
     * The valorRubrica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $valorRubrica;
    /**
     * Constructor method for rubrica
     * @uses Rubrica_1::setAnoMesFichaFinanceira()
     * @uses Rubrica_1::setCodigoOrgao()
     * @uses Rubrica_1::setCodigoRubrica()
     * @uses Rubrica_1::setIndRendimentoDesconto()
     * @uses Rubrica_1::setNroSequenciaRubrica()
     * @uses Rubrica_1::setNumeroMatriculaBeneficiario()
     * @uses Rubrica_1::setNumeroMatriculaServidor()
     * @uses Rubrica_1::setTipoFolha()
     * @uses Rubrica_1::setValorRubrica()
     * @param int $anoMesFichaFinanceira
     * @param int $codigoOrgao
     * @param int $codigoRubrica
     * @param string $indRendimentoDesconto
     * @param string $nroSequenciaRubrica
     * @param int $numeroMatriculaBeneficiario
     * @param int $numeroMatriculaServidor
     * @param string $tipoFolha
     * @param float $valorRubrica
     */
    public function __construct($anoMesFichaFinanceira = null, $codigoOrgao = null, $codigoRubrica = null, $indRendimentoDesconto = null, $nroSequenciaRubrica = null, $numeroMatriculaBeneficiario = null, $numeroMatriculaServidor = null, $tipoFolha = null, $valorRubrica = null)
    {
        $this
            ->setAnoMesFichaFinanceira($anoMesFichaFinanceira)
            ->setCodigoOrgao($codigoOrgao)
            ->setCodigoRubrica($codigoRubrica)
            ->setIndRendimentoDesconto($indRendimentoDesconto)
            ->setNroSequenciaRubrica($nroSequenciaRubrica)
            ->setNumeroMatriculaBeneficiario($numeroMatriculaBeneficiario)
            ->setNumeroMatriculaServidor($numeroMatriculaServidor)
            ->setTipoFolha($tipoFolha)
            ->setValorRubrica($valorRubrica);
    }
    /**
     * Get anoMesFichaFinanceira value
     * @return int|null
     */
    public function getAnoMesFichaFinanceira()
    {
        return $this->anoMesFichaFinanceira;
    }
    /**
     * Set anoMesFichaFinanceira value
     * @param int $anoMesFichaFinanceira
     * @return \StructType\Rubrica_1
     */
    public function setAnoMesFichaFinanceira($anoMesFichaFinanceira = null)
    {
        // validation for constraint: int
        if (!is_null($anoMesFichaFinanceira) && !(is_int($anoMesFichaFinanceira) || ctype_digit($anoMesFichaFinanceira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anoMesFichaFinanceira, true), gettype($anoMesFichaFinanceira)), __LINE__);
        }
        $this->anoMesFichaFinanceira = $anoMesFichaFinanceira;
        return $this;
    }
    /**
     * Get codigoOrgao value
     * @return int|null
     */
    public function getCodigoOrgao()
    {
        return $this->codigoOrgao;
    }
    /**
     * Set codigoOrgao value
     * @param int $codigoOrgao
     * @return \StructType\Rubrica_1
     */
    public function setCodigoOrgao($codigoOrgao = null)
    {
        // validation for constraint: int
        if (!is_null($codigoOrgao) && !(is_int($codigoOrgao) || ctype_digit($codigoOrgao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoOrgao, true), gettype($codigoOrgao)), __LINE__);
        }
        $this->codigoOrgao = $codigoOrgao;
        return $this;
    }
    /**
     * Get codigoRubrica value
     * @return int|null
     */
    public function getCodigoRubrica()
    {
        return $this->codigoRubrica;
    }
    /**
     * Set codigoRubrica value
     * @param int $codigoRubrica
     * @return \StructType\Rubrica_1
     */
    public function setCodigoRubrica($codigoRubrica = null)
    {
        // validation for constraint: int
        if (!is_null($codigoRubrica) && !(is_int($codigoRubrica) || ctype_digit($codigoRubrica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoRubrica, true), gettype($codigoRubrica)), __LINE__);
        }
        $this->codigoRubrica = $codigoRubrica;
        return $this;
    }
    /**
     * Get indRendimentoDesconto value
     * @return string|null
     */
    public function getIndRendimentoDesconto()
    {
        return $this->indRendimentoDesconto;
    }
    /**
     * Set indRendimentoDesconto value
     * @param string $indRendimentoDesconto
     * @return \StructType\Rubrica_1
     */
    public function setIndRendimentoDesconto($indRendimentoDesconto = null)
    {
        // validation for constraint: string
        if (!is_null($indRendimentoDesconto) && !is_string($indRendimentoDesconto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indRendimentoDesconto, true), gettype($indRendimentoDesconto)), __LINE__);
        }
        $this->indRendimentoDesconto = $indRendimentoDesconto;
        return $this;
    }
    /**
     * Get nroSequenciaRubrica value
     * @return string|null
     */
    public function getNroSequenciaRubrica()
    {
        return $this->nroSequenciaRubrica;
    }
    /**
     * Set nroSequenciaRubrica value
     * @param string $nroSequenciaRubrica
     * @return \StructType\Rubrica_1
     */
    public function setNroSequenciaRubrica($nroSequenciaRubrica = null)
    {
        // validation for constraint: string
        if (!is_null($nroSequenciaRubrica) && !is_string($nroSequenciaRubrica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nroSequenciaRubrica, true), gettype($nroSequenciaRubrica)), __LINE__);
        }
        $this->nroSequenciaRubrica = $nroSequenciaRubrica;
        return $this;
    }
    /**
     * Get numeroMatriculaBeneficiario value
     * @return int|null
     */
    public function getNumeroMatriculaBeneficiario()
    {
        return $this->numeroMatriculaBeneficiario;
    }
    /**
     * Set numeroMatriculaBeneficiario value
     * @param int $numeroMatriculaBeneficiario
     * @return \StructType\Rubrica_1
     */
    public function setNumeroMatriculaBeneficiario($numeroMatriculaBeneficiario = null)
    {
        // validation for constraint: int
        if (!is_null($numeroMatriculaBeneficiario) && !(is_int($numeroMatriculaBeneficiario) || ctype_digit($numeroMatriculaBeneficiario))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroMatriculaBeneficiario, true), gettype($numeroMatriculaBeneficiario)), __LINE__);
        }
        $this->numeroMatriculaBeneficiario = $numeroMatriculaBeneficiario;
        return $this;
    }
    /**
     * Get numeroMatriculaServidor value
     * @return int|null
     */
    public function getNumeroMatriculaServidor()
    {
        return $this->numeroMatriculaServidor;
    }
    /**
     * Set numeroMatriculaServidor value
     * @param int $numeroMatriculaServidor
     * @return \StructType\Rubrica_1
     */
    public function setNumeroMatriculaServidor($numeroMatriculaServidor = null)
    {
        // validation for constraint: int
        if (!is_null($numeroMatriculaServidor) && !(is_int($numeroMatriculaServidor) || ctype_digit($numeroMatriculaServidor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroMatriculaServidor, true), gettype($numeroMatriculaServidor)), __LINE__);
        }
        $this->numeroMatriculaServidor = $numeroMatriculaServidor;
        return $this;
    }
    /**
     * Get tipoFolha value
     * @return string|null
     */
    public function getTipoFolha()
    {
        return $this->tipoFolha;
    }
    /**
     * Set tipoFolha value
     * @param string $tipoFolha
     * @return \StructType\Rubrica_1
     */
    public function setTipoFolha($tipoFolha = null)
    {
        // validation for constraint: string
        if (!is_null($tipoFolha) && !is_string($tipoFolha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoFolha, true), gettype($tipoFolha)), __LINE__);
        }
        $this->tipoFolha = $tipoFolha;
        return $this;
    }
    /**
     * Get valorRubrica value
     * @return float|null
     */
    public function getValorRubrica()
    {
        return $this->valorRubrica;
    }
    /**
     * Set valorRubrica value
     * @param float $valorRubrica
     * @return \StructType\Rubrica_1
     */
    public function setValorRubrica($valorRubrica = null)
    {
        // validation for constraint: float
        if (!is_null($valorRubrica) && !(is_float($valorRubrica) || is_numeric($valorRubrica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorRubrica, true), gettype($valorRubrica)), __LINE__);
        }
        $this->valorRubrica = $valorRubrica;
        return $this;
    }
}
