<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getFichaFinanceira StructType
 * Meta information extracted from the WSDL
 * - type: tns:getFichaFinanceira
 * @subpackage Structs
 */
class GetFichaFinanceira extends AbstractStructBase
{
    /**
     * The codigoOrgao
     * @var int
     */
    public $codigoOrgao;
    /**
     * The matricula
     * @var int
     */
    public $matricula;
    /**
     * The matriculaBeneficiario
     * @var int
     */
    public $matriculaBeneficiario;
    /**
     * The ano
     * @var int
     */
    public $ano;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * Constructor method for getFichaFinanceira
     * @uses GetFichaFinanceira::setCodigoOrgao()
     * @uses GetFichaFinanceira::setMatricula()
     * @uses GetFichaFinanceira::setMatriculaBeneficiario()
     * @uses GetFichaFinanceira::setAno()
     * @uses GetFichaFinanceira::setToken()
     * @param int $codigoOrgao
     * @param int $matricula
     * @param int $matriculaBeneficiario
     * @param int $ano
     * @param string $token
     */
    public function __construct($codigoOrgao = null, $matricula = null, $matriculaBeneficiario = null, $ano = null, $token = null)
    {
        $this
            ->setCodigoOrgao($codigoOrgao)
            ->setMatricula($matricula)
            ->setMatriculaBeneficiario($matriculaBeneficiario)
            ->setAno($ano)
            ->setToken($token);
    }
    /**
     * Get codigoOrgao value
     * @return int|null
     */
    public function getCodigoOrgao()
    {
        return $this->codigoOrgao;
    }
    /**
     * Set codigoOrgao value
     * @param int $codigoOrgao
     * @return \StructType\GetFichaFinanceira
     */
    public function setCodigoOrgao($codigoOrgao = null)
    {
        // validation for constraint: int
        if (!is_null($codigoOrgao) && !(is_int($codigoOrgao) || ctype_digit($codigoOrgao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoOrgao, true), gettype($codigoOrgao)), __LINE__);
        }
        $this->codigoOrgao = $codigoOrgao;
        return $this;
    }
    /**
     * Get matricula value
     * @return int|null
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
    /**
     * Set matricula value
     * @param int $matricula
     * @return \StructType\GetFichaFinanceira
     */
    public function setMatricula($matricula = null)
    {
        // validation for constraint: int
        if (!is_null($matricula) && !(is_int($matricula) || ctype_digit($matricula))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matricula, true), gettype($matricula)), __LINE__);
        }
        $this->matricula = $matricula;
        return $this;
    }
    /**
     * Get matriculaBeneficiario value
     * @return int|null
     */
    public function getMatriculaBeneficiario()
    {
        return $this->matriculaBeneficiario;
    }
    /**
     * Set matriculaBeneficiario value
     * @param int $matriculaBeneficiario
     * @return \StructType\GetFichaFinanceira
     */
    public function setMatriculaBeneficiario($matriculaBeneficiario = null)
    {
        // validation for constraint: int
        if (!is_null($matriculaBeneficiario) && !(is_int($matriculaBeneficiario) || ctype_digit($matriculaBeneficiario))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matriculaBeneficiario, true), gettype($matriculaBeneficiario)), __LINE__);
        }
        $this->matriculaBeneficiario = $matriculaBeneficiario;
        return $this;
    }
    /**
     * Get ano value
     * @return int|null
     */
    public function getAno()
    {
        return $this->ano;
    }
    /**
     * Set ano value
     * @param int $ano
     * @return \StructType\GetFichaFinanceira
     */
    public function setAno($ano = null)
    {
        // validation for constraint: int
        if (!is_null($ano) && !(is_int($ano) || ctype_digit($ano))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ano, true), gettype($ano)), __LINE__);
        }
        $this->ano = $ano;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\GetFichaFinanceira
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
}
