<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campo StructType
 * @subpackage Structs
 */
class Campo extends AbstractStructBase
{
    /**
     * The ordem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ordem;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * The valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $valor;
    /**
     * Constructor method for Campo
     * @uses Campo::setOrdem()
     * @uses Campo::setNome()
     * @uses Campo::setValor()
     * @param int $ordem
     * @param string $nome
     * @param string $valor
     */
    public function __construct($ordem = null, $nome = null, $valor = null)
    {
        $this
            ->setOrdem($ordem)
            ->setNome($nome)
            ->setValor($valor);
    }
    /**
     * Get ordem value
     * @return int|null
     */
    public function getOrdem()
    {
        return $this->ordem;
    }
    /**
     * Set ordem value
     * @param int $ordem
     * @return \StructType\Campo
     */
    public function setOrdem($ordem = null)
    {
        // validation for constraint: int
        if (!is_null($ordem) && !(is_int($ordem) || ctype_digit($ordem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordem, true), gettype($ordem)), __LINE__);
        }
        $this->ordem = $ordem;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\Campo
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get valor value
     * @return string|null
     */
    public function getValor()
    {
        return $this->valor;
    }
    /**
     * Set valor value
     * @param string $valor
     * @return \StructType\Campo
     */
    public function setValor($valor = null)
    {
        // validation for constraint: string
        if (!is_null($valor) && !is_string($valor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->valor = $valor;
        return $this;
    }
}
