<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PessoaSiape StructType
 * @subpackage Structs
 */
abstract class PessoaSiape extends AbstractStructBase
{
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * The CPF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CPF;
    /**
     * The ano
     * @var int
     */
    public $ano;
    /**
     * Constructor method for PessoaSiape
     * @uses PessoaSiape::setNome()
     * @uses PessoaSiape::setCPF()
     * @uses PessoaSiape::setAno()
     * @param string $nome
     * @param string $cPF
     * @param int $ano
     */
    public function __construct($nome = null, $cPF = null, $ano = null)
    {
        $this
            ->setNome($nome)
            ->setCPF($cPF)
            ->setAno($ano);
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\PessoaSiape
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get CPF value
     * @return string|null
     */
    public function getCPF()
    {
        return $this->CPF;
    }
    /**
     * Set CPF value
     * @param string $cPF
     * @return \StructType\PessoaSiape
     */
    public function setCPF($cPF = null)
    {
        // validation for constraint: string
        if (!is_null($cPF) && !is_string($cPF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPF, true), gettype($cPF)), __LINE__);
        }
        $this->CPF = $cPF;
        return $this;
    }
    /**
     * Get ano value
     * @return int|null
     */
    public function getAno()
    {
        return $this->ano;
    }
    /**
     * Set ano value
     * @param int $ano
     * @return \StructType\PessoaSiape
     */
    public function setAno($ano = null)
    {
        // validation for constraint: int
        if (!is_null($ano) && !(is_int($ano) || ctype_digit($ano))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ano, true), gettype($ano)), __LINE__);
        }
        $this->ano = $ano;
        return $this;
    }
}
