<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Orgao StructType
 * @subpackage Structs
 */
class Orgao extends BaseModel
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigo;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * The sigla
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sigla;
    /**
     * The situacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $situacao;
    /**
     * Constructor method for Orgao
     * @uses Orgao::setCodigo()
     * @uses Orgao::setNome()
     * @uses Orgao::setSigla()
     * @uses Orgao::setSituacao()
     * @param int $codigo
     * @param string $nome
     * @param string $sigla
     * @param int $situacao
     */
    public function __construct($codigo = null, $nome = null, $sigla = null, $situacao = null)
    {
        $this
            ->setCodigo($codigo)
            ->setNome($nome)
            ->setSigla($sigla)
            ->setSituacao($situacao);
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\Orgao
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\Orgao
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get sigla value
     * @return string|null
     */
    public function getSigla()
    {
        return $this->sigla;
    }
    /**
     * Set sigla value
     * @param string $sigla
     * @return \StructType\Orgao
     */
    public function setSigla($sigla = null)
    {
        // validation for constraint: string
        if (!is_null($sigla) && !is_string($sigla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sigla, true), gettype($sigla)), __LINE__);
        }
        $this->sigla = $sigla;
        return $this;
    }
    /**
     * Get situacao value
     * @return int|null
     */
    public function getSituacao()
    {
        return $this->situacao;
    }
    /**
     * Set situacao value
     * @param int $situacao
     * @return \StructType\Orgao
     */
    public function setSituacao($situacao = null)
    {
        // validation for constraint: int
        if (!is_null($situacao) && !(is_int($situacao) || ctype_digit($situacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($situacao, true), gettype($situacao)), __LINE__);
        }
        $this->situacao = $situacao;
        return $this;
    }
}
