<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemFichaFinanceira StructType
 * @subpackage Structs
 */
class ItemFichaFinanceira extends AbstractStructBase
{
    /**
     * The codigo
     * @var int
     */
    public $codigo;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * The siglaAssunto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $siglaAssunto;
    /**
     * The rendimento
     * @var string
     */
    public $rendimento;
    /**
     * The sequencia
     * @var string
     */
    public $sequencia;
    /**
     * The dataPagamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dataPagamento;
    /**
     * The valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $valor;
    /**
     * The sinalFolha
     * @var int
     */
    public $sinalFolha;
    /**
     * The tipoFolha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tipoFolha;
    /**
     * Constructor method for ItemFichaFinanceira
     * @uses ItemFichaFinanceira::setCodigo()
     * @uses ItemFichaFinanceira::setNome()
     * @uses ItemFichaFinanceira::setSiglaAssunto()
     * @uses ItemFichaFinanceira::setRendimento()
     * @uses ItemFichaFinanceira::setSequencia()
     * @uses ItemFichaFinanceira::setDataPagamento()
     * @uses ItemFichaFinanceira::setValor()
     * @uses ItemFichaFinanceira::setSinalFolha()
     * @uses ItemFichaFinanceira::setTipoFolha()
     * @param int $codigo
     * @param string $nome
     * @param string $siglaAssunto
     * @param string $rendimento
     * @param string $sequencia
     * @param int $dataPagamento
     * @param float $valor
     * @param int $sinalFolha
     * @param int $tipoFolha
     */
    public function __construct($codigo = null, $nome = null, $siglaAssunto = null, $rendimento = null, $sequencia = null, $dataPagamento = null, $valor = null, $sinalFolha = null, $tipoFolha = null)
    {
        $this
            ->setCodigo($codigo)
            ->setNome($nome)
            ->setSiglaAssunto($siglaAssunto)
            ->setRendimento($rendimento)
            ->setSequencia($sequencia)
            ->setDataPagamento($dataPagamento)
            ->setValor($valor)
            ->setSinalFolha($sinalFolha)
            ->setTipoFolha($tipoFolha);
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\ItemFichaFinanceira
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\ItemFichaFinanceira
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get siglaAssunto value
     * @return string|null
     */
    public function getSiglaAssunto()
    {
        return $this->siglaAssunto;
    }
    /**
     * Set siglaAssunto value
     * @param string $siglaAssunto
     * @return \StructType\ItemFichaFinanceira
     */
    public function setSiglaAssunto($siglaAssunto = null)
    {
        // validation for constraint: string
        if (!is_null($siglaAssunto) && !is_string($siglaAssunto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siglaAssunto, true), gettype($siglaAssunto)), __LINE__);
        }
        $this->siglaAssunto = $siglaAssunto;
        return $this;
    }
    /**
     * Get rendimento value
     * @return string|null
     */
    public function getRendimento()
    {
        return $this->rendimento;
    }
    /**
     * Set rendimento value
     * @param string $rendimento
     * @return \StructType\ItemFichaFinanceira
     */
    public function setRendimento($rendimento = null)
    {
        // validation for constraint: string
        if (!is_null($rendimento) && !is_string($rendimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rendimento, true), gettype($rendimento)), __LINE__);
        }
        $this->rendimento = $rendimento;
        return $this;
    }
    /**
     * Get sequencia value
     * @return string|null
     */
    public function getSequencia()
    {
        return $this->sequencia;
    }
    /**
     * Set sequencia value
     * @param string $sequencia
     * @return \StructType\ItemFichaFinanceira
     */
    public function setSequencia($sequencia = null)
    {
        // validation for constraint: string
        if (!is_null($sequencia) && !is_string($sequencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequencia, true), gettype($sequencia)), __LINE__);
        }
        $this->sequencia = $sequencia;
        return $this;
    }
    /**
     * Get dataPagamento value
     * @return int|null
     */
    public function getDataPagamento()
    {
        return $this->dataPagamento;
    }
    /**
     * Set dataPagamento value
     * @param int $dataPagamento
     * @return \StructType\ItemFichaFinanceira
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: int
        if (!is_null($dataPagamento) && !(is_int($dataPagamento) || ctype_digit($dataPagamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dataPagamento, true), gettype($dataPagamento)), __LINE__);
        }
        $this->dataPagamento = $dataPagamento;
        return $this;
    }
    /**
     * Get valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->valor;
    }
    /**
     * Set valor value
     * @param float $valor
     * @return \StructType\ItemFichaFinanceira
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->valor = $valor;
        return $this;
    }
    /**
     * Get sinalFolha value
     * @return int|null
     */
    public function getSinalFolha()
    {
        return $this->sinalFolha;
    }
    /**
     * Set sinalFolha value
     * @param int $sinalFolha
     * @return \StructType\ItemFichaFinanceira
     */
    public function setSinalFolha($sinalFolha = null)
    {
        // validation for constraint: int
        if (!is_null($sinalFolha) && !(is_int($sinalFolha) || ctype_digit($sinalFolha))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sinalFolha, true), gettype($sinalFolha)), __LINE__);
        }
        $this->sinalFolha = $sinalFolha;
        return $this;
    }
    /**
     * Get tipoFolha value
     * @return int|null
     */
    public function getTipoFolha()
    {
        return $this->tipoFolha;
    }
    /**
     * Set tipoFolha value
     * @param int $tipoFolha
     * @return \StructType\ItemFichaFinanceira
     */
    public function setTipoFolha($tipoFolha = null)
    {
        // validation for constraint: int
        if (!is_null($tipoFolha) && !(is_int($tipoFolha) || ctype_digit($tipoFolha))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoFolha, true), gettype($tipoFolha)), __LINE__);
        }
        $this->tipoFolha = $tipoFolha;
        return $this;
    }
}
