<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstituidorLegal StructType
 * @subpackage Structs
 */
class InstituidorLegal extends BaseModel
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigo;
    /**
     * The descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * The beneficios
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Beneficios
     */
    public $beneficios;
    /**
     * The numeroProcessoPensao
     * @var int
     */
    public $numeroProcessoPensao;
    /**
     * The codOrgao
     * @var int
     */
    public $codOrgao;
    /**
     * The numeroLeiPensao
     * @var int
     */
    public $numeroLeiPensao;
    /**
     * The matricula
     * @var int
     */
    public $matricula;
    /**
     * Constructor method for InstituidorLegal
     * @uses InstituidorLegal::setCodigo()
     * @uses InstituidorLegal::setDescricao()
     * @uses InstituidorLegal::setBeneficios()
     * @uses InstituidorLegal::setNumeroProcessoPensao()
     * @uses InstituidorLegal::setCodOrgao()
     * @uses InstituidorLegal::setNumeroLeiPensao()
     * @uses InstituidorLegal::setMatricula()
     * @param int $codigo
     * @param string $descricao
     * @param \StructType\Beneficios $beneficios
     * @param int $numeroProcessoPensao
     * @param int $codOrgao
     * @param int $numeroLeiPensao
     * @param int $matricula
     */
    public function __construct($codigo = null, $descricao = null, \StructType\Beneficios $beneficios = null, $numeroProcessoPensao = null, $codOrgao = null, $numeroLeiPensao = null, $matricula = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescricao($descricao)
            ->setBeneficios($beneficios)
            ->setNumeroProcessoPensao($numeroProcessoPensao)
            ->setCodOrgao($codOrgao)
            ->setNumeroLeiPensao($numeroLeiPensao)
            ->setMatricula($matricula);
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\InstituidorLegal
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\InstituidorLegal
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Get beneficios value
     * @return \StructType\Beneficios|null
     */
    public function getBeneficios()
    {
        return $this->beneficios;
    }
    /**
     * Set beneficios value
     * @param \StructType\Beneficios $beneficios
     * @return \StructType\InstituidorLegal
     */
    public function setBeneficios(\StructType\Beneficios $beneficios = null)
    {
        $this->beneficios = $beneficios;
        return $this;
    }
    /**
     * Get numeroProcessoPensao value
     * @return int|null
     */
    public function getNumeroProcessoPensao()
    {
        return $this->numeroProcessoPensao;
    }
    /**
     * Set numeroProcessoPensao value
     * @param int $numeroProcessoPensao
     * @return \StructType\InstituidorLegal
     */
    public function setNumeroProcessoPensao($numeroProcessoPensao = null)
    {
        // validation for constraint: int
        if (!is_null($numeroProcessoPensao) && !(is_int($numeroProcessoPensao) || ctype_digit($numeroProcessoPensao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroProcessoPensao, true), gettype($numeroProcessoPensao)), __LINE__);
        }
        $this->numeroProcessoPensao = $numeroProcessoPensao;
        return $this;
    }
    /**
     * Get codOrgao value
     * @return int|null
     */
    public function getCodOrgao()
    {
        return $this->codOrgao;
    }
    /**
     * Set codOrgao value
     * @param int $codOrgao
     * @return \StructType\InstituidorLegal
     */
    public function setCodOrgao($codOrgao = null)
    {
        // validation for constraint: int
        if (!is_null($codOrgao) && !(is_int($codOrgao) || ctype_digit($codOrgao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codOrgao, true), gettype($codOrgao)), __LINE__);
        }
        $this->codOrgao = $codOrgao;
        return $this;
    }
    /**
     * Get numeroLeiPensao value
     * @return int|null
     */
    public function getNumeroLeiPensao()
    {
        return $this->numeroLeiPensao;
    }
    /**
     * Set numeroLeiPensao value
     * @param int $numeroLeiPensao
     * @return \StructType\InstituidorLegal
     */
    public function setNumeroLeiPensao($numeroLeiPensao = null)
    {
        // validation for constraint: int
        if (!is_null($numeroLeiPensao) && !(is_int($numeroLeiPensao) || ctype_digit($numeroLeiPensao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroLeiPensao, true), gettype($numeroLeiPensao)), __LINE__);
        }
        $this->numeroLeiPensao = $numeroLeiPensao;
        return $this;
    }
    /**
     * Get matricula value
     * @return int|null
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
    /**
     * Set matricula value
     * @param int $matricula
     * @return \StructType\InstituidorLegal
     */
    public function setMatricula($matricula = null)
    {
        // validation for constraint: int
        if (!is_null($matricula) && !(is_int($matricula) || ctype_digit($matricula))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matricula, true), gettype($matricula)), __LINE__);
        }
        $this->matricula = $matricula;
        return $this;
    }
}
