<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Instituidor StructType
 * @subpackage Structs
 */
class Instituidor extends Servidor
{
    /**
     * The uorg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $uorg;
    /**
     * The beneficios
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Beneficios
     */
    public $beneficios;
    /**
     * The matriculaSiape
     * @var int
     */
    public $matriculaSiape;
    /**
     * Constructor method for Instituidor
     * @uses Instituidor::setUorg()
     * @uses Instituidor::setBeneficios()
     * @uses Instituidor::setMatriculaSiape()
     * @param string $uorg
     * @param \StructType\Beneficios $beneficios
     * @param int $matriculaSiape
     */
    public function __construct($uorg = null, \StructType\Beneficios $beneficios = null, $matriculaSiape = null)
    {
        $this
            ->setUorg($uorg)
            ->setBeneficios($beneficios)
            ->setMatriculaSiape($matriculaSiape);
    }
    /**
     * Get uorg value
     * @return string|null
     */
    public function getUorg()
    {
        return $this->uorg;
    }
    /**
     * Set uorg value
     * @param string $uorg
     * @return \StructType\Instituidor
     */
    public function setUorg($uorg = null)
    {
        // validation for constraint: string
        if (!is_null($uorg) && !is_string($uorg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uorg, true), gettype($uorg)), __LINE__);
        }
        $this->uorg = $uorg;
        return $this;
    }
    /**
     * Get beneficios value
     * @return \StructType\Beneficios|null
     */
    public function getBeneficios()
    {
        return $this->beneficios;
    }
    /**
     * Set beneficios value
     * @param \StructType\Beneficios $beneficios
     * @return \StructType\Instituidor
     */
    public function setBeneficios(\StructType\Beneficios $beneficios = null)
    {
        $this->beneficios = $beneficios;
        return $this;
    }
    /**
     * Get matriculaSiape value
     * @return int|null
     */
    public function getMatriculaSiape()
    {
        return $this->matriculaSiape;
    }
    /**
     * Set matriculaSiape value
     * @param int $matriculaSiape
     * @return \StructType\Instituidor
     */
    public function setMatriculaSiape($matriculaSiape = null)
    {
        // validation for constraint: int
        if (!is_null($matriculaSiape) && !(is_int($matriculaSiape) || ctype_digit($matriculaSiape))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matriculaSiape, true), gettype($matriculaSiape)), __LINE__);
        }
        $this->matriculaSiape = $matriculaSiape;
        return $this;
    }
}
