<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for incidenciaVinculoBeneficio StructType
 * @subpackage Structs
 */
class IncidenciaVinculoBeneficio extends AbstractStructBase
{
    /**
     * The anoIncidenciaVinculo
     * @var int
     */
    public $anoIncidenciaVinculo;
    /**
     * The codigoOrgao
     * @var int
     */
    public $codigoOrgao;
    /**
     * The numeroMatricula
     * @var int
     */
    public $numeroMatricula;
    /**
     * Constructor method for incidenciaVinculoBeneficio
     * @uses IncidenciaVinculoBeneficio::setAnoIncidenciaVinculo()
     * @uses IncidenciaVinculoBeneficio::setCodigoOrgao()
     * @uses IncidenciaVinculoBeneficio::setNumeroMatricula()
     * @param int $anoIncidenciaVinculo
     * @param int $codigoOrgao
     * @param int $numeroMatricula
     */
    public function __construct($anoIncidenciaVinculo = null, $codigoOrgao = null, $numeroMatricula = null)
    {
        $this
            ->setAnoIncidenciaVinculo($anoIncidenciaVinculo)
            ->setCodigoOrgao($codigoOrgao)
            ->setNumeroMatricula($numeroMatricula);
    }
    /**
     * Get anoIncidenciaVinculo value
     * @return int|null
     */
    public function getAnoIncidenciaVinculo()
    {
        return $this->anoIncidenciaVinculo;
    }
    /**
     * Set anoIncidenciaVinculo value
     * @param int $anoIncidenciaVinculo
     * @return \StructType\IncidenciaVinculoBeneficio
     */
    public function setAnoIncidenciaVinculo($anoIncidenciaVinculo = null)
    {
        // validation for constraint: int
        if (!is_null($anoIncidenciaVinculo) && !(is_int($anoIncidenciaVinculo) || ctype_digit($anoIncidenciaVinculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anoIncidenciaVinculo, true), gettype($anoIncidenciaVinculo)), __LINE__);
        }
        $this->anoIncidenciaVinculo = $anoIncidenciaVinculo;
        return $this;
    }
    /**
     * Get codigoOrgao value
     * @return int|null
     */
    public function getCodigoOrgao()
    {
        return $this->codigoOrgao;
    }
    /**
     * Set codigoOrgao value
     * @param int $codigoOrgao
     * @return \StructType\IncidenciaVinculoBeneficio
     */
    public function setCodigoOrgao($codigoOrgao = null)
    {
        // validation for constraint: int
        if (!is_null($codigoOrgao) && !(is_int($codigoOrgao) || ctype_digit($codigoOrgao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoOrgao, true), gettype($codigoOrgao)), __LINE__);
        }
        $this->codigoOrgao = $codigoOrgao;
        return $this;
    }
    /**
     * Get numeroMatricula value
     * @return int|null
     */
    public function getNumeroMatricula()
    {
        return $this->numeroMatricula;
    }
    /**
     * Set numeroMatricula value
     * @param int $numeroMatricula
     * @return \StructType\IncidenciaVinculoBeneficio
     */
    public function setNumeroMatricula($numeroMatricula = null)
    {
        // validation for constraint: int
        if (!is_null($numeroMatricula) && !(is_int($numeroMatricula) || ctype_digit($numeroMatricula))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroMatricula, true), gettype($numeroMatricula)), __LINE__);
        }
        $this->numeroMatricula = $numeroMatricula;
        return $this;
    }
}
