<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findTransacaoByCpf StructType
 * Meta information extracted from the WSDL
 * - type: tns:findTransacaoByCpf
 * @subpackage Structs
 */
class FindTransacaoByCpf extends AbstractStructBase
{
    /**
     * The cpf
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cpf;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * Constructor method for findTransacaoByCpf
     * @uses FindTransacaoByCpf::setCpf()
     * @uses FindTransacaoByCpf::setToken()
     * @param int $cpf
     * @param string $token
     */
    public function __construct($cpf = null, $token = null)
    {
        $this
            ->setCpf($cpf)
            ->setToken($token);
    }
    /**
     * Get cpf value
     * @return int|null
     */
    public function getCpf()
    {
        return $this->cpf;
    }
    /**
     * Set cpf value
     * @param int $cpf
     * @return \StructType\FindTransacaoByCpf
     */
    public function setCpf($cpf = null)
    {
        // validation for constraint: int
        if (!is_null($cpf) && !(is_int($cpf) || ctype_digit($cpf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cpf, true), gettype($cpf)), __LINE__);
        }
        $this->cpf = $cpf;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\FindTransacaoByCpf
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
}
