<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findByMatricula StructType
 * Meta information extracted from the WSDL
 * - type: tns:findByMatricula
 * @subpackage Structs
 */
class FindByMatricula extends AbstractStructBase
{
    /**
     * The matriculaInstituidorLegal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $matriculaInstituidorLegal;
    /**
     * The codigoOrgao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoOrgao;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * Constructor method for findByMatricula
     * @uses FindByMatricula::setMatriculaInstituidorLegal()
     * @uses FindByMatricula::setCodigoOrgao()
     * @uses FindByMatricula::setToken()
     * @param int $matriculaInstituidorLegal
     * @param int $codigoOrgao
     * @param string $token
     */
    public function __construct($matriculaInstituidorLegal = null, $codigoOrgao = null, $token = null)
    {
        $this
            ->setMatriculaInstituidorLegal($matriculaInstituidorLegal)
            ->setCodigoOrgao($codigoOrgao)
            ->setToken($token);
    }
    /**
     * Get matriculaInstituidorLegal value
     * @return int|null
     */
    public function getMatriculaInstituidorLegal()
    {
        return $this->matriculaInstituidorLegal;
    }
    /**
     * Set matriculaInstituidorLegal value
     * @param int $matriculaInstituidorLegal
     * @return \StructType\FindByMatricula
     */
    public function setMatriculaInstituidorLegal($matriculaInstituidorLegal = null)
    {
        // validation for constraint: int
        if (!is_null($matriculaInstituidorLegal) && !(is_int($matriculaInstituidorLegal) || ctype_digit($matriculaInstituidorLegal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matriculaInstituidorLegal, true), gettype($matriculaInstituidorLegal)), __LINE__);
        }
        $this->matriculaInstituidorLegal = $matriculaInstituidorLegal;
        return $this;
    }
    /**
     * Get codigoOrgao value
     * @return int|null
     */
    public function getCodigoOrgao()
    {
        return $this->codigoOrgao;
    }
    /**
     * Set codigoOrgao value
     * @param int $codigoOrgao
     * @return \StructType\FindByMatricula
     */
    public function setCodigoOrgao($codigoOrgao = null)
    {
        // validation for constraint: int
        if (!is_null($codigoOrgao) && !(is_int($codigoOrgao) || ctype_digit($codigoOrgao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoOrgao, true), gettype($codigoOrgao)), __LINE__);
        }
        $this->codigoOrgao = $codigoOrgao;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\FindByMatricula
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
}
