<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadoFuncional StructType
 * @subpackage Structs
 */
class DadoFuncional extends BaseModel
{
    /**
     * The campos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Campos
     */
    public $campos;
    /**
     * The dataOcorrencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataOcorrencia;
    /**
     * The agrupamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Agrupamento
     */
    public $agrupamento;
    /**
     * The vinculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Vinculo
     */
    public $vinculo;
    /**
     * Constructor method for DadoFuncional
     * @uses DadoFuncional::setCampos()
     * @uses DadoFuncional::setDataOcorrencia()
     * @uses DadoFuncional::setAgrupamento()
     * @uses DadoFuncional::setVinculo()
     * @param \StructType\Campos $campos
     * @param string $dataOcorrencia
     * @param \StructType\Agrupamento $agrupamento
     * @param \StructType\Vinculo $vinculo
     */
    public function __construct(\StructType\Campos $campos = null, $dataOcorrencia = null, \StructType\Agrupamento $agrupamento = null, \StructType\Vinculo $vinculo = null)
    {
        $this
            ->setCampos($campos)
            ->setDataOcorrencia($dataOcorrencia)
            ->setAgrupamento($agrupamento)
            ->setVinculo($vinculo);
    }
    /**
     * Get campos value
     * @return \StructType\Campos|null
     */
    public function getCampos()
    {
        return $this->campos;
    }
    /**
     * Set campos value
     * @param \StructType\Campos $campos
     * @return \StructType\DadoFuncional
     */
    public function setCampos(\StructType\Campos $campos = null)
    {
        $this->campos = $campos;
        return $this;
    }
    /**
     * Get dataOcorrencia value
     * @return string|null
     */
    public function getDataOcorrencia()
    {
        return $this->dataOcorrencia;
    }
    /**
     * Set dataOcorrencia value
     * @param string $dataOcorrencia
     * @return \StructType\DadoFuncional
     */
    public function setDataOcorrencia($dataOcorrencia = null)
    {
        // validation for constraint: string
        if (!is_null($dataOcorrencia) && !is_string($dataOcorrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataOcorrencia, true), gettype($dataOcorrencia)), __LINE__);
        }
        $this->dataOcorrencia = $dataOcorrencia;
        return $this;
    }
    /**
     * Get agrupamento value
     * @return \StructType\Agrupamento|null
     */
    public function getAgrupamento()
    {
        return $this->agrupamento;
    }
    /**
     * Set agrupamento value
     * @param \StructType\Agrupamento $agrupamento
     * @return \StructType\DadoFuncional
     */
    public function setAgrupamento(\StructType\Agrupamento $agrupamento = null)
    {
        $this->agrupamento = $agrupamento;
        return $this;
    }
    /**
     * Get vinculo value
     * @return \StructType\Vinculo|null
     */
    public function getVinculo()
    {
        return $this->vinculo;
    }
    /**
     * Set vinculo value
     * @param \StructType\Vinculo $vinculo
     * @return \StructType\DadoFuncional
     */
    public function setVinculo(\StructType\Vinculo $vinculo = null)
    {
        $this->vinculo = $vinculo;
        return $this;
    }
}
