<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for beneficiario StructType
 * @subpackage Structs
 */
class Beneficiario_1 extends AbstractStructBase
{
    /**
     * The CPF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CPF;
    /**
     * The instituidoresIdentificacaoUnica
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $instituidoresIdentificacaoUnica;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * Constructor method for beneficiario
     * @uses Beneficiario_1::setCPF()
     * @uses Beneficiario_1::setInstituidoresIdentificacaoUnica()
     * @uses Beneficiario_1::setNome()
     * @param int $cPF
     * @param int[] $instituidoresIdentificacaoUnica
     * @param string $nome
     */
    public function __construct($cPF = null, array $instituidoresIdentificacaoUnica = array(), $nome = null)
    {
        $this
            ->setCPF($cPF)
            ->setInstituidoresIdentificacaoUnica($instituidoresIdentificacaoUnica)
            ->setNome($nome);
    }
    /**
     * Get CPF value
     * @return int|null
     */
    public function getCPF()
    {
        return $this->CPF;
    }
    /**
     * Set CPF value
     * @param int $cPF
     * @return \StructType\Beneficiario_1
     */
    public function setCPF($cPF = null)
    {
        // validation for constraint: int
        if (!is_null($cPF) && !(is_int($cPF) || ctype_digit($cPF))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cPF, true), gettype($cPF)), __LINE__);
        }
        $this->CPF = $cPF;
        return $this;
    }
    /**
     * Get instituidoresIdentificacaoUnica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getInstituidoresIdentificacaoUnica()
    {
        return isset($this->instituidoresIdentificacaoUnica) ? $this->instituidoresIdentificacaoUnica : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInstituidoresIdentificacaoUnica method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstituidoresIdentificacaoUnica method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstituidoresIdentificacaoUnicaForArrayConstraintsFromSetInstituidoresIdentificacaoUnica(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $beneficiarioInstituidoresIdentificacaoUnicaItem) {
            // validation for constraint: itemType
            if (!(is_int($beneficiarioInstituidoresIdentificacaoUnicaItem) || ctype_digit($beneficiarioInstituidoresIdentificacaoUnicaItem))) {
                $invalidValues[] = is_object($beneficiarioInstituidoresIdentificacaoUnicaItem) ? get_class($beneficiarioInstituidoresIdentificacaoUnicaItem) : sprintf('%s(%s)', gettype($beneficiarioInstituidoresIdentificacaoUnicaItem), var_export($beneficiarioInstituidoresIdentificacaoUnicaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The instituidoresIdentificacaoUnica property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set instituidoresIdentificacaoUnica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $instituidoresIdentificacaoUnica
     * @return \StructType\Beneficiario_1
     */
    public function setInstituidoresIdentificacaoUnica(array $instituidoresIdentificacaoUnica = array())
    {
        // validation for constraint: array
        if ('' !== ($instituidoresIdentificacaoUnicaArrayErrorMessage = self::validateInstituidoresIdentificacaoUnicaForArrayConstraintsFromSetInstituidoresIdentificacaoUnica($instituidoresIdentificacaoUnica))) {
            throw new \InvalidArgumentException($instituidoresIdentificacaoUnicaArrayErrorMessage, __LINE__);
        }
        if (is_null($instituidoresIdentificacaoUnica) || (is_array($instituidoresIdentificacaoUnica) && empty($instituidoresIdentificacaoUnica))) {
            unset($this->instituidoresIdentificacaoUnica);
        } else {
            $this->instituidoresIdentificacaoUnica = $instituidoresIdentificacaoUnica;
        }
        return $this;
    }
    /**
     * Add item to instituidoresIdentificacaoUnica value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Beneficiario_1
     */
    public function addToInstituidoresIdentificacaoUnica($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The instituidoresIdentificacaoUnica property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->instituidoresIdentificacaoUnica[] = $item;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\Beneficiario_1
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
}
