<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Beneficiado StructType
 * @subpackage Structs
 */
class Beneficiado extends Pessoa
{
    /**
     * The matricula
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $matricula;
    /**
     * The naturezaPensao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $naturezaPensao;
    /**
     * The situacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $situacao;
    /**
     * The servidor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Servidor
     */
    public $servidor;
    /**
     * The beneficios
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Beneficios
     */
    public $beneficios;
    /**
     * The objetosAcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ObjetosAcao
     */
    public $objetosAcao;
    /**
     * The autorizacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $autorizacao;
    /**
     * The objetoDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $objetoDesc;
    /**
     * Constructor method for Beneficiado
     * @uses Beneficiado::setMatricula()
     * @uses Beneficiado::setNaturezaPensao()
     * @uses Beneficiado::setSituacao()
     * @uses Beneficiado::setServidor()
     * @uses Beneficiado::setBeneficios()
     * @uses Beneficiado::setObjetosAcao()
     * @uses Beneficiado::setAutorizacao()
     * @uses Beneficiado::setObjetoDesc()
     * @param int $matricula
     * @param string $naturezaPensao
     * @param string $situacao
     * @param \StructType\Servidor $servidor
     * @param \StructType\Beneficios $beneficios
     * @param \StructType\ObjetosAcao $objetosAcao
     * @param string $autorizacao
     * @param string $objetoDesc
     */
    public function __construct($matricula = null, $naturezaPensao = null, $situacao = null, \StructType\Servidor $servidor = null, \StructType\Beneficios $beneficios = null, \StructType\ObjetosAcao $objetosAcao = null, $autorizacao = null, $objetoDesc = null)
    {
        $this
            ->setMatricula($matricula)
            ->setNaturezaPensao($naturezaPensao)
            ->setSituacao($situacao)
            ->setServidor($servidor)
            ->setBeneficios($beneficios)
            ->setObjetosAcao($objetosAcao)
            ->setAutorizacao($autorizacao)
            ->setObjetoDesc($objetoDesc);
    }
    /**
     * Get matricula value
     * @return int|null
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
    /**
     * Set matricula value
     * @param int $matricula
     * @return \StructType\Beneficiado
     */
    public function setMatricula($matricula = null)
    {
        // validation for constraint: int
        if (!is_null($matricula) && !(is_int($matricula) || ctype_digit($matricula))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matricula, true), gettype($matricula)), __LINE__);
        }
        $this->matricula = $matricula;
        return $this;
    }
    /**
     * Get naturezaPensao value
     * @return string|null
     */
    public function getNaturezaPensao()
    {
        return $this->naturezaPensao;
    }
    /**
     * Set naturezaPensao value
     * @param string $naturezaPensao
     * @return \StructType\Beneficiado
     */
    public function setNaturezaPensao($naturezaPensao = null)
    {
        // validation for constraint: string
        if (!is_null($naturezaPensao) && !is_string($naturezaPensao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naturezaPensao, true), gettype($naturezaPensao)), __LINE__);
        }
        $this->naturezaPensao = $naturezaPensao;
        return $this;
    }
    /**
     * Get situacao value
     * @return string|null
     */
    public function getSituacao()
    {
        return $this->situacao;
    }
    /**
     * Set situacao value
     * @param string $situacao
     * @return \StructType\Beneficiado
     */
    public function setSituacao($situacao = null)
    {
        // validation for constraint: string
        if (!is_null($situacao) && !is_string($situacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($situacao, true), gettype($situacao)), __LINE__);
        }
        $this->situacao = $situacao;
        return $this;
    }
    /**
     * Get servidor value
     * @return \StructType\Servidor|null
     */
    public function getServidor()
    {
        return $this->servidor;
    }
    /**
     * Set servidor value
     * @param \StructType\Servidor $servidor
     * @return \StructType\Beneficiado
     */
    public function setServidor(\StructType\Servidor $servidor = null)
    {
        $this->servidor = $servidor;
        return $this;
    }
    /**
     * Get beneficios value
     * @return \StructType\Beneficios|null
     */
    public function getBeneficios()
    {
        return $this->beneficios;
    }
    /**
     * Set beneficios value
     * @param \StructType\Beneficios $beneficios
     * @return \StructType\Beneficiado
     */
    public function setBeneficios(\StructType\Beneficios $beneficios = null)
    {
        $this->beneficios = $beneficios;
        return $this;
    }
    /**
     * Get objetosAcao value
     * @return \StructType\ObjetosAcao|null
     */
    public function getObjetosAcao()
    {
        return $this->objetosAcao;
    }
    /**
     * Set objetosAcao value
     * @param \StructType\ObjetosAcao $objetosAcao
     * @return \StructType\Beneficiado
     */
    public function setObjetosAcao(\StructType\ObjetosAcao $objetosAcao = null)
    {
        $this->objetosAcao = $objetosAcao;
        return $this;
    }
    /**
     * Get autorizacao value
     * @return string|null
     */
    public function getAutorizacao()
    {
        return $this->autorizacao;
    }
    /**
     * Set autorizacao value
     * @param string $autorizacao
     * @return \StructType\Beneficiado
     */
    public function setAutorizacao($autorizacao = null)
    {
        // validation for constraint: string
        if (!is_null($autorizacao) && !is_string($autorizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autorizacao, true), gettype($autorizacao)), __LINE__);
        }
        $this->autorizacao = $autorizacao;
        return $this;
    }
    /**
     * Get objetoDesc value
     * @return string|null
     */
    public function getObjetoDesc()
    {
        return $this->objetoDesc;
    }
    /**
     * Set objetoDesc value
     * @param string $objetoDesc
     * @return \StructType\Beneficiado
     */
    public function setObjetoDesc($objetoDesc = null)
    {
        // validation for constraint: string
        if (!is_null($objetoDesc) && !is_string($objetoDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objetoDesc, true), gettype($objetoDesc)), __LINE__);
        }
        $this->objetoDesc = $objetoDesc;
        return $this;
    }
}
