<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Agrupamento StructType
 * @subpackage Structs
 */
class Agrupamento extends BaseModel
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigo;
    /**
     * The descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * The agrupamentos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Agrupamento[]
     */
    public $agrupamentos;
    /**
     * Constructor method for Agrupamento
     * @uses Agrupamento::setCodigo()
     * @uses Agrupamento::setDescricao()
     * @uses Agrupamento::setAgrupamentos()
     * @param int $codigo
     * @param string $descricao
     * @param \StructType\Agrupamento[] $agrupamentos
     */
    public function __construct($codigo = null, $descricao = null, array $agrupamentos = array())
    {
        $this
            ->setCodigo($codigo)
            ->setDescricao($descricao)
            ->setAgrupamentos($agrupamentos);
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\Agrupamento
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\Agrupamento
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Get agrupamentos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Agrupamento[]|null
     */
    public function getAgrupamentos()
    {
        return isset($this->agrupamentos) ? $this->agrupamentos : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAgrupamentos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgrupamentos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgrupamentosForArrayConstraintsFromSetAgrupamentos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agrupamentoAgrupamentosItem) {
            // validation for constraint: itemType
            if (!$agrupamentoAgrupamentosItem instanceof \StructType\Agrupamento) {
                $invalidValues[] = is_object($agrupamentoAgrupamentosItem) ? get_class($agrupamentoAgrupamentosItem) : sprintf('%s(%s)', gettype($agrupamentoAgrupamentosItem), var_export($agrupamentoAgrupamentosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The agrupamentos property can only contain items of type \StructType\Agrupamento, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set agrupamentos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Agrupamento[] $agrupamentos
     * @return \StructType\Agrupamento
     */
    public function setAgrupamentos(array $agrupamentos = array())
    {
        // validation for constraint: array
        if ('' !== ($agrupamentosArrayErrorMessage = self::validateAgrupamentosForArrayConstraintsFromSetAgrupamentos($agrupamentos))) {
            throw new \InvalidArgumentException($agrupamentosArrayErrorMessage, __LINE__);
        }
        if (is_null($agrupamentos) || (is_array($agrupamentos) && empty($agrupamentos))) {
            unset($this->agrupamentos);
        } else {
            $this->agrupamentos = $agrupamentos;
        }
        return $this;
    }
    /**
     * Add item to agrupamentos value
     * @throws \InvalidArgumentException
     * @param \StructType\Agrupamento $item
     * @return \StructType\Agrupamento
     */
    public function addToAgrupamentos(\StructType\Agrupamento $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Agrupamento) {
            throw new \InvalidArgumentException(sprintf('The agrupamentos property can only contain items of type \StructType\Agrupamento, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->agrupamentos[] = $item;
        return $this;
    }
}
