<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Servidor StructType
 * @subpackage Structs
 */
class Servidor extends PessoaSiape
{
    /**
     * The dataObito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataObito;
    /**
     * The dataCadastramentoSiape
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataCadastramentoSiape;
    /**
     * The identificacaoUnica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $identificacaoUnica;
    /**
     * The vinculos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Vinculos
     */
    public $vinculos;
    /**
     * The orgaoJudicial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Orgao
     */
    public $orgaoJudicial;
    /**
     * The matricula
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $matricula;
    /**
     * The instituidor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Instituidor
     */
    public $instituidor;
    /**
     * Constructor method for Servidor
     * @uses Servidor::setDataObito()
     * @uses Servidor::setDataCadastramentoSiape()
     * @uses Servidor::setIdentificacaoUnica()
     * @uses Servidor::setVinculos()
     * @uses Servidor::setOrgaoJudicial()
     * @uses Servidor::setMatricula()
     * @uses Servidor::setInstituidor()
     * @param string $dataObito
     * @param string $dataCadastramentoSiape
     * @param int $identificacaoUnica
     * @param \StructType\Vinculos $vinculos
     * @param \StructType\Orgao $orgaoJudicial
     * @param int $matricula
     * @param \StructType\Instituidor $instituidor
     */
    public function __construct($dataObito = null, $dataCadastramentoSiape = null, $identificacaoUnica = null, \StructType\Vinculos $vinculos = null, \StructType\Orgao $orgaoJudicial = null, $matricula = null, \StructType\Instituidor $instituidor = null)
    {
        $this
            ->setDataObito($dataObito)
            ->setDataCadastramentoSiape($dataCadastramentoSiape)
            ->setIdentificacaoUnica($identificacaoUnica)
            ->setVinculos($vinculos)
            ->setOrgaoJudicial($orgaoJudicial)
            ->setMatricula($matricula)
            ->setInstituidor($instituidor);
    }
    /**
     * Get dataObito value
     * @return string|null
     */
    public function getDataObito()
    {
        return $this->dataObito;
    }
    /**
     * Set dataObito value
     * @param string $dataObito
     * @return \StructType\Servidor
     */
    public function setDataObito($dataObito = null)
    {
        // validation for constraint: string
        if (!is_null($dataObito) && !is_string($dataObito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataObito, true), gettype($dataObito)), __LINE__);
        }
        $this->dataObito = $dataObito;
        return $this;
    }
    /**
     * Get dataCadastramentoSiape value
     * @return string|null
     */
    public function getDataCadastramentoSiape()
    {
        return $this->dataCadastramentoSiape;
    }
    /**
     * Set dataCadastramentoSiape value
     * @param string $dataCadastramentoSiape
     * @return \StructType\Servidor
     */
    public function setDataCadastramentoSiape($dataCadastramentoSiape = null)
    {
        // validation for constraint: string
        if (!is_null($dataCadastramentoSiape) && !is_string($dataCadastramentoSiape)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataCadastramentoSiape, true), gettype($dataCadastramentoSiape)), __LINE__);
        }
        $this->dataCadastramentoSiape = $dataCadastramentoSiape;
        return $this;
    }
    /**
     * Get identificacaoUnica value
     * @return int|null
     */
    public function getIdentificacaoUnica()
    {
        return $this->identificacaoUnica;
    }
    /**
     * Set identificacaoUnica value
     * @param int $identificacaoUnica
     * @return \StructType\Servidor
     */
    public function setIdentificacaoUnica($identificacaoUnica = null)
    {
        // validation for constraint: int
        if (!is_null($identificacaoUnica) && !(is_int($identificacaoUnica) || ctype_digit($identificacaoUnica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identificacaoUnica, true), gettype($identificacaoUnica)), __LINE__);
        }
        $this->identificacaoUnica = $identificacaoUnica;
        return $this;
    }
    /**
     * Get vinculos value
     * @return \StructType\Vinculos|null
     */
    public function getVinculos()
    {
        return $this->vinculos;
    }
    /**
     * Set vinculos value
     * @param \StructType\Vinculos $vinculos
     * @return \StructType\Servidor
     */
    public function setVinculos(\StructType\Vinculos $vinculos = null)
    {
        $this->vinculos = $vinculos;
        return $this;
    }
    /**
     * Get orgaoJudicial value
     * @return \StructType\Orgao|null
     */
    public function getOrgaoJudicial()
    {
        return $this->orgaoJudicial;
    }
    /**
     * Set orgaoJudicial value
     * @param \StructType\Orgao $orgaoJudicial
     * @return \StructType\Servidor
     */
    public function setOrgaoJudicial(\StructType\Orgao $orgaoJudicial = null)
    {
        $this->orgaoJudicial = $orgaoJudicial;
        return $this;
    }
    /**
     * Get matricula value
     * @return int|null
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
    /**
     * Set matricula value
     * @param int $matricula
     * @return \StructType\Servidor
     */
    public function setMatricula($matricula = null)
    {
        // validation for constraint: int
        if (!is_null($matricula) && !(is_int($matricula) || ctype_digit($matricula))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matricula, true), gettype($matricula)), __LINE__);
        }
        $this->matricula = $matricula;
        return $this;
    }
    /**
     * Get instituidor value
     * @return \StructType\Instituidor|null
     */
    public function getInstituidor()
    {
        return $this->instituidor;
    }
    /**
     * Set instituidor value
     * @param \StructType\Instituidor $instituidor
     * @return \StructType\Servidor
     */
    public function setInstituidor(\StructType\Instituidor $instituidor = null)
    {
        $this->instituidor = $instituidor;
        return $this;
    }
}
