<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrgaoDaAcao StructType
 * @subpackage Structs
 */
class OrgaoDaAcao extends BaseModel
{
    /**
     * The orgao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Orgao
     */
    public $orgao;
    /**
     * The eventos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Eventos
     */
    public $eventos;
    /**
     * The situacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $situacao;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The folha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $folha;
    /**
     * The beneficiados
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Beneficiados
     */
    public $beneficiados;
    /**
     * The totalBeneficiadosAtivos
     * @var int
     */
    public $totalBeneficiadosAtivos;
    /**
     * Constructor method for OrgaoDaAcao
     * @uses OrgaoDaAcao::setOrgao()
     * @uses OrgaoDaAcao::setEventos()
     * @uses OrgaoDaAcao::setSituacao()
     * @uses OrgaoDaAcao::setStatus()
     * @uses OrgaoDaAcao::setFolha()
     * @uses OrgaoDaAcao::setBeneficiados()
     * @uses OrgaoDaAcao::setTotalBeneficiadosAtivos()
     * @param \StructType\Orgao $orgao
     * @param \StructType\Eventos $eventos
     * @param string $situacao
     * @param string $status
     * @param string $folha
     * @param \StructType\Beneficiados $beneficiados
     * @param int $totalBeneficiadosAtivos
     */
    public function __construct(\StructType\Orgao $orgao = null, \StructType\Eventos $eventos = null, $situacao = null, $status = null, $folha = null, \StructType\Beneficiados $beneficiados = null, $totalBeneficiadosAtivos = null)
    {
        $this
            ->setOrgao($orgao)
            ->setEventos($eventos)
            ->setSituacao($situacao)
            ->setStatus($status)
            ->setFolha($folha)
            ->setBeneficiados($beneficiados)
            ->setTotalBeneficiadosAtivos($totalBeneficiadosAtivos);
    }
    /**
     * Get orgao value
     * @return \StructType\Orgao|null
     */
    public function getOrgao()
    {
        return $this->orgao;
    }
    /**
     * Set orgao value
     * @param \StructType\Orgao $orgao
     * @return \StructType\OrgaoDaAcao
     */
    public function setOrgao(\StructType\Orgao $orgao = null)
    {
        $this->orgao = $orgao;
        return $this;
    }
    /**
     * Get eventos value
     * @return \StructType\Eventos|null
     */
    public function getEventos()
    {
        return $this->eventos;
    }
    /**
     * Set eventos value
     * @param \StructType\Eventos $eventos
     * @return \StructType\OrgaoDaAcao
     */
    public function setEventos(\StructType\Eventos $eventos = null)
    {
        $this->eventos = $eventos;
        return $this;
    }
    /**
     * Get situacao value
     * @return string|null
     */
    public function getSituacao()
    {
        return $this->situacao;
    }
    /**
     * Set situacao value
     * @param string $situacao
     * @return \StructType\OrgaoDaAcao
     */
    public function setSituacao($situacao = null)
    {
        // validation for constraint: string
        if (!is_null($situacao) && !is_string($situacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($situacao, true), gettype($situacao)), __LINE__);
        }
        $this->situacao = $situacao;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\OrgaoDaAcao
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get folha value
     * @return string|null
     */
    public function getFolha()
    {
        return $this->folha;
    }
    /**
     * Set folha value
     * @param string $folha
     * @return \StructType\OrgaoDaAcao
     */
    public function setFolha($folha = null)
    {
        // validation for constraint: string
        if (!is_null($folha) && !is_string($folha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folha, true), gettype($folha)), __LINE__);
        }
        $this->folha = $folha;
        return $this;
    }
    /**
     * Get beneficiados value
     * @return \StructType\Beneficiados|null
     */
    public function getBeneficiados()
    {
        return $this->beneficiados;
    }
    /**
     * Set beneficiados value
     * @param \StructType\Beneficiados $beneficiados
     * @return \StructType\OrgaoDaAcao
     */
    public function setBeneficiados(\StructType\Beneficiados $beneficiados = null)
    {
        $this->beneficiados = $beneficiados;
        return $this;
    }
    /**
     * Get totalBeneficiadosAtivos value
     * @return int|null
     */
    public function getTotalBeneficiadosAtivos()
    {
        return $this->totalBeneficiadosAtivos;
    }
    /**
     * Set totalBeneficiadosAtivos value
     * @param int $totalBeneficiadosAtivos
     * @return \StructType\OrgaoDaAcao
     */
    public function setTotalBeneficiadosAtivos($totalBeneficiadosAtivos = null)
    {
        // validation for constraint: int
        if (!is_null($totalBeneficiadosAtivos) && !(is_int($totalBeneficiadosAtivos) || ctype_digit($totalBeneficiadosAtivos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalBeneficiadosAtivos, true), gettype($totalBeneficiadosAtivos)), __LINE__);
        }
        $this->totalBeneficiadosAtivos = $totalBeneficiadosAtivos;
        return $this;
    }
}
