<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjetoAcao StructType
 * @subpackage Structs
 */
class ObjetoAcao extends BaseModel
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigo;
    /**
     * The descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * The assunto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $assunto;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The acaoJudicial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AcaoJudicial
     */
    public $acaoJudicial;
    /**
     * Constructor method for ObjetoAcao
     * @uses ObjetoAcao::setCodigo()
     * @uses ObjetoAcao::setDescricao()
     * @uses ObjetoAcao::setAssunto()
     * @uses ObjetoAcao::setStatus()
     * @uses ObjetoAcao::setAcaoJudicial()
     * @param int $codigo
     * @param string $descricao
     * @param string $assunto
     * @param string $status
     * @param \StructType\AcaoJudicial $acaoJudicial
     */
    public function __construct($codigo = null, $descricao = null, $assunto = null, $status = null, \StructType\AcaoJudicial $acaoJudicial = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescricao($descricao)
            ->setAssunto($assunto)
            ->setStatus($status)
            ->setAcaoJudicial($acaoJudicial);
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\ObjetoAcao
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\ObjetoAcao
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Get assunto value
     * @return string|null
     */
    public function getAssunto()
    {
        return $this->assunto;
    }
    /**
     * Set assunto value
     * @param string $assunto
     * @return \StructType\ObjetoAcao
     */
    public function setAssunto($assunto = null)
    {
        // validation for constraint: string
        if (!is_null($assunto) && !is_string($assunto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assunto, true), gettype($assunto)), __LINE__);
        }
        $this->assunto = $assunto;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\ObjetoAcao
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get acaoJudicial value
     * @return \StructType\AcaoJudicial|null
     */
    public function getAcaoJudicial()
    {
        return $this->acaoJudicial;
    }
    /**
     * Set acaoJudicial value
     * @param \StructType\AcaoJudicial $acaoJudicial
     * @return \StructType\ObjetoAcao
     */
    public function setAcaoJudicial(\StructType\AcaoJudicial $acaoJudicial = null)
    {
        $this->acaoJudicial = $acaoJudicial;
        return $this;
    }
}
