<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Beneficio StructType
 * @subpackage Structs
 */
class Beneficio extends BaseModel
{
    /**
     * The bancoAgencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bancoAgencia;
    /**
     * The beneficiado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Beneficiado
     */
    public $beneficiado;
    /**
     * The complContaJudicial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $complContaJudicial;
    /**
     * The conta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $conta;
    /**
     * The contaPagamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contaPagamento;
    /**
     * The cotaParte
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cotaParte;
    /**
     * The cotaComplementar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cotaComplementar;
    /**
     * The cpfCadastrador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cpfCadastrador;
    /**
     * The dataExclusao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataExclusao;
    /**
     * The dataFimProcuracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataFimProcuracao;
    /**
     * The dataInclusaoBeneficio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataInclusaoBeneficio;
    /**
     * The dataInicioBeneficio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataInicioBeneficio;
    /**
     * The dataInicioProcuracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataInicioProcuracao;
    /**
     * The dataTerminoBeneficio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataTerminoBeneficio;
    /**
     * The especieBeneficioInss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $especieBeneficioInss;
    /**
     * The instituidor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Instituidor
     */
    public $instituidor;
    /**
     * The instituidorLegal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstituidorLegal
     */
    public $instituidorLegal;
    /**
     * The mandadoSeguranca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mandadoSeguranca;
    /**
     * The matriculaOutras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matriculaOutras;
    /**
     * The matriculaSiapefaz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matriculaSiapefaz;
    /**
     * The matriculaSiapeNes84
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matriculaSiapeNes84;
    /**
     * The naturezaPensao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $naturezaPensao;
    /**
     * The nomeCartorio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nomeCartorio;
    /**
     * The numeroBeneficioInss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroBeneficioInss;
    /**
     * The numeroFolha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroFolha;
    /**
     * The numeroLeiPensao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroLeiPensao;
    /**
     * The numeroLivro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroLivro;
    /**
     * The numeroProcesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroProcesso;
    /**
     * The numeroSerpro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroSerpro;
    /**
     * The ocorrenciaExclusao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ocorrenciaExclusao;
    /**
     * The orgaoJudicial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Orgao
     */
    public $orgaoJudicial;
    /**
     * The pagamentoSuspenso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pagamentoSuspenso;
    /**
     * The parentesco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parentesco;
    /**
     * The representanteLegal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $representanteLegal;
    /**
     * The situacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $situacao;
    /**
     * The situacaoRepresentanteLegal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $situacaoRepresentanteLegal;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The tipoConta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoConta;
    /**
     * The tipoPensao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoPensao;
    /**
     * The tipoRepresentanteLegal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoRepresentanteLegal;
    /**
     * The ufApsis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ufApsis;
    /**
     * The uorgControle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $uorgControle;
    /**
     * The uorgLocalizacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $uorgLocalizacao;
    /**
     * The codigoUnidadeControle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoUnidadeControle;
    /**
     * The codigoUnidadeLocalizacao
     * @var int
     */
    public $codigoUnidadeLocalizacao;
    /**
     * The fichaFinanceira
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FichaFinanceira
     */
    public $fichaFinanceira;
    /**
     * The nomeUnidadeLocalizacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nomeUnidadeLocalizacao;
    /**
     * The nomeUnidadeControle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nomeUnidadeControle;
    /**
     * Constructor method for Beneficio
     * @uses Beneficio::setBancoAgencia()
     * @uses Beneficio::setBeneficiado()
     * @uses Beneficio::setComplContaJudicial()
     * @uses Beneficio::setConta()
     * @uses Beneficio::setContaPagamento()
     * @uses Beneficio::setCotaParte()
     * @uses Beneficio::setCotaComplementar()
     * @uses Beneficio::setCpfCadastrador()
     * @uses Beneficio::setDataExclusao()
     * @uses Beneficio::setDataFimProcuracao()
     * @uses Beneficio::setDataInclusaoBeneficio()
     * @uses Beneficio::setDataInicioBeneficio()
     * @uses Beneficio::setDataInicioProcuracao()
     * @uses Beneficio::setDataTerminoBeneficio()
     * @uses Beneficio::setEspecieBeneficioInss()
     * @uses Beneficio::setInstituidor()
     * @uses Beneficio::setInstituidorLegal()
     * @uses Beneficio::setMandadoSeguranca()
     * @uses Beneficio::setMatriculaOutras()
     * @uses Beneficio::setMatriculaSiapefaz()
     * @uses Beneficio::setMatriculaSiapeNes84()
     * @uses Beneficio::setNaturezaPensao()
     * @uses Beneficio::setNomeCartorio()
     * @uses Beneficio::setNumeroBeneficioInss()
     * @uses Beneficio::setNumeroFolha()
     * @uses Beneficio::setNumeroLeiPensao()
     * @uses Beneficio::setNumeroLivro()
     * @uses Beneficio::setNumeroProcesso()
     * @uses Beneficio::setNumeroSerpro()
     * @uses Beneficio::setOcorrenciaExclusao()
     * @uses Beneficio::setOrgaoJudicial()
     * @uses Beneficio::setPagamentoSuspenso()
     * @uses Beneficio::setParentesco()
     * @uses Beneficio::setRepresentanteLegal()
     * @uses Beneficio::setSituacao()
     * @uses Beneficio::setSituacaoRepresentanteLegal()
     * @uses Beneficio::setStatus()
     * @uses Beneficio::setTipoConta()
     * @uses Beneficio::setTipoPensao()
     * @uses Beneficio::setTipoRepresentanteLegal()
     * @uses Beneficio::setUfApsis()
     * @uses Beneficio::setUorgControle()
     * @uses Beneficio::setUorgLocalizacao()
     * @uses Beneficio::setCodigoUnidadeControle()
     * @uses Beneficio::setCodigoUnidadeLocalizacao()
     * @uses Beneficio::setFichaFinanceira()
     * @uses Beneficio::setNomeUnidadeLocalizacao()
     * @uses Beneficio::setNomeUnidadeControle()
     * @param string $bancoAgencia
     * @param \StructType\Beneficiado $beneficiado
     * @param string $complContaJudicial
     * @param string $conta
     * @param string $contaPagamento
     * @param string $cotaParte
     * @param string $cotaComplementar
     * @param int $cpfCadastrador
     * @param string $dataExclusao
     * @param string $dataFimProcuracao
     * @param string $dataInclusaoBeneficio
     * @param string $dataInicioBeneficio
     * @param string $dataInicioProcuracao
     * @param string $dataTerminoBeneficio
     * @param string $especieBeneficioInss
     * @param \StructType\Instituidor $instituidor
     * @param \StructType\InstituidorLegal $instituidorLegal
     * @param string $mandadoSeguranca
     * @param string $matriculaOutras
     * @param string $matriculaSiapefaz
     * @param string $matriculaSiapeNes84
     * @param string $naturezaPensao
     * @param string $nomeCartorio
     * @param int $numeroBeneficioInss
     * @param string $numeroFolha
     * @param int $numeroLeiPensao
     * @param string $numeroLivro
     * @param int $numeroProcesso
     * @param int $numeroSerpro
     * @param string $ocorrenciaExclusao
     * @param \StructType\Orgao $orgaoJudicial
     * @param string $pagamentoSuspenso
     * @param string $parentesco
     * @param string $representanteLegal
     * @param string $situacao
     * @param string $situacaoRepresentanteLegal
     * @param string $status
     * @param string $tipoConta
     * @param string $tipoPensao
     * @param string $tipoRepresentanteLegal
     * @param string $ufApsis
     * @param string $uorgControle
     * @param string $uorgLocalizacao
     * @param int $codigoUnidadeControle
     * @param int $codigoUnidadeLocalizacao
     * @param \StructType\FichaFinanceira $fichaFinanceira
     * @param string $nomeUnidadeLocalizacao
     * @param string $nomeUnidadeControle
     */
    public function __construct($bancoAgencia = null, \StructType\Beneficiado $beneficiado = null, $complContaJudicial = null, $conta = null, $contaPagamento = null, $cotaParte = null, $cotaComplementar = null, $cpfCadastrador = null, $dataExclusao = null, $dataFimProcuracao = null, $dataInclusaoBeneficio = null, $dataInicioBeneficio = null, $dataInicioProcuracao = null, $dataTerminoBeneficio = null, $especieBeneficioInss = null, \StructType\Instituidor $instituidor = null, \StructType\InstituidorLegal $instituidorLegal = null, $mandadoSeguranca = null, $matriculaOutras = null, $matriculaSiapefaz = null, $matriculaSiapeNes84 = null, $naturezaPensao = null, $nomeCartorio = null, $numeroBeneficioInss = null, $numeroFolha = null, $numeroLeiPensao = null, $numeroLivro = null, $numeroProcesso = null, $numeroSerpro = null, $ocorrenciaExclusao = null, \StructType\Orgao $orgaoJudicial = null, $pagamentoSuspenso = null, $parentesco = null, $representanteLegal = null, $situacao = null, $situacaoRepresentanteLegal = null, $status = null, $tipoConta = null, $tipoPensao = null, $tipoRepresentanteLegal = null, $ufApsis = null, $uorgControle = null, $uorgLocalizacao = null, $codigoUnidadeControle = null, $codigoUnidadeLocalizacao = null, \StructType\FichaFinanceira $fichaFinanceira = null, $nomeUnidadeLocalizacao = null, $nomeUnidadeControle = null)
    {
        $this
            ->setBancoAgencia($bancoAgencia)
            ->setBeneficiado($beneficiado)
            ->setComplContaJudicial($complContaJudicial)
            ->setConta($conta)
            ->setContaPagamento($contaPagamento)
            ->setCotaParte($cotaParte)
            ->setCotaComplementar($cotaComplementar)
            ->setCpfCadastrador($cpfCadastrador)
            ->setDataExclusao($dataExclusao)
            ->setDataFimProcuracao($dataFimProcuracao)
            ->setDataInclusaoBeneficio($dataInclusaoBeneficio)
            ->setDataInicioBeneficio($dataInicioBeneficio)
            ->setDataInicioProcuracao($dataInicioProcuracao)
            ->setDataTerminoBeneficio($dataTerminoBeneficio)
            ->setEspecieBeneficioInss($especieBeneficioInss)
            ->setInstituidor($instituidor)
            ->setInstituidorLegal($instituidorLegal)
            ->setMandadoSeguranca($mandadoSeguranca)
            ->setMatriculaOutras($matriculaOutras)
            ->setMatriculaSiapefaz($matriculaSiapefaz)
            ->setMatriculaSiapeNes84($matriculaSiapeNes84)
            ->setNaturezaPensao($naturezaPensao)
            ->setNomeCartorio($nomeCartorio)
            ->setNumeroBeneficioInss($numeroBeneficioInss)
            ->setNumeroFolha($numeroFolha)
            ->setNumeroLeiPensao($numeroLeiPensao)
            ->setNumeroLivro($numeroLivro)
            ->setNumeroProcesso($numeroProcesso)
            ->setNumeroSerpro($numeroSerpro)
            ->setOcorrenciaExclusao($ocorrenciaExclusao)
            ->setOrgaoJudicial($orgaoJudicial)
            ->setPagamentoSuspenso($pagamentoSuspenso)
            ->setParentesco($parentesco)
            ->setRepresentanteLegal($representanteLegal)
            ->setSituacao($situacao)
            ->setSituacaoRepresentanteLegal($situacaoRepresentanteLegal)
            ->setStatus($status)
            ->setTipoConta($tipoConta)
            ->setTipoPensao($tipoPensao)
            ->setTipoRepresentanteLegal($tipoRepresentanteLegal)
            ->setUfApsis($ufApsis)
            ->setUorgControle($uorgControle)
            ->setUorgLocalizacao($uorgLocalizacao)
            ->setCodigoUnidadeControle($codigoUnidadeControle)
            ->setCodigoUnidadeLocalizacao($codigoUnidadeLocalizacao)
            ->setFichaFinanceira($fichaFinanceira)
            ->setNomeUnidadeLocalizacao($nomeUnidadeLocalizacao)
            ->setNomeUnidadeControle($nomeUnidadeControle);
    }
    /**
     * Get bancoAgencia value
     * @return string|null
     */
    public function getBancoAgencia()
    {
        return $this->bancoAgencia;
    }
    /**
     * Set bancoAgencia value
     * @param string $bancoAgencia
     * @return \StructType\Beneficio
     */
    public function setBancoAgencia($bancoAgencia = null)
    {
        // validation for constraint: string
        if (!is_null($bancoAgencia) && !is_string($bancoAgencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bancoAgencia, true), gettype($bancoAgencia)), __LINE__);
        }
        $this->bancoAgencia = $bancoAgencia;
        return $this;
    }
    /**
     * Get beneficiado value
     * @return \StructType\Beneficiado|null
     */
    public function getBeneficiado()
    {
        return $this->beneficiado;
    }
    /**
     * Set beneficiado value
     * @param \StructType\Beneficiado $beneficiado
     * @return \StructType\Beneficio
     */
    public function setBeneficiado(\StructType\Beneficiado $beneficiado = null)
    {
        $this->beneficiado = $beneficiado;
        return $this;
    }
    /**
     * Get complContaJudicial value
     * @return string|null
     */
    public function getComplContaJudicial()
    {
        return $this->complContaJudicial;
    }
    /**
     * Set complContaJudicial value
     * @param string $complContaJudicial
     * @return \StructType\Beneficio
     */
    public function setComplContaJudicial($complContaJudicial = null)
    {
        // validation for constraint: string
        if (!is_null($complContaJudicial) && !is_string($complContaJudicial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($complContaJudicial, true), gettype($complContaJudicial)), __LINE__);
        }
        $this->complContaJudicial = $complContaJudicial;
        return $this;
    }
    /**
     * Get conta value
     * @return string|null
     */
    public function getConta()
    {
        return $this->conta;
    }
    /**
     * Set conta value
     * @param string $conta
     * @return \StructType\Beneficio
     */
    public function setConta($conta = null)
    {
        // validation for constraint: string
        if (!is_null($conta) && !is_string($conta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conta, true), gettype($conta)), __LINE__);
        }
        $this->conta = $conta;
        return $this;
    }
    /**
     * Get contaPagamento value
     * @return string|null
     */
    public function getContaPagamento()
    {
        return $this->contaPagamento;
    }
    /**
     * Set contaPagamento value
     * @param string $contaPagamento
     * @return \StructType\Beneficio
     */
    public function setContaPagamento($contaPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($contaPagamento) && !is_string($contaPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contaPagamento, true), gettype($contaPagamento)), __LINE__);
        }
        $this->contaPagamento = $contaPagamento;
        return $this;
    }
    /**
     * Get cotaParte value
     * @return string|null
     */
    public function getCotaParte()
    {
        return $this->cotaParte;
    }
    /**
     * Set cotaParte value
     * @param string $cotaParte
     * @return \StructType\Beneficio
     */
    public function setCotaParte($cotaParte = null)
    {
        // validation for constraint: string
        if (!is_null($cotaParte) && !is_string($cotaParte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cotaParte, true), gettype($cotaParte)), __LINE__);
        }
        $this->cotaParte = $cotaParte;
        return $this;
    }
    /**
     * Get cotaComplementar value
     * @return string|null
     */
    public function getCotaComplementar()
    {
        return $this->cotaComplementar;
    }
    /**
     * Set cotaComplementar value
     * @param string $cotaComplementar
     * @return \StructType\Beneficio
     */
    public function setCotaComplementar($cotaComplementar = null)
    {
        // validation for constraint: string
        if (!is_null($cotaComplementar) && !is_string($cotaComplementar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cotaComplementar, true), gettype($cotaComplementar)), __LINE__);
        }
        $this->cotaComplementar = $cotaComplementar;
        return $this;
    }
    /**
     * Get cpfCadastrador value
     * @return int|null
     */
    public function getCpfCadastrador()
    {
        return $this->cpfCadastrador;
    }
    /**
     * Set cpfCadastrador value
     * @param int $cpfCadastrador
     * @return \StructType\Beneficio
     */
    public function setCpfCadastrador($cpfCadastrador = null)
    {
        // validation for constraint: int
        if (!is_null($cpfCadastrador) && !(is_int($cpfCadastrador) || ctype_digit($cpfCadastrador))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cpfCadastrador, true), gettype($cpfCadastrador)), __LINE__);
        }
        $this->cpfCadastrador = $cpfCadastrador;
        return $this;
    }
    /**
     * Get dataExclusao value
     * @return string|null
     */
    public function getDataExclusao()
    {
        return $this->dataExclusao;
    }
    /**
     * Set dataExclusao value
     * @param string $dataExclusao
     * @return \StructType\Beneficio
     */
    public function setDataExclusao($dataExclusao = null)
    {
        // validation for constraint: string
        if (!is_null($dataExclusao) && !is_string($dataExclusao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataExclusao, true), gettype($dataExclusao)), __LINE__);
        }
        $this->dataExclusao = $dataExclusao;
        return $this;
    }
    /**
     * Get dataFimProcuracao value
     * @return string|null
     */
    public function getDataFimProcuracao()
    {
        return $this->dataFimProcuracao;
    }
    /**
     * Set dataFimProcuracao value
     * @param string $dataFimProcuracao
     * @return \StructType\Beneficio
     */
    public function setDataFimProcuracao($dataFimProcuracao = null)
    {
        // validation for constraint: string
        if (!is_null($dataFimProcuracao) && !is_string($dataFimProcuracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFimProcuracao, true), gettype($dataFimProcuracao)), __LINE__);
        }
        $this->dataFimProcuracao = $dataFimProcuracao;
        return $this;
    }
    /**
     * Get dataInclusaoBeneficio value
     * @return string|null
     */
    public function getDataInclusaoBeneficio()
    {
        return $this->dataInclusaoBeneficio;
    }
    /**
     * Set dataInclusaoBeneficio value
     * @param string $dataInclusaoBeneficio
     * @return \StructType\Beneficio
     */
    public function setDataInclusaoBeneficio($dataInclusaoBeneficio = null)
    {
        // validation for constraint: string
        if (!is_null($dataInclusaoBeneficio) && !is_string($dataInclusaoBeneficio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInclusaoBeneficio, true), gettype($dataInclusaoBeneficio)), __LINE__);
        }
        $this->dataInclusaoBeneficio = $dataInclusaoBeneficio;
        return $this;
    }
    /**
     * Get dataInicioBeneficio value
     * @return string|null
     */
    public function getDataInicioBeneficio()
    {
        return $this->dataInicioBeneficio;
    }
    /**
     * Set dataInicioBeneficio value
     * @param string $dataInicioBeneficio
     * @return \StructType\Beneficio
     */
    public function setDataInicioBeneficio($dataInicioBeneficio = null)
    {
        // validation for constraint: string
        if (!is_null($dataInicioBeneficio) && !is_string($dataInicioBeneficio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInicioBeneficio, true), gettype($dataInicioBeneficio)), __LINE__);
        }
        $this->dataInicioBeneficio = $dataInicioBeneficio;
        return $this;
    }
    /**
     * Get dataInicioProcuracao value
     * @return string|null
     */
    public function getDataInicioProcuracao()
    {
        return $this->dataInicioProcuracao;
    }
    /**
     * Set dataInicioProcuracao value
     * @param string $dataInicioProcuracao
     * @return \StructType\Beneficio
     */
    public function setDataInicioProcuracao($dataInicioProcuracao = null)
    {
        // validation for constraint: string
        if (!is_null($dataInicioProcuracao) && !is_string($dataInicioProcuracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInicioProcuracao, true), gettype($dataInicioProcuracao)), __LINE__);
        }
        $this->dataInicioProcuracao = $dataInicioProcuracao;
        return $this;
    }
    /**
     * Get dataTerminoBeneficio value
     * @return string|null
     */
    public function getDataTerminoBeneficio()
    {
        return $this->dataTerminoBeneficio;
    }
    /**
     * Set dataTerminoBeneficio value
     * @param string $dataTerminoBeneficio
     * @return \StructType\Beneficio
     */
    public function setDataTerminoBeneficio($dataTerminoBeneficio = null)
    {
        // validation for constraint: string
        if (!is_null($dataTerminoBeneficio) && !is_string($dataTerminoBeneficio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTerminoBeneficio, true), gettype($dataTerminoBeneficio)), __LINE__);
        }
        $this->dataTerminoBeneficio = $dataTerminoBeneficio;
        return $this;
    }
    /**
     * Get especieBeneficioInss value
     * @return string|null
     */
    public function getEspecieBeneficioInss()
    {
        return $this->especieBeneficioInss;
    }
    /**
     * Set especieBeneficioInss value
     * @param string $especieBeneficioInss
     * @return \StructType\Beneficio
     */
    public function setEspecieBeneficioInss($especieBeneficioInss = null)
    {
        // validation for constraint: string
        if (!is_null($especieBeneficioInss) && !is_string($especieBeneficioInss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($especieBeneficioInss, true), gettype($especieBeneficioInss)), __LINE__);
        }
        $this->especieBeneficioInss = $especieBeneficioInss;
        return $this;
    }
    /**
     * Get instituidor value
     * @return \StructType\Instituidor|null
     */
    public function getInstituidor()
    {
        return $this->instituidor;
    }
    /**
     * Set instituidor value
     * @param \StructType\Instituidor $instituidor
     * @return \StructType\Beneficio
     */
    public function setInstituidor(\StructType\Instituidor $instituidor = null)
    {
        $this->instituidor = $instituidor;
        return $this;
    }
    /**
     * Get instituidorLegal value
     * @return \StructType\InstituidorLegal|null
     */
    public function getInstituidorLegal()
    {
        return $this->instituidorLegal;
    }
    /**
     * Set instituidorLegal value
     * @param \StructType\InstituidorLegal $instituidorLegal
     * @return \StructType\Beneficio
     */
    public function setInstituidorLegal(\StructType\InstituidorLegal $instituidorLegal = null)
    {
        $this->instituidorLegal = $instituidorLegal;
        return $this;
    }
    /**
     * Get mandadoSeguranca value
     * @return string|null
     */
    public function getMandadoSeguranca()
    {
        return $this->mandadoSeguranca;
    }
    /**
     * Set mandadoSeguranca value
     * @param string $mandadoSeguranca
     * @return \StructType\Beneficio
     */
    public function setMandadoSeguranca($mandadoSeguranca = null)
    {
        // validation for constraint: string
        if (!is_null($mandadoSeguranca) && !is_string($mandadoSeguranca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandadoSeguranca, true), gettype($mandadoSeguranca)), __LINE__);
        }
        $this->mandadoSeguranca = $mandadoSeguranca;
        return $this;
    }
    /**
     * Get matriculaOutras value
     * @return string|null
     */
    public function getMatriculaOutras()
    {
        return $this->matriculaOutras;
    }
    /**
     * Set matriculaOutras value
     * @param string $matriculaOutras
     * @return \StructType\Beneficio
     */
    public function setMatriculaOutras($matriculaOutras = null)
    {
        // validation for constraint: string
        if (!is_null($matriculaOutras) && !is_string($matriculaOutras)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matriculaOutras, true), gettype($matriculaOutras)), __LINE__);
        }
        $this->matriculaOutras = $matriculaOutras;
        return $this;
    }
    /**
     * Get matriculaSiapefaz value
     * @return string|null
     */
    public function getMatriculaSiapefaz()
    {
        return $this->matriculaSiapefaz;
    }
    /**
     * Set matriculaSiapefaz value
     * @param string $matriculaSiapefaz
     * @return \StructType\Beneficio
     */
    public function setMatriculaSiapefaz($matriculaSiapefaz = null)
    {
        // validation for constraint: string
        if (!is_null($matriculaSiapefaz) && !is_string($matriculaSiapefaz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matriculaSiapefaz, true), gettype($matriculaSiapefaz)), __LINE__);
        }
        $this->matriculaSiapefaz = $matriculaSiapefaz;
        return $this;
    }
    /**
     * Get matriculaSiapeNes84 value
     * @return string|null
     */
    public function getMatriculaSiapeNes84()
    {
        return $this->matriculaSiapeNes84;
    }
    /**
     * Set matriculaSiapeNes84 value
     * @param string $matriculaSiapeNes84
     * @return \StructType\Beneficio
     */
    public function setMatriculaSiapeNes84($matriculaSiapeNes84 = null)
    {
        // validation for constraint: string
        if (!is_null($matriculaSiapeNes84) && !is_string($matriculaSiapeNes84)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matriculaSiapeNes84, true), gettype($matriculaSiapeNes84)), __LINE__);
        }
        $this->matriculaSiapeNes84 = $matriculaSiapeNes84;
        return $this;
    }
    /**
     * Get naturezaPensao value
     * @return string|null
     */
    public function getNaturezaPensao()
    {
        return $this->naturezaPensao;
    }
    /**
     * Set naturezaPensao value
     * @param string $naturezaPensao
     * @return \StructType\Beneficio
     */
    public function setNaturezaPensao($naturezaPensao = null)
    {
        // validation for constraint: string
        if (!is_null($naturezaPensao) && !is_string($naturezaPensao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naturezaPensao, true), gettype($naturezaPensao)), __LINE__);
        }
        $this->naturezaPensao = $naturezaPensao;
        return $this;
    }
    /**
     * Get nomeCartorio value
     * @return string|null
     */
    public function getNomeCartorio()
    {
        return $this->nomeCartorio;
    }
    /**
     * Set nomeCartorio value
     * @param string $nomeCartorio
     * @return \StructType\Beneficio
     */
    public function setNomeCartorio($nomeCartorio = null)
    {
        // validation for constraint: string
        if (!is_null($nomeCartorio) && !is_string($nomeCartorio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeCartorio, true), gettype($nomeCartorio)), __LINE__);
        }
        $this->nomeCartorio = $nomeCartorio;
        return $this;
    }
    /**
     * Get numeroBeneficioInss value
     * @return int|null
     */
    public function getNumeroBeneficioInss()
    {
        return $this->numeroBeneficioInss;
    }
    /**
     * Set numeroBeneficioInss value
     * @param int $numeroBeneficioInss
     * @return \StructType\Beneficio
     */
    public function setNumeroBeneficioInss($numeroBeneficioInss = null)
    {
        // validation for constraint: int
        if (!is_null($numeroBeneficioInss) && !(is_int($numeroBeneficioInss) || ctype_digit($numeroBeneficioInss))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroBeneficioInss, true), gettype($numeroBeneficioInss)), __LINE__);
        }
        $this->numeroBeneficioInss = $numeroBeneficioInss;
        return $this;
    }
    /**
     * Get numeroFolha value
     * @return string|null
     */
    public function getNumeroFolha()
    {
        return $this->numeroFolha;
    }
    /**
     * Set numeroFolha value
     * @param string $numeroFolha
     * @return \StructType\Beneficio
     */
    public function setNumeroFolha($numeroFolha = null)
    {
        // validation for constraint: string
        if (!is_null($numeroFolha) && !is_string($numeroFolha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroFolha, true), gettype($numeroFolha)), __LINE__);
        }
        $this->numeroFolha = $numeroFolha;
        return $this;
    }
    /**
     * Get numeroLeiPensao value
     * @return int|null
     */
    public function getNumeroLeiPensao()
    {
        return $this->numeroLeiPensao;
    }
    /**
     * Set numeroLeiPensao value
     * @param int $numeroLeiPensao
     * @return \StructType\Beneficio
     */
    public function setNumeroLeiPensao($numeroLeiPensao = null)
    {
        // validation for constraint: int
        if (!is_null($numeroLeiPensao) && !(is_int($numeroLeiPensao) || ctype_digit($numeroLeiPensao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroLeiPensao, true), gettype($numeroLeiPensao)), __LINE__);
        }
        $this->numeroLeiPensao = $numeroLeiPensao;
        return $this;
    }
    /**
     * Get numeroLivro value
     * @return string|null
     */
    public function getNumeroLivro()
    {
        return $this->numeroLivro;
    }
    /**
     * Set numeroLivro value
     * @param string $numeroLivro
     * @return \StructType\Beneficio
     */
    public function setNumeroLivro($numeroLivro = null)
    {
        // validation for constraint: string
        if (!is_null($numeroLivro) && !is_string($numeroLivro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroLivro, true), gettype($numeroLivro)), __LINE__);
        }
        $this->numeroLivro = $numeroLivro;
        return $this;
    }
    /**
     * Get numeroProcesso value
     * @return int|null
     */
    public function getNumeroProcesso()
    {
        return $this->numeroProcesso;
    }
    /**
     * Set numeroProcesso value
     * @param int $numeroProcesso
     * @return \StructType\Beneficio
     */
    public function setNumeroProcesso($numeroProcesso = null)
    {
        // validation for constraint: int
        if (!is_null($numeroProcesso) && !(is_int($numeroProcesso) || ctype_digit($numeroProcesso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroProcesso, true), gettype($numeroProcesso)), __LINE__);
        }
        $this->numeroProcesso = $numeroProcesso;
        return $this;
    }
    /**
     * Get numeroSerpro value
     * @return int|null
     */
    public function getNumeroSerpro()
    {
        return $this->numeroSerpro;
    }
    /**
     * Set numeroSerpro value
     * @param int $numeroSerpro
     * @return \StructType\Beneficio
     */
    public function setNumeroSerpro($numeroSerpro = null)
    {
        // validation for constraint: int
        if (!is_null($numeroSerpro) && !(is_int($numeroSerpro) || ctype_digit($numeroSerpro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroSerpro, true), gettype($numeroSerpro)), __LINE__);
        }
        $this->numeroSerpro = $numeroSerpro;
        return $this;
    }
    /**
     * Get ocorrenciaExclusao value
     * @return string|null
     */
    public function getOcorrenciaExclusao()
    {
        return $this->ocorrenciaExclusao;
    }
    /**
     * Set ocorrenciaExclusao value
     * @param string $ocorrenciaExclusao
     * @return \StructType\Beneficio
     */
    public function setOcorrenciaExclusao($ocorrenciaExclusao = null)
    {
        // validation for constraint: string
        if (!is_null($ocorrenciaExclusao) && !is_string($ocorrenciaExclusao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ocorrenciaExclusao, true), gettype($ocorrenciaExclusao)), __LINE__);
        }
        $this->ocorrenciaExclusao = $ocorrenciaExclusao;
        return $this;
    }
    /**
     * Get orgaoJudicial value
     * @return \StructType\Orgao|null
     */
    public function getOrgaoJudicial()
    {
        return $this->orgaoJudicial;
    }
    /**
     * Set orgaoJudicial value
     * @param \StructType\Orgao $orgaoJudicial
     * @return \StructType\Beneficio
     */
    public function setOrgaoJudicial(\StructType\Orgao $orgaoJudicial = null)
    {
        $this->orgaoJudicial = $orgaoJudicial;
        return $this;
    }
    /**
     * Get pagamentoSuspenso value
     * @return string|null
     */
    public function getPagamentoSuspenso()
    {
        return $this->pagamentoSuspenso;
    }
    /**
     * Set pagamentoSuspenso value
     * @param string $pagamentoSuspenso
     * @return \StructType\Beneficio
     */
    public function setPagamentoSuspenso($pagamentoSuspenso = null)
    {
        // validation for constraint: string
        if (!is_null($pagamentoSuspenso) && !is_string($pagamentoSuspenso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pagamentoSuspenso, true), gettype($pagamentoSuspenso)), __LINE__);
        }
        $this->pagamentoSuspenso = $pagamentoSuspenso;
        return $this;
    }
    /**
     * Get parentesco value
     * @return string|null
     */
    public function getParentesco()
    {
        return $this->parentesco;
    }
    /**
     * Set parentesco value
     * @param string $parentesco
     * @return \StructType\Beneficio
     */
    public function setParentesco($parentesco = null)
    {
        // validation for constraint: string
        if (!is_null($parentesco) && !is_string($parentesco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentesco, true), gettype($parentesco)), __LINE__);
        }
        $this->parentesco = $parentesco;
        return $this;
    }
    /**
     * Get representanteLegal value
     * @return string|null
     */
    public function getRepresentanteLegal()
    {
        return $this->representanteLegal;
    }
    /**
     * Set representanteLegal value
     * @param string $representanteLegal
     * @return \StructType\Beneficio
     */
    public function setRepresentanteLegal($representanteLegal = null)
    {
        // validation for constraint: string
        if (!is_null($representanteLegal) && !is_string($representanteLegal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($representanteLegal, true), gettype($representanteLegal)), __LINE__);
        }
        $this->representanteLegal = $representanteLegal;
        return $this;
    }
    /**
     * Get situacao value
     * @return string|null
     */
    public function getSituacao()
    {
        return $this->situacao;
    }
    /**
     * Set situacao value
     * @param string $situacao
     * @return \StructType\Beneficio
     */
    public function setSituacao($situacao = null)
    {
        // validation for constraint: string
        if (!is_null($situacao) && !is_string($situacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($situacao, true), gettype($situacao)), __LINE__);
        }
        $this->situacao = $situacao;
        return $this;
    }
    /**
     * Get situacaoRepresentanteLegal value
     * @return string|null
     */
    public function getSituacaoRepresentanteLegal()
    {
        return $this->situacaoRepresentanteLegal;
    }
    /**
     * Set situacaoRepresentanteLegal value
     * @param string $situacaoRepresentanteLegal
     * @return \StructType\Beneficio
     */
    public function setSituacaoRepresentanteLegal($situacaoRepresentanteLegal = null)
    {
        // validation for constraint: string
        if (!is_null($situacaoRepresentanteLegal) && !is_string($situacaoRepresentanteLegal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($situacaoRepresentanteLegal, true), gettype($situacaoRepresentanteLegal)), __LINE__);
        }
        $this->situacaoRepresentanteLegal = $situacaoRepresentanteLegal;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Beneficio
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get tipoConta value
     * @return string|null
     */
    public function getTipoConta()
    {
        return $this->tipoConta;
    }
    /**
     * Set tipoConta value
     * @param string $tipoConta
     * @return \StructType\Beneficio
     */
    public function setTipoConta($tipoConta = null)
    {
        // validation for constraint: string
        if (!is_null($tipoConta) && !is_string($tipoConta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoConta, true), gettype($tipoConta)), __LINE__);
        }
        $this->tipoConta = $tipoConta;
        return $this;
    }
    /**
     * Get tipoPensao value
     * @return string|null
     */
    public function getTipoPensao()
    {
        return $this->tipoPensao;
    }
    /**
     * Set tipoPensao value
     * @param string $tipoPensao
     * @return \StructType\Beneficio
     */
    public function setTipoPensao($tipoPensao = null)
    {
        // validation for constraint: string
        if (!is_null($tipoPensao) && !is_string($tipoPensao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoPensao, true), gettype($tipoPensao)), __LINE__);
        }
        $this->tipoPensao = $tipoPensao;
        return $this;
    }
    /**
     * Get tipoRepresentanteLegal value
     * @return string|null
     */
    public function getTipoRepresentanteLegal()
    {
        return $this->tipoRepresentanteLegal;
    }
    /**
     * Set tipoRepresentanteLegal value
     * @param string $tipoRepresentanteLegal
     * @return \StructType\Beneficio
     */
    public function setTipoRepresentanteLegal($tipoRepresentanteLegal = null)
    {
        // validation for constraint: string
        if (!is_null($tipoRepresentanteLegal) && !is_string($tipoRepresentanteLegal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoRepresentanteLegal, true), gettype($tipoRepresentanteLegal)), __LINE__);
        }
        $this->tipoRepresentanteLegal = $tipoRepresentanteLegal;
        return $this;
    }
    /**
     * Get ufApsis value
     * @return string|null
     */
    public function getUfApsis()
    {
        return $this->ufApsis;
    }
    /**
     * Set ufApsis value
     * @param string $ufApsis
     * @return \StructType\Beneficio
     */
    public function setUfApsis($ufApsis = null)
    {
        // validation for constraint: string
        if (!is_null($ufApsis) && !is_string($ufApsis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ufApsis, true), gettype($ufApsis)), __LINE__);
        }
        $this->ufApsis = $ufApsis;
        return $this;
    }
    /**
     * Get uorgControle value
     * @return string|null
     */
    public function getUorgControle()
    {
        return $this->uorgControle;
    }
    /**
     * Set uorgControle value
     * @param string $uorgControle
     * @return \StructType\Beneficio
     */
    public function setUorgControle($uorgControle = null)
    {
        // validation for constraint: string
        if (!is_null($uorgControle) && !is_string($uorgControle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uorgControle, true), gettype($uorgControle)), __LINE__);
        }
        $this->uorgControle = $uorgControle;
        return $this;
    }
    /**
     * Get uorgLocalizacao value
     * @return string|null
     */
    public function getUorgLocalizacao()
    {
        return $this->uorgLocalizacao;
    }
    /**
     * Set uorgLocalizacao value
     * @param string $uorgLocalizacao
     * @return \StructType\Beneficio
     */
    public function setUorgLocalizacao($uorgLocalizacao = null)
    {
        // validation for constraint: string
        if (!is_null($uorgLocalizacao) && !is_string($uorgLocalizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uorgLocalizacao, true), gettype($uorgLocalizacao)), __LINE__);
        }
        $this->uorgLocalizacao = $uorgLocalizacao;
        return $this;
    }
    /**
     * Get codigoUnidadeControle value
     * @return int|null
     */
    public function getCodigoUnidadeControle()
    {
        return $this->codigoUnidadeControle;
    }
    /**
     * Set codigoUnidadeControle value
     * @param int $codigoUnidadeControle
     * @return \StructType\Beneficio
     */
    public function setCodigoUnidadeControle($codigoUnidadeControle = null)
    {
        // validation for constraint: int
        if (!is_null($codigoUnidadeControle) && !(is_int($codigoUnidadeControle) || ctype_digit($codigoUnidadeControle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoUnidadeControle, true), gettype($codigoUnidadeControle)), __LINE__);
        }
        $this->codigoUnidadeControle = $codigoUnidadeControle;
        return $this;
    }
    /**
     * Get codigoUnidadeLocalizacao value
     * @return int|null
     */
    public function getCodigoUnidadeLocalizacao()
    {
        return $this->codigoUnidadeLocalizacao;
    }
    /**
     * Set codigoUnidadeLocalizacao value
     * @param int $codigoUnidadeLocalizacao
     * @return \StructType\Beneficio
     */
    public function setCodigoUnidadeLocalizacao($codigoUnidadeLocalizacao = null)
    {
        // validation for constraint: int
        if (!is_null($codigoUnidadeLocalizacao) && !(is_int($codigoUnidadeLocalizacao) || ctype_digit($codigoUnidadeLocalizacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoUnidadeLocalizacao, true), gettype($codigoUnidadeLocalizacao)), __LINE__);
        }
        $this->codigoUnidadeLocalizacao = $codigoUnidadeLocalizacao;
        return $this;
    }
    /**
     * Get fichaFinanceira value
     * @return \StructType\FichaFinanceira|null
     */
    public function getFichaFinanceira()
    {
        return $this->fichaFinanceira;
    }
    /**
     * Set fichaFinanceira value
     * @param \StructType\FichaFinanceira $fichaFinanceira
     * @return \StructType\Beneficio
     */
    public function setFichaFinanceira(\StructType\FichaFinanceira $fichaFinanceira = null)
    {
        $this->fichaFinanceira = $fichaFinanceira;
        return $this;
    }
    /**
     * Get nomeUnidadeLocalizacao value
     * @return string|null
     */
    public function getNomeUnidadeLocalizacao()
    {
        return $this->nomeUnidadeLocalizacao;
    }
    /**
     * Set nomeUnidadeLocalizacao value
     * @param string $nomeUnidadeLocalizacao
     * @return \StructType\Beneficio
     */
    public function setNomeUnidadeLocalizacao($nomeUnidadeLocalizacao = null)
    {
        // validation for constraint: string
        if (!is_null($nomeUnidadeLocalizacao) && !is_string($nomeUnidadeLocalizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeUnidadeLocalizacao, true), gettype($nomeUnidadeLocalizacao)), __LINE__);
        }
        $this->nomeUnidadeLocalizacao = $nomeUnidadeLocalizacao;
        return $this;
    }
    /**
     * Get nomeUnidadeControle value
     * @return string|null
     */
    public function getNomeUnidadeControle()
    {
        return $this->nomeUnidadeControle;
    }
    /**
     * Set nomeUnidadeControle value
     * @param string $nomeUnidadeControle
     * @return \StructType\Beneficio
     */
    public function setNomeUnidadeControle($nomeUnidadeControle = null)
    {
        // validation for constraint: string
        if (!is_null($nomeUnidadeControle) && !is_string($nomeUnidadeControle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeUnidadeControle, true), gettype($nomeUnidadeControle)), __LINE__);
        }
        $this->nomeUnidadeControle = $nomeUnidadeControle;
        return $this;
    }
}
