<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcaoJudicial StructType
 * @subpackage Structs
 */
class AcaoJudicial extends BaseModel
{
    /**
     * The advogados
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Advogados
     */
    public $advogados;
    /**
     * The classe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $classe;
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigo;
    /**
     * The dataAjuizamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataAjuizamento;
    /**
     * The dataPublicacaoNotificacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataPublicacaoNotificacao;
    /**
     * The dataTransitoJulgado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataTransitoJulgado;
    /**
     * The descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * The orgaosDaAcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OrgaosDaAcao
     */
    public $orgaosDaAcao;
    /**
     * The juizo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $juizo;
    /**
     * The justificativa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $justificativa;
    /**
     * The nomeAutor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nomeAutor;
    /**
     * The objetos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Objetos
     */
    public $objetos;
    /**
     * The processoJudicial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $processoJudicial;
    /**
     * The rubricas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Rubricas
     */
    public $rubricas;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The estagio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $estagio;
    /**
     * The hasMaisResultados
     * @var bool
     */
    public $hasMaisResultados;
    /**
     * Constructor method for AcaoJudicial
     * @uses AcaoJudicial::setAdvogados()
     * @uses AcaoJudicial::setClasse()
     * @uses AcaoJudicial::setCodigo()
     * @uses AcaoJudicial::setDataAjuizamento()
     * @uses AcaoJudicial::setDataPublicacaoNotificacao()
     * @uses AcaoJudicial::setDataTransitoJulgado()
     * @uses AcaoJudicial::setDescricao()
     * @uses AcaoJudicial::setOrgaosDaAcao()
     * @uses AcaoJudicial::setJuizo()
     * @uses AcaoJudicial::setJustificativa()
     * @uses AcaoJudicial::setNomeAutor()
     * @uses AcaoJudicial::setObjetos()
     * @uses AcaoJudicial::setProcessoJudicial()
     * @uses AcaoJudicial::setRubricas()
     * @uses AcaoJudicial::setStatus()
     * @uses AcaoJudicial::setEstagio()
     * @uses AcaoJudicial::setHasMaisResultados()
     * @param \StructType\Advogados $advogados
     * @param string $classe
     * @param int $codigo
     * @param string $dataAjuizamento
     * @param string $dataPublicacaoNotificacao
     * @param string $dataTransitoJulgado
     * @param string $descricao
     * @param \StructType\OrgaosDaAcao $orgaosDaAcao
     * @param string $juizo
     * @param string $justificativa
     * @param string $nomeAutor
     * @param \StructType\Objetos $objetos
     * @param string $processoJudicial
     * @param \StructType\Rubricas $rubricas
     * @param string $status
     * @param string $estagio
     * @param bool $hasMaisResultados
     */
    public function __construct(\StructType\Advogados $advogados = null, $classe = null, $codigo = null, $dataAjuizamento = null, $dataPublicacaoNotificacao = null, $dataTransitoJulgado = null, $descricao = null, \StructType\OrgaosDaAcao $orgaosDaAcao = null, $juizo = null, $justificativa = null, $nomeAutor = null, \StructType\Objetos $objetos = null, $processoJudicial = null, \StructType\Rubricas $rubricas = null, $status = null, $estagio = null, $hasMaisResultados = null)
    {
        $this
            ->setAdvogados($advogados)
            ->setClasse($classe)
            ->setCodigo($codigo)
            ->setDataAjuizamento($dataAjuizamento)
            ->setDataPublicacaoNotificacao($dataPublicacaoNotificacao)
            ->setDataTransitoJulgado($dataTransitoJulgado)
            ->setDescricao($descricao)
            ->setOrgaosDaAcao($orgaosDaAcao)
            ->setJuizo($juizo)
            ->setJustificativa($justificativa)
            ->setNomeAutor($nomeAutor)
            ->setObjetos($objetos)
            ->setProcessoJudicial($processoJudicial)
            ->setRubricas($rubricas)
            ->setStatus($status)
            ->setEstagio($estagio)
            ->setHasMaisResultados($hasMaisResultados);
    }
    /**
     * Get advogados value
     * @return \StructType\Advogados|null
     */
    public function getAdvogados()
    {
        return $this->advogados;
    }
    /**
     * Set advogados value
     * @param \StructType\Advogados $advogados
     * @return \StructType\AcaoJudicial
     */
    public function setAdvogados(\StructType\Advogados $advogados = null)
    {
        $this->advogados = $advogados;
        return $this;
    }
    /**
     * Get classe value
     * @return string|null
     */
    public function getClasse()
    {
        return $this->classe;
    }
    /**
     * Set classe value
     * @param string $classe
     * @return \StructType\AcaoJudicial
     */
    public function setClasse($classe = null)
    {
        // validation for constraint: string
        if (!is_null($classe) && !is_string($classe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classe, true), gettype($classe)), __LINE__);
        }
        $this->classe = $classe;
        return $this;
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\AcaoJudicial
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get dataAjuizamento value
     * @return string|null
     */
    public function getDataAjuizamento()
    {
        return $this->dataAjuizamento;
    }
    /**
     * Set dataAjuizamento value
     * @param string $dataAjuizamento
     * @return \StructType\AcaoJudicial
     */
    public function setDataAjuizamento($dataAjuizamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataAjuizamento) && !is_string($dataAjuizamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAjuizamento, true), gettype($dataAjuizamento)), __LINE__);
        }
        $this->dataAjuizamento = $dataAjuizamento;
        return $this;
    }
    /**
     * Get dataPublicacaoNotificacao value
     * @return string|null
     */
    public function getDataPublicacaoNotificacao()
    {
        return $this->dataPublicacaoNotificacao;
    }
    /**
     * Set dataPublicacaoNotificacao value
     * @param string $dataPublicacaoNotificacao
     * @return \StructType\AcaoJudicial
     */
    public function setDataPublicacaoNotificacao($dataPublicacaoNotificacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataPublicacaoNotificacao) && !is_string($dataPublicacaoNotificacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataPublicacaoNotificacao, true), gettype($dataPublicacaoNotificacao)), __LINE__);
        }
        $this->dataPublicacaoNotificacao = $dataPublicacaoNotificacao;
        return $this;
    }
    /**
     * Get dataTransitoJulgado value
     * @return string|null
     */
    public function getDataTransitoJulgado()
    {
        return $this->dataTransitoJulgado;
    }
    /**
     * Set dataTransitoJulgado value
     * @param string $dataTransitoJulgado
     * @return \StructType\AcaoJudicial
     */
    public function setDataTransitoJulgado($dataTransitoJulgado = null)
    {
        // validation for constraint: string
        if (!is_null($dataTransitoJulgado) && !is_string($dataTransitoJulgado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTransitoJulgado, true), gettype($dataTransitoJulgado)), __LINE__);
        }
        $this->dataTransitoJulgado = $dataTransitoJulgado;
        return $this;
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\AcaoJudicial
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Get orgaosDaAcao value
     * @return \StructType\OrgaosDaAcao|null
     */
    public function getOrgaosDaAcao()
    {
        return $this->orgaosDaAcao;
    }
    /**
     * Set orgaosDaAcao value
     * @param \StructType\OrgaosDaAcao $orgaosDaAcao
     * @return \StructType\AcaoJudicial
     */
    public function setOrgaosDaAcao(\StructType\OrgaosDaAcao $orgaosDaAcao = null)
    {
        $this->orgaosDaAcao = $orgaosDaAcao;
        return $this;
    }
    /**
     * Get juizo value
     * @return string|null
     */
    public function getJuizo()
    {
        return $this->juizo;
    }
    /**
     * Set juizo value
     * @param string $juizo
     * @return \StructType\AcaoJudicial
     */
    public function setJuizo($juizo = null)
    {
        // validation for constraint: string
        if (!is_null($juizo) && !is_string($juizo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($juizo, true), gettype($juizo)), __LINE__);
        }
        $this->juizo = $juizo;
        return $this;
    }
    /**
     * Get justificativa value
     * @return string|null
     */
    public function getJustificativa()
    {
        return $this->justificativa;
    }
    /**
     * Set justificativa value
     * @param string $justificativa
     * @return \StructType\AcaoJudicial
     */
    public function setJustificativa($justificativa = null)
    {
        // validation for constraint: string
        if (!is_null($justificativa) && !is_string($justificativa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($justificativa, true), gettype($justificativa)), __LINE__);
        }
        $this->justificativa = $justificativa;
        return $this;
    }
    /**
     * Get nomeAutor value
     * @return string|null
     */
    public function getNomeAutor()
    {
        return $this->nomeAutor;
    }
    /**
     * Set nomeAutor value
     * @param string $nomeAutor
     * @return \StructType\AcaoJudicial
     */
    public function setNomeAutor($nomeAutor = null)
    {
        // validation for constraint: string
        if (!is_null($nomeAutor) && !is_string($nomeAutor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeAutor, true), gettype($nomeAutor)), __LINE__);
        }
        $this->nomeAutor = $nomeAutor;
        return $this;
    }
    /**
     * Get objetos value
     * @return \StructType\Objetos|null
     */
    public function getObjetos()
    {
        return $this->objetos;
    }
    /**
     * Set objetos value
     * @param \StructType\Objetos $objetos
     * @return \StructType\AcaoJudicial
     */
    public function setObjetos(\StructType\Objetos $objetos = null)
    {
        $this->objetos = $objetos;
        return $this;
    }
    /**
     * Get processoJudicial value
     * @return string|null
     */
    public function getProcessoJudicial()
    {
        return $this->processoJudicial;
    }
    /**
     * Set processoJudicial value
     * @param string $processoJudicial
     * @return \StructType\AcaoJudicial
     */
    public function setProcessoJudicial($processoJudicial = null)
    {
        // validation for constraint: string
        if (!is_null($processoJudicial) && !is_string($processoJudicial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processoJudicial, true), gettype($processoJudicial)), __LINE__);
        }
        $this->processoJudicial = $processoJudicial;
        return $this;
    }
    /**
     * Get rubricas value
     * @return \StructType\Rubricas|null
     */
    public function getRubricas()
    {
        return $this->rubricas;
    }
    /**
     * Set rubricas value
     * @param \StructType\Rubricas $rubricas
     * @return \StructType\AcaoJudicial
     */
    public function setRubricas(\StructType\Rubricas $rubricas = null)
    {
        $this->rubricas = $rubricas;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\AcaoJudicial
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get estagio value
     * @return string|null
     */
    public function getEstagio()
    {
        return $this->estagio;
    }
    /**
     * Set estagio value
     * @param string $estagio
     * @return \StructType\AcaoJudicial
     */
    public function setEstagio($estagio = null)
    {
        // validation for constraint: string
        if (!is_null($estagio) && !is_string($estagio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estagio, true), gettype($estagio)), __LINE__);
        }
        $this->estagio = $estagio;
        return $this;
    }
    /**
     * Get hasMaisResultados value
     * @return bool|null
     */
    public function getHasMaisResultados()
    {
        return $this->hasMaisResultados;
    }
    /**
     * Set hasMaisResultados value
     * @param bool $hasMaisResultados
     * @return \StructType\AcaoJudicial
     */
    public function setHasMaisResultados($hasMaisResultados = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMaisResultados) && !is_bool($hasMaisResultados)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMaisResultados, true), gettype($hasMaisResultados)), __LINE__);
        }
        $this->hasMaisResultados = $hasMaisResultados;
        return $this;
    }
}
