<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named findTransacaoByCpf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindTransacaoByCpf $parameters
     * @return \StructType\FindTransacaoByCpfResponse|bool
     */
    public function findTransacaoByCpf(\StructType\FindTransacaoByCpf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findTransacaoByCpf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findAcaoJudicialAndAdvogadosAndObjetosAcaoByCodigo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindAcaoJudicialAndAdvogadosAndObjetosAcaoByCodigo $parameters
     * @return \StructType\FindAcaoJudicialAndAdvogadosAndObjetosAcaoByCodigoResponse|bool
     */
    public function findAcaoJudicialAndAdvogadosAndObjetosAcaoByCodigo(\StructType\FindAcaoJudicialAndAdvogadosAndObjetosAcaoByCodigo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findAcaoJudicialAndAdvogadosAndObjetosAcaoByCodigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pesquisarServidorCpf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PesquisarServidorCpf $parameters
     * @return \StructType\PesquisarServidorCpfResponse|bool
     */
    public function pesquisarServidorCpf(\StructType\PesquisarServidorCpf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->pesquisarServidorCpf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listarServidorNome
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarServidorNome $parameters
     * @return \StructType\ListarServidorNomeResponse|bool
     */
    public function listarServidorNome(\StructType\ListarServidorNome $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->listarServidorNome($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pesquisarServidorMatricula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PesquisarServidorMatricula $parameters
     * @return \StructType\PesquisarServidorMatriculaResponse|bool
     */
    public function pesquisarServidorMatricula(\StructType\PesquisarServidorMatricula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->pesquisarServidorMatricula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named montarFichaFinanceiraServidor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MontarFichaFinanceiraServidor $parameters
     * @return \StructType\MontarFichaFinanceiraServidorResponse|bool
     */
    public function montarFichaFinanceiraServidor(\StructType\MontarFichaFinanceiraServidor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->montarFichaFinanceiraServidor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pesquisarBeneficiarioCpf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PesquisarBeneficiarioCpf $parameters
     * @return \StructType\PesquisarBeneficiarioCpfResponse|bool
     */
    public function pesquisarBeneficiarioCpf(\StructType\PesquisarBeneficiarioCpf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->pesquisarBeneficiarioCpf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listarBeneficiarioNome
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarBeneficiarioNome $parameters
     * @return \StructType\ListarBeneficiarioNomeResponse|bool
     */
    public function listarBeneficiarioNome(\StructType\ListarBeneficiarioNome $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->listarBeneficiarioNome($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pesquisarBeneficiarioMatricula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PesquisarBeneficiarioMatricula $parameters
     * @return \StructType\PesquisarBeneficiarioMatriculaResponse|bool
     */
    public function pesquisarBeneficiarioMatricula(\StructType\PesquisarBeneficiarioMatricula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->pesquisarBeneficiarioMatricula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named retornarBeneficiarioInstituidores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetornarBeneficiarioInstituidores $parameters
     * @return \StructType\RetornarBeneficiarioInstituidoresResponse|bool
     */
    public function retornarBeneficiarioInstituidores(\StructType\RetornarBeneficiarioInstituidores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->retornarBeneficiarioInstituidores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named montarFichaFinanceiraBeneficiario
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MontarFichaFinanceiraBeneficiario $parameters
     * @return \StructType\MontarFichaFinanceiraBeneficiarioResponse|bool
     */
    public function montarFichaFinanceiraBeneficiario(\StructType\MontarFichaFinanceiraBeneficiario $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->montarFichaFinanceiraBeneficiario($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFichaFinanceira
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFichaFinanceira $parameters
     * @return \StructType\GetFichaFinanceiraResponse|bool
     */
    public function getFichaFinanceira(\StructType\GetFichaFinanceira $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getFichaFinanceira($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findServidorByOrgaoAndIdentificacaoUnicaAndTipo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindServidorByOrgaoAndIdentificacaoUnicaAndTipo $parameters
     * @return \StructType\FindServidorByOrgaoAndIdentificacaoUnicaAndTipoResponse|bool
     */
    public function findServidorByOrgaoAndIdentificacaoUnicaAndTipo(\StructType\FindServidorByOrgaoAndIdentificacaoUnicaAndTipo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findServidorByOrgaoAndIdentificacaoUnicaAndTipo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findServidorByOrgaoAndMatriculaAndTipo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindServidorByOrgaoAndMatriculaAndTipo $parameters
     * @return \StructType\FindServidorByOrgaoAndMatriculaAndTipoResponse|bool
     */
    public function findServidorByOrgaoAndMatriculaAndTipo(\StructType\FindServidorByOrgaoAndMatriculaAndTipo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findServidorByOrgaoAndMatriculaAndTipo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findServidorByOrgaoAndNomeAndTipo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindServidorByOrgaoAndNomeAndTipo $parameters
     * @return \StructType\FindServidorByOrgaoAndNomeAndTipoResponse|bool
     */
    public function findServidorByOrgaoAndNomeAndTipo(\StructType\FindServidorByOrgaoAndNomeAndTipo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findServidorByOrgaoAndNomeAndTipo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findVinculoByIdentificacaoUnicaServidor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindVinculoByIdentificacaoUnicaServidor $parameters
     * @return \StructType\FindVinculoByIdentificacaoUnicaServidorResponse|bool
     */
    public function findVinculoByIdentificacaoUnicaServidor(\StructType\FindVinculoByIdentificacaoUnicaServidor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findVinculoByIdentificacaoUnicaServidor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findVinculoByOrgaoAndMatriculaInstituidor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindVinculoByOrgaoAndMatriculaInstituidor $parameters
     * @return \StructType\FindVinculoByOrgaoAndMatriculaInstituidorResponse|bool
     */
    public function findVinculoByOrgaoAndMatriculaInstituidor(\StructType\FindVinculoByOrgaoAndMatriculaInstituidor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findVinculoByOrgaoAndMatriculaInstituidor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * recuperarBeneficiadosDaAcaoPorIdUnica
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecuperarBeneficiadosDaAcaoPorIdUnica $parameters
     * @return \StructType\RecuperarBeneficiadosDaAcaoPorIdUnicaResponse|bool
     */
    public function recuperarBeneficiadosDaAcaoPorIdUnica(\StructType\RecuperarBeneficiadosDaAcaoPorIdUnica $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->recuperarBeneficiadosDaAcaoPorIdUnica($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * recuperarBeneficiadosDaAcaoPorMatricula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecuperarBeneficiadosDaAcaoPorMatricula $parameters
     * @return \StructType\RecuperarBeneficiadosDaAcaoPorMatriculaResponse|bool
     */
    public function recuperarBeneficiadosDaAcaoPorMatricula(\StructType\RecuperarBeneficiadosDaAcaoPorMatricula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->recuperarBeneficiadosDaAcaoPorMatricula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named recuperarBeneficiadosDaAcaoPorNome
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecuperarBeneficiadosDaAcaoPorNome $parameters
     * @return \StructType\RecuperarBeneficiadosDaAcaoPorNomeResponse|bool
     */
    public function recuperarBeneficiadosDaAcaoPorNome(\StructType\RecuperarBeneficiadosDaAcaoPorNome $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->recuperarBeneficiadosDaAcaoPorNome($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBeneficiarioInstituidores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBeneficiarioInstituidores $parameters
     * @return \StructType\GetBeneficiarioInstituidoresResponse|bool
     */
    public function getBeneficiarioInstituidores(\StructType\GetBeneficiarioInstituidores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBeneficiarioInstituidores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDataObitoBeneficiario
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataObitoBeneficiario $parameters
     * @return \StructType\GetDataObitoBeneficiarioResponse|bool
     */
    public function getDataObitoBeneficiario(\StructType\GetDataObitoBeneficiario $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDataObitoBeneficiario($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIncidenciaVinculosBeneficios
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIncidenciaVinculosBeneficios $parameters
     * @return \StructType\GetIncidenciaVinculosBeneficiosResponse|bool
     */
    public function getIncidenciaVinculosBeneficios(\StructType\GetIncidenciaVinculosBeneficios $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getIncidenciaVinculosBeneficios($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHistoricoBeneficio
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHistoricoBeneficio $parameters
     * @return \StructType\GetHistoricoBeneficioResponse|bool
     */
    public function getHistoricoBeneficio(\StructType\GetHistoricoBeneficio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHistoricoBeneficio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDataObitoServidor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataObitoServidor $parameters
     * @return \StructType\GetDataObitoServidorResponse|bool
     */
    public function getDataObitoServidor(\StructType\GetDataObitoServidor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDataObitoServidor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findBeneficiadoAndAcaoJudicialByNomeBeneficiado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoAndAcaoJudicialByNomeBeneficiado $parameters
     * @return \StructType\FindBeneficiadoAndAcaoJudicialByNomeBeneficiadoResponse|bool
     */
    public function findBeneficiadoAndAcaoJudicialByNomeBeneficiado(\StructType\FindBeneficiadoAndAcaoJudicialByNomeBeneficiado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoAndAcaoJudicialByNomeBeneficiado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findBeneficiadoAndBeneficiosByMatriculaAndCpf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoAndBeneficiosByMatriculaAndCpf $parameters
     * @return \StructType\FindBeneficiadoAndBeneficiosByMatriculaAndCpfResponse|bool
     */
    public function findBeneficiadoAndBeneficiosByMatriculaAndCpf(\StructType\FindBeneficiadoAndBeneficiosByMatriculaAndCpf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoAndBeneficiosByMatriculaAndCpf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findBeneficiadoAndServidorAndObjetoAcaoAndAcaoJudicialByIdentificacaoEAcao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoAndServidorAndObjetoAcaoAndAcaoJudicialByIdentificacaoEAcao $parameters
     * @return \StructType\FindBeneficiadoAndServidorAndObjetoAcaoAndAcaoJudicialByIdentificacaoEAcaoResponse|bool
     */
    public function findBeneficiadoAndServidorAndObjetoAcaoAndAcaoJudicialByIdentificacaoEAcao(\StructType\FindBeneficiadoAndServidorAndObjetoAcaoAndAcaoJudicialByIdentificacaoEAcao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoAndServidorAndObjetoAcaoAndAcaoJudicialByIdentificacaoEAcao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findBeneficiadoByCpf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoByCpf $parameters
     * @return \StructType\FindBeneficiadoByCpfResponse|bool
     */
    public function findBeneficiadoByCpf(\StructType\FindBeneficiadoByCpf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoByCpf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findBeneficiadoByMatricula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoByMatricula $parameters
     * @return \StructType\FindBeneficiadoByMatriculaResponse|bool
     */
    public function findBeneficiadoByMatricula(\StructType\FindBeneficiadoByMatricula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoByMatricula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findDadosFuncionaisByIdentificacaoUnicaAndOrgaoAndPeriodoAndAgrupamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindDadosFuncionaisByIdentificacaoUnicaAndOrgaoAndPeriodoAndAgrupamento $parameters
     * @return \StructType\FindDadosFuncionaisByIdentificacaoUnicaAndOrgaoAndPeriodoAndAgrupamentoResponse|bool
     */
    public function findDadosFuncionaisByIdentificacaoUnicaAndOrgaoAndPeriodoAndAgrupamento(\StructType\FindDadosFuncionaisByIdentificacaoUnicaAndOrgaoAndPeriodoAndAgrupamento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findDadosFuncionaisByIdentificacaoUnicaAndOrgaoAndPeriodoAndAgrupamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findInstituidorOrgaoByMatriculaBeneficiadoAndMesAnoPagamentoBeneficio
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindInstituidorOrgaoByMatriculaBeneficiadoAndMesAnoPagamentoBeneficio $parameters
     * @return \StructType\FindInstituidorOrgaoByMatriculaBeneficiadoAndMesAnoPagamentoBeneficioResponse|bool
     */
    public function findInstituidorOrgaoByMatriculaBeneficiadoAndMesAnoPagamentoBeneficio(\StructType\FindInstituidorOrgaoByMatriculaBeneficiadoAndMesAnoPagamentoBeneficio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findInstituidorOrgaoByMatriculaBeneficiadoAndMesAnoPagamentoBeneficio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findOrgaoByCodigoAcao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindOrgaoByCodigoAcao $parameters
     * @return \StructType\FindOrgaoByCodigoAcaoResponse|bool
     */
    public function findOrgaoByCodigoAcao(\StructType\FindOrgaoByCodigoAcao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findOrgaoByCodigoAcao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findOrgaoByCodigoAndSituacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindOrgaoByCodigoAndSituacao $parameters
     * @return \StructType\FindOrgaoByCodigoAndSituacaoResponse|bool
     */
    public function findOrgaoByCodigoAndSituacao(\StructType\FindOrgaoByCodigoAndSituacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findOrgaoByCodigoAndSituacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findOrgaoByNomeAndSituacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindOrgaoByNomeAndSituacao $parameters
     * @return \StructType\FindOrgaoByNomeAndSituacaoResponse|bool
     */
    public function findOrgaoByNomeAndSituacao(\StructType\FindOrgaoByNomeAndSituacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findOrgaoByNomeAndSituacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findOrgaoBySiglaAndSituacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindOrgaoBySiglaAndSituacao $parameters
     * @return \StructType\FindOrgaoBySiglaAndSituacaoResponse|bool
     */
    public function findOrgaoBySiglaAndSituacao(\StructType\FindOrgaoBySiglaAndSituacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findOrgaoBySiglaAndSituacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findServidorByOrgaoAndCpfAndTipo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindServidorByOrgaoAndCpfAndTipo $parameters
     * @return \StructType\FindServidorByOrgaoAndCpfAndTipoResponse|bool
     */
    public function findServidorByOrgaoAndCpfAndTipo(\StructType\FindServidorByOrgaoAndCpfAndTipo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findServidorByOrgaoAndCpfAndTipo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOcorrenciasServidor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOcorrenciasServidor $parameters
     * @return \StructType\GetOcorrenciasServidorResponse|bool
     */
    public function getOcorrenciasServidor(\StructType\GetOcorrenciasServidor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOcorrenciasServidor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHistoricoServidor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHistoricoServidor $parameters
     * @return \StructType\GetHistoricoServidorResponse|bool
     */
    public function getHistoricoServidor(\StructType\GetHistoricoServidor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHistoricoServidor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findAcaoJudicialAndBeneficiadoAndBeneficioAndObjetoAcaoAndServidorByCodigoAcaoAn
     * dSituacaoBeneficiado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindAcaoJudicialAndBeneficiadoAndBeneficioAndObjetoAcaoAndServidorByCodigoAcaoAndSituacaoBeneficiado $parameters
     * @return \StructType\FindAcaoJudicialAndBeneficiadoAndBeneficioAndObjetoAcaoAndServidorByCodigoAcaoAndSituacaoBeneficiadoResponse|bool
     */
    public function findAcaoJudicialAndBeneficiadoAndBeneficioAndObjetoAcaoAndServidorByCodigoAcaoAndSituacaoBeneficiado(\StructType\FindAcaoJudicialAndBeneficiadoAndBeneficioAndObjetoAcaoAndServidorByCodigoAcaoAndSituacaoBeneficiado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findAcaoJudicialAndBeneficiadoAndBeneficioAndObjetoAcaoAndServidorByCodigoAcaoAndSituacaoBeneficiado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findAcaoJudicialById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindAcaoJudicialById $parameters
     * @return \StructType\FindAcaoJudicialByIdResponse|bool
     */
    public function findAcaoJudicialById(\StructType\FindAcaoJudicialById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findAcaoJudicialById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findAgrupamentos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindAgrupamentos $parameters
     * @return \StructType\FindAgrupamentosResponse|bool
     */
    public function findAgrupamentos(\StructType\FindAgrupamentos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findAgrupamentos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findBeneficiadoAndAcaoJudicialByNomeAutor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoAndAcaoJudicialByNomeAutor $parameters
     * @return \StructType\FindBeneficiadoAndAcaoJudicialByNomeAutorResponse|bool
     */
    public function findBeneficiadoAndAcaoJudicialByNomeAutor(\StructType\FindBeneficiadoAndAcaoJudicialByNomeAutor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoAndAcaoJudicialByNomeAutor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named logon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Logon $parameters
     * @return \StructType\LogonResponse|bool
     */
    public function logon(\StructType\Logon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->logon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findBeneficiadoByMesAnoPagamentoEMatriculaEOrgao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoByMesAnoPagamentoEMatriculaEOrgao $parameters
     * @return \StructType\FindBeneficiadoByMesAnoPagamentoEMatriculaEOrgaoResponse|bool
     */
    public function findBeneficiadoByMesAnoPagamentoEMatriculaEOrgao(\StructType\FindBeneficiadoByMesAnoPagamentoEMatriculaEOrgao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoByMesAnoPagamentoEMatriculaEOrgao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findBeneficiadoByNome
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoByNome $parameters
     * @return \StructType\FindBeneficiadoByNomeResponse|bool
     */
    public function findBeneficiadoByNome(\StructType\FindBeneficiadoByNome $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoByNome($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findBeneficiadoByNomeEOrgao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoByNomeEOrgao $parameters
     * @return \StructType\FindBeneficiadoByNomeEOrgaoResponse|bool
     */
    public function findBeneficiadoByNomeEOrgao(\StructType\FindBeneficiadoByNomeEOrgao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoByNomeEOrgao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findBeneficiadoBySerproApsis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficiadoBySerproApsis $parameters
     * @return \StructType\FindBeneficiadoBySerproApsisResponse|bool
     */
    public function findBeneficiadoBySerproApsis(\StructType\FindBeneficiadoBySerproApsis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficiadoBySerproApsis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findBeneficioAndBeneficiadoAndServidorAndInstituidorAndOrgaoByCodigoOrgaoAndMatr
     * iculaBeneficiadoAndMesAnoBeneficio
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindBeneficioAndBeneficiadoAndServidorAndInstituidorAndOrgaoByCodigoOrgaoAndMatriculaBeneficiadoAndMesAnoBeneficio $parameters
     * @return \StructType\FindBeneficioAndBeneficiadoAndServidorAndInstituidorAndOrgaoByCodigoOrgaoAndMatriculaBeneficiadoAndMesAnoBeneficioResponse|bool
     */
    public function findBeneficioAndBeneficiadoAndServidorAndInstituidorAndOrgaoByCodigoOrgaoAndMatriculaBeneficiadoAndMesAnoBeneficio(\StructType\FindBeneficioAndBeneficiadoAndServidorAndInstituidorAndOrgaoByCodigoOrgaoAndMatriculaBeneficiadoAndMesAnoBeneficio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findBeneficioAndBeneficiadoAndServidorAndInstituidorAndOrgaoByCodigoOrgaoAndMatriculaBeneficiadoAndMesAnoBeneficio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findByMatricula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindByMatricula $parameters
     * @return \StructType\FindByMatriculaResponse|bool
     */
    public function findByMatricula(\StructType\FindByMatricula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findByMatricula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findByMesAnoAndOrgaoAndMatricula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindByMesAnoAndOrgaoAndMatricula $parameters
     * @return \StructType\FindByMesAnoAndOrgaoAndMatriculaResponse|bool
     */
    public function findByMesAnoAndOrgaoAndMatricula(\StructType\FindByMesAnoAndOrgaoAndMatricula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findByMesAnoAndOrgaoAndMatricula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findByOrgaoAndMatriculaInstituidor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindByOrgaoAndMatriculaInstituidor $parameters
     * @return \StructType\FindByOrgaoAndMatriculaInstituidorResponse|bool
     */
    public function findByOrgaoAndMatriculaInstituidor(\StructType\FindByOrgaoAndMatriculaInstituidor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findByOrgaoAndMatriculaInstituidor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FindAcaoJudicialAndAdvogadosAndObjetosAcaoByCodigoResponse|\StructType\FindAcaoJudicialAndBeneficiadoAndBeneficioAndObjetoAcaoAndServidorByCodigoAcaoAndSituacaoBeneficiadoResponse|\StructType\FindAcaoJudicialByIdResponse|\StructType\FindAgrupamentosResponse|\StructType\FindBeneficiadoAndAcaoJudicialByNomeAutorResponse|\StructType\FindBeneficiadoAndAcaoJudicialByNomeBeneficiadoResponse|\StructType\FindBeneficiadoAndBeneficiosByMatriculaAndCpfResponse|\StructType\FindBeneficiadoAndServidorAndObjetoAcaoAndAcaoJudicialByIdentificacaoEAcaoResponse|\StructType\FindBeneficiadoByCpfResponse|\StructType\FindBeneficiadoByMatriculaResponse|\StructType\FindBeneficiadoByMesAnoPagamentoEMatriculaEOrgaoResponse|\StructType\FindBeneficiadoByNomeEOrgaoResponse|\StructType\FindBeneficiadoByNomeResponse|\StructType\FindBeneficiadoBySerproApsisResponse|\StructType\FindBeneficioAndBeneficiadoAndServidorAndInstituidorAndOrgaoByCodigoOrgaoAndMatriculaBeneficiadoAndMesAnoBeneficioResponse|\StructType\FindByMatriculaResponse|\StructType\FindByMesAnoAndOrgaoAndMatriculaResponse|\StructType\FindByOrgaoAndMatriculaInstituidorResponse|\StructType\FindDadosFuncionaisByIdentificacaoUnicaAndOrgaoAndPeriodoAndAgrupamentoResponse|\StructType\FindInstituidorOrgaoByMatriculaBeneficiadoAndMesAnoPagamentoBeneficioResponse|\StructType\FindOrgaoByCodigoAcaoResponse|\StructType\FindOrgaoByCodigoAndSituacaoResponse|\StructType\FindOrgaoByNomeAndSituacaoResponse|\StructType\FindOrgaoBySiglaAndSituacaoResponse|\StructType\FindServidorByOrgaoAndCpfAndTipoResponse|\StructType\FindServidorByOrgaoAndIdentificacaoUnicaAndTipoResponse|\StructType\FindServidorByOrgaoAndMatriculaAndTipoResponse|\StructType\FindServidorByOrgaoAndNomeAndTipoResponse|\StructType\FindTransacaoByCpfResponse|\StructType\FindVinculoByIdentificacaoUnicaServidorResponse|\StructType\FindVinculoByOrgaoAndMatriculaInstituidorResponse|\StructType\GetBeneficiarioInstituidoresResponse|\StructType\GetDataObitoBeneficiarioResponse|\StructType\GetDataObitoServidorResponse|\StructType\GetFichaFinanceiraResponse|\StructType\GetHistoricoBeneficioResponse|\StructType\GetHistoricoServidorResponse|\StructType\GetIncidenciaVinculosBeneficiosResponse|\StructType\GetOcorrenciasServidorResponse|\StructType\ListarBeneficiarioNomeResponse|\StructType\ListarServidorNomeResponse|\StructType\LogonResponse|\StructType\MontarFichaFinanceiraBeneficiarioResponse|\StructType\MontarFichaFinanceiraServidorResponse|\StructType\PesquisarBeneficiarioCpfResponse|\StructType\PesquisarBeneficiarioMatriculaResponse|\StructType\PesquisarServidorCpfResponse|\StructType\PesquisarServidorMatriculaResponse|\StructType\RecuperarBeneficiadosDaAcaoPorIdUnicaResponse|\StructType\RecuperarBeneficiadosDaAcaoPorMatriculaResponse|\StructType\RecuperarBeneficiadosDaAcaoPorNomeResponse|\StructType\RetornarBeneficiarioInstituidoresResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
