<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vinculo StructType
 * @subpackage Structs
 */
class Vinculo extends BaseModel
{
    /**
     * The cargoEmprego
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoEmprego;
    /**
     * The dadosFuncionais
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DadosFuncionais
     */
    public $dadosFuncionais;
    /**
     * The dataOcupacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataOcupacao;
    /**
     * The funcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $funcao;
    /**
     * The jornada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $jornada;
    /**
     * The matricula
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $matricula;
    /**
     * The matriculaOrigem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $matriculaOrigem;
    /**
     * The orgao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Orgao
     */
    public $orgao;
    /**
     * The regimeJuridico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $regimeJuridico;
    /**
     * The situacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $situacao;
    /**
     * The upag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upag;
    /**
     * The servidor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Servidor
     */
    public $servidor;
    /**
     * The ocorrenciaExclusao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ocorrenciaExclusao;
    /**
     * The ocorrenciaAfastamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ocorrenciaAfastamento;
    /**
     * The codOrgao
     * @var int
     */
    public $codOrgao;
    /**
     * The nomeOrgao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nomeOrgao;
    /**
     * The codGrupoCargo
     * @var int
     */
    public $codGrupoCargo;
    /**
     * The codCargo
     * @var int
     */
    public $codCargo;
    /**
     * The classe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $classe;
    /**
     * The padrao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $padrao;
    /**
     * The siglaRegimeJuridico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $siglaRegimeJuridico;
    /**
     * The adicionalTempoServidor
     * @var int
     */
    public $adicionalTempoServidor;
    /**
     * The codigoFuncao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoFuncao;
    /**
     * The nivelFuncao
     * @var int
     */
    public $nivelFuncao;
    /**
     * The exercicioFuncao
     * @var int
     */
    public $exercicioFuncao;
    /**
     * The fichaFinanceira
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FichaFinanceira
     */
    public $fichaFinanceira;
    /**
     * Constructor method for Vinculo
     * @uses Vinculo::setCargoEmprego()
     * @uses Vinculo::setDadosFuncionais()
     * @uses Vinculo::setDataOcupacao()
     * @uses Vinculo::setFuncao()
     * @uses Vinculo::setJornada()
     * @uses Vinculo::setMatricula()
     * @uses Vinculo::setMatriculaOrigem()
     * @uses Vinculo::setOrgao()
     * @uses Vinculo::setRegimeJuridico()
     * @uses Vinculo::setSituacao()
     * @uses Vinculo::setUpag()
     * @uses Vinculo::setServidor()
     * @uses Vinculo::setOcorrenciaExclusao()
     * @uses Vinculo::setOcorrenciaAfastamento()
     * @uses Vinculo::setCodOrgao()
     * @uses Vinculo::setNomeOrgao()
     * @uses Vinculo::setCodGrupoCargo()
     * @uses Vinculo::setCodCargo()
     * @uses Vinculo::setClasse()
     * @uses Vinculo::setPadrao()
     * @uses Vinculo::setSiglaRegimeJuridico()
     * @uses Vinculo::setAdicionalTempoServidor()
     * @uses Vinculo::setCodigoFuncao()
     * @uses Vinculo::setNivelFuncao()
     * @uses Vinculo::setExercicioFuncao()
     * @uses Vinculo::setFichaFinanceira()
     * @param string $cargoEmprego
     * @param \StructType\DadosFuncionais $dadosFuncionais
     * @param string $dataOcupacao
     * @param string $funcao
     * @param int $jornada
     * @param int $matricula
     * @param int $matriculaOrigem
     * @param \StructType\Orgao $orgao
     * @param string $regimeJuridico
     * @param string $situacao
     * @param string $upag
     * @param \StructType\Servidor $servidor
     * @param int $ocorrenciaExclusao
     * @param int $ocorrenciaAfastamento
     * @param int $codOrgao
     * @param string $nomeOrgao
     * @param int $codGrupoCargo
     * @param int $codCargo
     * @param string $classe
     * @param string $padrao
     * @param string $siglaRegimeJuridico
     * @param int $adicionalTempoServidor
     * @param string $codigoFuncao
     * @param int $nivelFuncao
     * @param int $exercicioFuncao
     * @param \StructType\FichaFinanceira $fichaFinanceira
     */
    public function __construct($cargoEmprego = null, \StructType\DadosFuncionais $dadosFuncionais = null, $dataOcupacao = null, $funcao = null, $jornada = null, $matricula = null, $matriculaOrigem = null, \StructType\Orgao $orgao = null, $regimeJuridico = null, $situacao = null, $upag = null, \StructType\Servidor $servidor = null, $ocorrenciaExclusao = null, $ocorrenciaAfastamento = null, $codOrgao = null, $nomeOrgao = null, $codGrupoCargo = null, $codCargo = null, $classe = null, $padrao = null, $siglaRegimeJuridico = null, $adicionalTempoServidor = null, $codigoFuncao = null, $nivelFuncao = null, $exercicioFuncao = null, \StructType\FichaFinanceira $fichaFinanceira = null)
    {
        $this
            ->setCargoEmprego($cargoEmprego)
            ->setDadosFuncionais($dadosFuncionais)
            ->setDataOcupacao($dataOcupacao)
            ->setFuncao($funcao)
            ->setJornada($jornada)
            ->setMatricula($matricula)
            ->setMatriculaOrigem($matriculaOrigem)
            ->setOrgao($orgao)
            ->setRegimeJuridico($regimeJuridico)
            ->setSituacao($situacao)
            ->setUpag($upag)
            ->setServidor($servidor)
            ->setOcorrenciaExclusao($ocorrenciaExclusao)
            ->setOcorrenciaAfastamento($ocorrenciaAfastamento)
            ->setCodOrgao($codOrgao)
            ->setNomeOrgao($nomeOrgao)
            ->setCodGrupoCargo($codGrupoCargo)
            ->setCodCargo($codCargo)
            ->setClasse($classe)
            ->setPadrao($padrao)
            ->setSiglaRegimeJuridico($siglaRegimeJuridico)
            ->setAdicionalTempoServidor($adicionalTempoServidor)
            ->setCodigoFuncao($codigoFuncao)
            ->setNivelFuncao($nivelFuncao)
            ->setExercicioFuncao($exercicioFuncao)
            ->setFichaFinanceira($fichaFinanceira);
    }
    /**
     * Get cargoEmprego value
     * @return string|null
     */
    public function getCargoEmprego()
    {
        return $this->cargoEmprego;
    }
    /**
     * Set cargoEmprego value
     * @param string $cargoEmprego
     * @return \StructType\Vinculo
     */
    public function setCargoEmprego($cargoEmprego = null)
    {
        // validation for constraint: string
        if (!is_null($cargoEmprego) && !is_string($cargoEmprego)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoEmprego, true), gettype($cargoEmprego)), __LINE__);
        }
        $this->cargoEmprego = $cargoEmprego;
        return $this;
    }
    /**
     * Get dadosFuncionais value
     * @return \StructType\DadosFuncionais|null
     */
    public function getDadosFuncionais()
    {
        return $this->dadosFuncionais;
    }
    /**
     * Set dadosFuncionais value
     * @param \StructType\DadosFuncionais $dadosFuncionais
     * @return \StructType\Vinculo
     */
    public function setDadosFuncionais(\StructType\DadosFuncionais $dadosFuncionais = null)
    {
        $this->dadosFuncionais = $dadosFuncionais;
        return $this;
    }
    /**
     * Get dataOcupacao value
     * @return string|null
     */
    public function getDataOcupacao()
    {
        return $this->dataOcupacao;
    }
    /**
     * Set dataOcupacao value
     * @param string $dataOcupacao
     * @return \StructType\Vinculo
     */
    public function setDataOcupacao($dataOcupacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataOcupacao) && !is_string($dataOcupacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataOcupacao, true), gettype($dataOcupacao)), __LINE__);
        }
        $this->dataOcupacao = $dataOcupacao;
        return $this;
    }
    /**
     * Get funcao value
     * @return string|null
     */
    public function getFuncao()
    {
        return $this->funcao;
    }
    /**
     * Set funcao value
     * @param string $funcao
     * @return \StructType\Vinculo
     */
    public function setFuncao($funcao = null)
    {
        // validation for constraint: string
        if (!is_null($funcao) && !is_string($funcao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($funcao, true), gettype($funcao)), __LINE__);
        }
        $this->funcao = $funcao;
        return $this;
    }
    /**
     * Get jornada value
     * @return int|null
     */
    public function getJornada()
    {
        return $this->jornada;
    }
    /**
     * Set jornada value
     * @param int $jornada
     * @return \StructType\Vinculo
     */
    public function setJornada($jornada = null)
    {
        // validation for constraint: int
        if (!is_null($jornada) && !(is_int($jornada) || ctype_digit($jornada))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jornada, true), gettype($jornada)), __LINE__);
        }
        $this->jornada = $jornada;
        return $this;
    }
    /**
     * Get matricula value
     * @return int|null
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
    /**
     * Set matricula value
     * @param int $matricula
     * @return \StructType\Vinculo
     */
    public function setMatricula($matricula = null)
    {
        // validation for constraint: int
        if (!is_null($matricula) && !(is_int($matricula) || ctype_digit($matricula))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matricula, true), gettype($matricula)), __LINE__);
        }
        $this->matricula = $matricula;
        return $this;
    }
    /**
     * Get matriculaOrigem value
     * @return int|null
     */
    public function getMatriculaOrigem()
    {
        return $this->matriculaOrigem;
    }
    /**
     * Set matriculaOrigem value
     * @param int $matriculaOrigem
     * @return \StructType\Vinculo
     */
    public function setMatriculaOrigem($matriculaOrigem = null)
    {
        // validation for constraint: int
        if (!is_null($matriculaOrigem) && !(is_int($matriculaOrigem) || ctype_digit($matriculaOrigem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matriculaOrigem, true), gettype($matriculaOrigem)), __LINE__);
        }
        $this->matriculaOrigem = $matriculaOrigem;
        return $this;
    }
    /**
     * Get orgao value
     * @return \StructType\Orgao|null
     */
    public function getOrgao()
    {
        return $this->orgao;
    }
    /**
     * Set orgao value
     * @param \StructType\Orgao $orgao
     * @return \StructType\Vinculo
     */
    public function setOrgao(\StructType\Orgao $orgao = null)
    {
        $this->orgao = $orgao;
        return $this;
    }
    /**
     * Get regimeJuridico value
     * @return string|null
     */
    public function getRegimeJuridico()
    {
        return $this->regimeJuridico;
    }
    /**
     * Set regimeJuridico value
     * @param string $regimeJuridico
     * @return \StructType\Vinculo
     */
    public function setRegimeJuridico($regimeJuridico = null)
    {
        // validation for constraint: string
        if (!is_null($regimeJuridico) && !is_string($regimeJuridico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regimeJuridico, true), gettype($regimeJuridico)), __LINE__);
        }
        $this->regimeJuridico = $regimeJuridico;
        return $this;
    }
    /**
     * Get situacao value
     * @return string|null
     */
    public function getSituacao()
    {
        return $this->situacao;
    }
    /**
     * Set situacao value
     * @param string $situacao
     * @return \StructType\Vinculo
     */
    public function setSituacao($situacao = null)
    {
        // validation for constraint: string
        if (!is_null($situacao) && !is_string($situacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($situacao, true), gettype($situacao)), __LINE__);
        }
        $this->situacao = $situacao;
        return $this;
    }
    /**
     * Get upag value
     * @return string|null
     */
    public function getUpag()
    {
        return $this->upag;
    }
    /**
     * Set upag value
     * @param string $upag
     * @return \StructType\Vinculo
     */
    public function setUpag($upag = null)
    {
        // validation for constraint: string
        if (!is_null($upag) && !is_string($upag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upag, true), gettype($upag)), __LINE__);
        }
        $this->upag = $upag;
        return $this;
    }
    /**
     * Get servidor value
     * @return \StructType\Servidor|null
     */
    public function getServidor()
    {
        return $this->servidor;
    }
    /**
     * Set servidor value
     * @param \StructType\Servidor $servidor
     * @return \StructType\Vinculo
     */
    public function setServidor(\StructType\Servidor $servidor = null)
    {
        $this->servidor = $servidor;
        return $this;
    }
    /**
     * Get ocorrenciaExclusao value
     * @return int|null
     */
    public function getOcorrenciaExclusao()
    {
        return $this->ocorrenciaExclusao;
    }
    /**
     * Set ocorrenciaExclusao value
     * @param int $ocorrenciaExclusao
     * @return \StructType\Vinculo
     */
    public function setOcorrenciaExclusao($ocorrenciaExclusao = null)
    {
        // validation for constraint: int
        if (!is_null($ocorrenciaExclusao) && !(is_int($ocorrenciaExclusao) || ctype_digit($ocorrenciaExclusao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ocorrenciaExclusao, true), gettype($ocorrenciaExclusao)), __LINE__);
        }
        $this->ocorrenciaExclusao = $ocorrenciaExclusao;
        return $this;
    }
    /**
     * Get ocorrenciaAfastamento value
     * @return int|null
     */
    public function getOcorrenciaAfastamento()
    {
        return $this->ocorrenciaAfastamento;
    }
    /**
     * Set ocorrenciaAfastamento value
     * @param int $ocorrenciaAfastamento
     * @return \StructType\Vinculo
     */
    public function setOcorrenciaAfastamento($ocorrenciaAfastamento = null)
    {
        // validation for constraint: int
        if (!is_null($ocorrenciaAfastamento) && !(is_int($ocorrenciaAfastamento) || ctype_digit($ocorrenciaAfastamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ocorrenciaAfastamento, true), gettype($ocorrenciaAfastamento)), __LINE__);
        }
        $this->ocorrenciaAfastamento = $ocorrenciaAfastamento;
        return $this;
    }
    /**
     * Get codOrgao value
     * @return int|null
     */
    public function getCodOrgao()
    {
        return $this->codOrgao;
    }
    /**
     * Set codOrgao value
     * @param int $codOrgao
     * @return \StructType\Vinculo
     */
    public function setCodOrgao($codOrgao = null)
    {
        // validation for constraint: int
        if (!is_null($codOrgao) && !(is_int($codOrgao) || ctype_digit($codOrgao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codOrgao, true), gettype($codOrgao)), __LINE__);
        }
        $this->codOrgao = $codOrgao;
        return $this;
    }
    /**
     * Get nomeOrgao value
     * @return string|null
     */
    public function getNomeOrgao()
    {
        return $this->nomeOrgao;
    }
    /**
     * Set nomeOrgao value
     * @param string $nomeOrgao
     * @return \StructType\Vinculo
     */
    public function setNomeOrgao($nomeOrgao = null)
    {
        // validation for constraint: string
        if (!is_null($nomeOrgao) && !is_string($nomeOrgao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeOrgao, true), gettype($nomeOrgao)), __LINE__);
        }
        $this->nomeOrgao = $nomeOrgao;
        return $this;
    }
    /**
     * Get codGrupoCargo value
     * @return int|null
     */
    public function getCodGrupoCargo()
    {
        return $this->codGrupoCargo;
    }
    /**
     * Set codGrupoCargo value
     * @param int $codGrupoCargo
     * @return \StructType\Vinculo
     */
    public function setCodGrupoCargo($codGrupoCargo = null)
    {
        // validation for constraint: int
        if (!is_null($codGrupoCargo) && !(is_int($codGrupoCargo) || ctype_digit($codGrupoCargo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codGrupoCargo, true), gettype($codGrupoCargo)), __LINE__);
        }
        $this->codGrupoCargo = $codGrupoCargo;
        return $this;
    }
    /**
     * Get codCargo value
     * @return int|null
     */
    public function getCodCargo()
    {
        return $this->codCargo;
    }
    /**
     * Set codCargo value
     * @param int $codCargo
     * @return \StructType\Vinculo
     */
    public function setCodCargo($codCargo = null)
    {
        // validation for constraint: int
        if (!is_null($codCargo) && !(is_int($codCargo) || ctype_digit($codCargo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codCargo, true), gettype($codCargo)), __LINE__);
        }
        $this->codCargo = $codCargo;
        return $this;
    }
    /**
     * Get classe value
     * @return string|null
     */
    public function getClasse()
    {
        return $this->classe;
    }
    /**
     * Set classe value
     * @param string $classe
     * @return \StructType\Vinculo
     */
    public function setClasse($classe = null)
    {
        // validation for constraint: string
        if (!is_null($classe) && !is_string($classe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classe, true), gettype($classe)), __LINE__);
        }
        $this->classe = $classe;
        return $this;
    }
    /**
     * Get padrao value
     * @return string|null
     */
    public function getPadrao()
    {
        return $this->padrao;
    }
    /**
     * Set padrao value
     * @param string $padrao
     * @return \StructType\Vinculo
     */
    public function setPadrao($padrao = null)
    {
        // validation for constraint: string
        if (!is_null($padrao) && !is_string($padrao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($padrao, true), gettype($padrao)), __LINE__);
        }
        $this->padrao = $padrao;
        return $this;
    }
    /**
     * Get siglaRegimeJuridico value
     * @return string|null
     */
    public function getSiglaRegimeJuridico()
    {
        return $this->siglaRegimeJuridico;
    }
    /**
     * Set siglaRegimeJuridico value
     * @param string $siglaRegimeJuridico
     * @return \StructType\Vinculo
     */
    public function setSiglaRegimeJuridico($siglaRegimeJuridico = null)
    {
        // validation for constraint: string
        if (!is_null($siglaRegimeJuridico) && !is_string($siglaRegimeJuridico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siglaRegimeJuridico, true), gettype($siglaRegimeJuridico)), __LINE__);
        }
        $this->siglaRegimeJuridico = $siglaRegimeJuridico;
        return $this;
    }
    /**
     * Get adicionalTempoServidor value
     * @return int|null
     */
    public function getAdicionalTempoServidor()
    {
        return $this->adicionalTempoServidor;
    }
    /**
     * Set adicionalTempoServidor value
     * @param int $adicionalTempoServidor
     * @return \StructType\Vinculo
     */
    public function setAdicionalTempoServidor($adicionalTempoServidor = null)
    {
        // validation for constraint: int
        if (!is_null($adicionalTempoServidor) && !(is_int($adicionalTempoServidor) || ctype_digit($adicionalTempoServidor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adicionalTempoServidor, true), gettype($adicionalTempoServidor)), __LINE__);
        }
        $this->adicionalTempoServidor = $adicionalTempoServidor;
        return $this;
    }
    /**
     * Get codigoFuncao value
     * @return string|null
     */
    public function getCodigoFuncao()
    {
        return $this->codigoFuncao;
    }
    /**
     * Set codigoFuncao value
     * @param string $codigoFuncao
     * @return \StructType\Vinculo
     */
    public function setCodigoFuncao($codigoFuncao = null)
    {
        // validation for constraint: string
        if (!is_null($codigoFuncao) && !is_string($codigoFuncao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoFuncao, true), gettype($codigoFuncao)), __LINE__);
        }
        $this->codigoFuncao = $codigoFuncao;
        return $this;
    }
    /**
     * Get nivelFuncao value
     * @return int|null
     */
    public function getNivelFuncao()
    {
        return $this->nivelFuncao;
    }
    /**
     * Set nivelFuncao value
     * @param int $nivelFuncao
     * @return \StructType\Vinculo
     */
    public function setNivelFuncao($nivelFuncao = null)
    {
        // validation for constraint: int
        if (!is_null($nivelFuncao) && !(is_int($nivelFuncao) || ctype_digit($nivelFuncao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nivelFuncao, true), gettype($nivelFuncao)), __LINE__);
        }
        $this->nivelFuncao = $nivelFuncao;
        return $this;
    }
    /**
     * Get exercicioFuncao value
     * @return int|null
     */
    public function getExercicioFuncao()
    {
        return $this->exercicioFuncao;
    }
    /**
     * Set exercicioFuncao value
     * @param int $exercicioFuncao
     * @return \StructType\Vinculo
     */
    public function setExercicioFuncao($exercicioFuncao = null)
    {
        // validation for constraint: int
        if (!is_null($exercicioFuncao) && !(is_int($exercicioFuncao) || ctype_digit($exercicioFuncao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exercicioFuncao, true), gettype($exercicioFuncao)), __LINE__);
        }
        $this->exercicioFuncao = $exercicioFuncao;
        return $this;
    }
    /**
     * Get fichaFinanceira value
     * @return \StructType\FichaFinanceira|null
     */
    public function getFichaFinanceira()
    {
        return $this->fichaFinanceira;
    }
    /**
     * Set fichaFinanceira value
     * @param \StructType\FichaFinanceira $fichaFinanceira
     * @return \StructType\Vinculo
     */
    public function setFichaFinanceira(\StructType\FichaFinanceira $fichaFinanceira = null)
    {
        $this->fichaFinanceira = $fichaFinanceira;
        return $this;
    }
}
