<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Beneficiario StructType
 * @subpackage Structs
 */
class Beneficiario extends PessoaSiape
{
    /**
     * The matricula
     * @var int
     */
    public $matricula;
    /**
     * The beneficios
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Beneficios
     */
    public $beneficios;
    /**
     * Constructor method for Beneficiario
     * @uses Beneficiario::setMatricula()
     * @uses Beneficiario::setBeneficios()
     * @param int $matricula
     * @param \StructType\Beneficios $beneficios
     */
    public function __construct($matricula = null, \StructType\Beneficios $beneficios = null)
    {
        $this
            ->setMatricula($matricula)
            ->setBeneficios($beneficios);
    }
    /**
     * Get matricula value
     * @return int|null
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
    /**
     * Set matricula value
     * @param int $matricula
     * @return \StructType\Beneficiario
     */
    public function setMatricula($matricula = null)
    {
        // validation for constraint: int
        if (!is_null($matricula) && !(is_int($matricula) || ctype_digit($matricula))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matricula, true), gettype($matricula)), __LINE__);
        }
        $this->matricula = $matricula;
        return $this;
    }
    /**
     * Get beneficios value
     * @return \StructType\Beneficios|null
     */
    public function getBeneficios()
    {
        return $this->beneficios;
    }
    /**
     * Set beneficios value
     * @param \StructType\Beneficios $beneficios
     * @return \StructType\Beneficiario
     */
    public function setBeneficios(\StructType\Beneficios $beneficios = null)
    {
        $this->beneficios = $beneficios;
        return $this;
    }
}
