<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Situacao StructType
 * @subpackage Structs
 */
class Situacao extends AbstractStructBase
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $codigo;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nome;
    /**
     * Constructor method for Situacao
     * @uses Situacao::setCodigo()
     * @uses Situacao::setNome()
     * @param int $codigo
     * @param string $nome
     */
    public function __construct($codigo = null, $nome = null)
    {
        $this
            ->setCodigo($codigo)
            ->setNome($nome);
    }
    /**
     * Get codigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodigo()
    {
        return isset($this->codigo) ? $this->codigo : null;
    }
    /**
     * Set codigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codigo
     * @return \StructType\Situacao
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        if (is_null($codigo) || (is_array($codigo) && empty($codigo))) {
            unset($this->codigo);
        } else {
            $this->codigo = $codigo;
        }
        return $this;
    }
    /**
     * Get nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->nome) ? $this->nome : null;
    }
    /**
     * Set nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \StructType\Situacao
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->nome);
        } else {
            $this->nome = $nome;
        }
        return $this;
    }
}
