<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SQLException StructType
 * @subpackage Structs
 */
class SQLException extends AbstractStructBase
{
    /**
     * The SQLState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SQLState;
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $errorCode;
    /**
     * The nextException
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SQLException
     */
    public $nextException;
    /**
     * Constructor method for SQLException
     * @uses SQLException::setSQLState()
     * @uses SQLException::setErrorCode()
     * @uses SQLException::setNextException()
     * @param string $sQLState
     * @param int $errorCode
     * @param \StructType\SQLException $nextException
     */
    public function __construct($sQLState = null, $errorCode = null, \StructType\SQLException $nextException = null)
    {
        $this
            ->setSQLState($sQLState)
            ->setErrorCode($errorCode)
            ->setNextException($nextException);
    }
    /**
     * Get SQLState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSQLState()
    {
        return isset($this->SQLState) ? $this->SQLState : null;
    }
    /**
     * Set SQLState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sQLState
     * @return \StructType\SQLException
     */
    public function setSQLState($sQLState = null)
    {
        // validation for constraint: string
        if (!is_null($sQLState) && !is_string($sQLState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sQLState, true), gettype($sQLState)), __LINE__);
        }
        if (is_null($sQLState) || (is_array($sQLState) && empty($sQLState))) {
            unset($this->SQLState);
        } else {
            $this->SQLState = $sQLState;
        }
        return $this;
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\SQLException
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get nextException value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SQLException|null
     */
    public function getNextException()
    {
        return isset($this->nextException) ? $this->nextException : null;
    }
    /**
     * Set nextException value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SQLException $nextException
     * @return \StructType\SQLException
     */
    public function setNextException(\StructType\SQLException $nextException = null)
    {
        if (is_null($nextException) || (is_array($nextException) && empty($nextException))) {
            unset($this->nextException);
        } else {
            $this->nextException = $nextException;
        }
        return $this;
    }
}
