<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadosSICAJ StructType
 * @subpackage Structs
 */
class DadosSICAJ extends AbstractStructBase
{
    /**
     * The codAcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codAcao;
    /**
     * The codOrgao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codOrgao;
    /**
     * The dataAjuizamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dataAjuizamento;
    /**
     * The dataTransitoJulgamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dataTransitoJulgamento;
    /**
     * The indicadorExclusao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $indicadorExclusao;
    /**
     * The indicadorSituacaoAcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $indicadorSituacaoAcao;
    /**
     * The matricula
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $matricula;
    /**
     * The numAcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numAcao;
    /**
     * The statusAcaoSICAJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $statusAcaoSICAJ;
    /**
     * The statusAcaoTabela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $statusAcaoTabela;
    /**
     * The ufAcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ufAcao;
    /**
     * The valorBeneficiarioAcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $valorBeneficiarioAcao;
    /**
     * Constructor method for DadosSICAJ
     * @uses DadosSICAJ::setCodAcao()
     * @uses DadosSICAJ::setCodOrgao()
     * @uses DadosSICAJ::setDataAjuizamento()
     * @uses DadosSICAJ::setDataTransitoJulgamento()
     * @uses DadosSICAJ::setIndicadorExclusao()
     * @uses DadosSICAJ::setIndicadorSituacaoAcao()
     * @uses DadosSICAJ::setMatricula()
     * @uses DadosSICAJ::setNumAcao()
     * @uses DadosSICAJ::setStatusAcaoSICAJ()
     * @uses DadosSICAJ::setStatusAcaoTabela()
     * @uses DadosSICAJ::setUfAcao()
     * @uses DadosSICAJ::setValorBeneficiarioAcao()
     * @param string $codAcao
     * @param string $codOrgao
     * @param string $dataAjuizamento
     * @param string $dataTransitoJulgamento
     * @param string $indicadorExclusao
     * @param string $indicadorSituacaoAcao
     * @param string $matricula
     * @param string $numAcao
     * @param string $statusAcaoSICAJ
     * @param string $statusAcaoTabela
     * @param string $ufAcao
     * @param string $valorBeneficiarioAcao
     */
    public function __construct($codAcao = null, $codOrgao = null, $dataAjuizamento = null, $dataTransitoJulgamento = null, $indicadorExclusao = null, $indicadorSituacaoAcao = null, $matricula = null, $numAcao = null, $statusAcaoSICAJ = null, $statusAcaoTabela = null, $ufAcao = null, $valorBeneficiarioAcao = null)
    {
        $this
            ->setCodAcao($codAcao)
            ->setCodOrgao($codOrgao)
            ->setDataAjuizamento($dataAjuizamento)
            ->setDataTransitoJulgamento($dataTransitoJulgamento)
            ->setIndicadorExclusao($indicadorExclusao)
            ->setIndicadorSituacaoAcao($indicadorSituacaoAcao)
            ->setMatricula($matricula)
            ->setNumAcao($numAcao)
            ->setStatusAcaoSICAJ($statusAcaoSICAJ)
            ->setStatusAcaoTabela($statusAcaoTabela)
            ->setUfAcao($ufAcao)
            ->setValorBeneficiarioAcao($valorBeneficiarioAcao);
    }
    /**
     * Get codAcao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodAcao()
    {
        return isset($this->codAcao) ? $this->codAcao : null;
    }
    /**
     * Set codAcao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codAcao
     * @return \StructType\DadosSICAJ
     */
    public function setCodAcao($codAcao = null)
    {
        // validation for constraint: string
        if (!is_null($codAcao) && !is_string($codAcao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codAcao, true), gettype($codAcao)), __LINE__);
        }
        if (is_null($codAcao) || (is_array($codAcao) && empty($codAcao))) {
            unset($this->codAcao);
        } else {
            $this->codAcao = $codAcao;
        }
        return $this;
    }
    /**
     * Get codOrgao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodOrgao()
    {
        return isset($this->codOrgao) ? $this->codOrgao : null;
    }
    /**
     * Set codOrgao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codOrgao
     * @return \StructType\DadosSICAJ
     */
    public function setCodOrgao($codOrgao = null)
    {
        // validation for constraint: string
        if (!is_null($codOrgao) && !is_string($codOrgao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codOrgao, true), gettype($codOrgao)), __LINE__);
        }
        if (is_null($codOrgao) || (is_array($codOrgao) && empty($codOrgao))) {
            unset($this->codOrgao);
        } else {
            $this->codOrgao = $codOrgao;
        }
        return $this;
    }
    /**
     * Get dataAjuizamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataAjuizamento()
    {
        return isset($this->dataAjuizamento) ? $this->dataAjuizamento : null;
    }
    /**
     * Set dataAjuizamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataAjuizamento
     * @return \StructType\DadosSICAJ
     */
    public function setDataAjuizamento($dataAjuizamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataAjuizamento) && !is_string($dataAjuizamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAjuizamento, true), gettype($dataAjuizamento)), __LINE__);
        }
        if (is_null($dataAjuizamento) || (is_array($dataAjuizamento) && empty($dataAjuizamento))) {
            unset($this->dataAjuizamento);
        } else {
            $this->dataAjuizamento = $dataAjuizamento;
        }
        return $this;
    }
    /**
     * Get dataTransitoJulgamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataTransitoJulgamento()
    {
        return isset($this->dataTransitoJulgamento) ? $this->dataTransitoJulgamento : null;
    }
    /**
     * Set dataTransitoJulgamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataTransitoJulgamento
     * @return \StructType\DadosSICAJ
     */
    public function setDataTransitoJulgamento($dataTransitoJulgamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataTransitoJulgamento) && !is_string($dataTransitoJulgamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTransitoJulgamento, true), gettype($dataTransitoJulgamento)), __LINE__);
        }
        if (is_null($dataTransitoJulgamento) || (is_array($dataTransitoJulgamento) && empty($dataTransitoJulgamento))) {
            unset($this->dataTransitoJulgamento);
        } else {
            $this->dataTransitoJulgamento = $dataTransitoJulgamento;
        }
        return $this;
    }
    /**
     * Get indicadorExclusao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndicadorExclusao()
    {
        return isset($this->indicadorExclusao) ? $this->indicadorExclusao : null;
    }
    /**
     * Set indicadorExclusao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indicadorExclusao
     * @return \StructType\DadosSICAJ
     */
    public function setIndicadorExclusao($indicadorExclusao = null)
    {
        // validation for constraint: string
        if (!is_null($indicadorExclusao) && !is_string($indicadorExclusao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicadorExclusao, true), gettype($indicadorExclusao)), __LINE__);
        }
        if (is_null($indicadorExclusao) || (is_array($indicadorExclusao) && empty($indicadorExclusao))) {
            unset($this->indicadorExclusao);
        } else {
            $this->indicadorExclusao = $indicadorExclusao;
        }
        return $this;
    }
    /**
     * Get indicadorSituacaoAcao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndicadorSituacaoAcao()
    {
        return isset($this->indicadorSituacaoAcao) ? $this->indicadorSituacaoAcao : null;
    }
    /**
     * Set indicadorSituacaoAcao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indicadorSituacaoAcao
     * @return \StructType\DadosSICAJ
     */
    public function setIndicadorSituacaoAcao($indicadorSituacaoAcao = null)
    {
        // validation for constraint: string
        if (!is_null($indicadorSituacaoAcao) && !is_string($indicadorSituacaoAcao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicadorSituacaoAcao, true), gettype($indicadorSituacaoAcao)), __LINE__);
        }
        if (is_null($indicadorSituacaoAcao) || (is_array($indicadorSituacaoAcao) && empty($indicadorSituacaoAcao))) {
            unset($this->indicadorSituacaoAcao);
        } else {
            $this->indicadorSituacaoAcao = $indicadorSituacaoAcao;
        }
        return $this;
    }
    /**
     * Get matricula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatricula()
    {
        return isset($this->matricula) ? $this->matricula : null;
    }
    /**
     * Set matricula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matricula
     * @return \StructType\DadosSICAJ
     */
    public function setMatricula($matricula = null)
    {
        // validation for constraint: string
        if (!is_null($matricula) && !is_string($matricula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matricula, true), gettype($matricula)), __LINE__);
        }
        if (is_null($matricula) || (is_array($matricula) && empty($matricula))) {
            unset($this->matricula);
        } else {
            $this->matricula = $matricula;
        }
        return $this;
    }
    /**
     * Get numAcao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumAcao()
    {
        return isset($this->numAcao) ? $this->numAcao : null;
    }
    /**
     * Set numAcao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numAcao
     * @return \StructType\DadosSICAJ
     */
    public function setNumAcao($numAcao = null)
    {
        // validation for constraint: string
        if (!is_null($numAcao) && !is_string($numAcao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numAcao, true), gettype($numAcao)), __LINE__);
        }
        if (is_null($numAcao) || (is_array($numAcao) && empty($numAcao))) {
            unset($this->numAcao);
        } else {
            $this->numAcao = $numAcao;
        }
        return $this;
    }
    /**
     * Get statusAcaoSICAJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusAcaoSICAJ()
    {
        return isset($this->statusAcaoSICAJ) ? $this->statusAcaoSICAJ : null;
    }
    /**
     * Set statusAcaoSICAJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusAcaoSICAJ
     * @return \StructType\DadosSICAJ
     */
    public function setStatusAcaoSICAJ($statusAcaoSICAJ = null)
    {
        // validation for constraint: string
        if (!is_null($statusAcaoSICAJ) && !is_string($statusAcaoSICAJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusAcaoSICAJ, true), gettype($statusAcaoSICAJ)), __LINE__);
        }
        if (is_null($statusAcaoSICAJ) || (is_array($statusAcaoSICAJ) && empty($statusAcaoSICAJ))) {
            unset($this->statusAcaoSICAJ);
        } else {
            $this->statusAcaoSICAJ = $statusAcaoSICAJ;
        }
        return $this;
    }
    /**
     * Get statusAcaoTabela value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusAcaoTabela()
    {
        return isset($this->statusAcaoTabela) ? $this->statusAcaoTabela : null;
    }
    /**
     * Set statusAcaoTabela value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusAcaoTabela
     * @return \StructType\DadosSICAJ
     */
    public function setStatusAcaoTabela($statusAcaoTabela = null)
    {
        // validation for constraint: string
        if (!is_null($statusAcaoTabela) && !is_string($statusAcaoTabela)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusAcaoTabela, true), gettype($statusAcaoTabela)), __LINE__);
        }
        if (is_null($statusAcaoTabela) || (is_array($statusAcaoTabela) && empty($statusAcaoTabela))) {
            unset($this->statusAcaoTabela);
        } else {
            $this->statusAcaoTabela = $statusAcaoTabela;
        }
        return $this;
    }
    /**
     * Get ufAcao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUfAcao()
    {
        return isset($this->ufAcao) ? $this->ufAcao : null;
    }
    /**
     * Set ufAcao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ufAcao
     * @return \StructType\DadosSICAJ
     */
    public function setUfAcao($ufAcao = null)
    {
        // validation for constraint: string
        if (!is_null($ufAcao) && !is_string($ufAcao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ufAcao, true), gettype($ufAcao)), __LINE__);
        }
        if (is_null($ufAcao) || (is_array($ufAcao) && empty($ufAcao))) {
            unset($this->ufAcao);
        } else {
            $this->ufAcao = $ufAcao;
        }
        return $this;
    }
    /**
     * Get valorBeneficiarioAcao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValorBeneficiarioAcao()
    {
        return isset($this->valorBeneficiarioAcao) ? $this->valorBeneficiarioAcao : null;
    }
    /**
     * Set valorBeneficiarioAcao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valorBeneficiarioAcao
     * @return \StructType\DadosSICAJ
     */
    public function setValorBeneficiarioAcao($valorBeneficiarioAcao = null)
    {
        // validation for constraint: string
        if (!is_null($valorBeneficiarioAcao) && !is_string($valorBeneficiarioAcao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valorBeneficiarioAcao, true), gettype($valorBeneficiarioAcao)), __LINE__);
        }
        if (is_null($valorBeneficiarioAcao) || (is_array($valorBeneficiarioAcao) && empty($valorBeneficiarioAcao))) {
            unset($this->valorBeneficiarioAcao);
        } else {
            $this->valorBeneficiarioAcao = $valorBeneficiarioAcao;
        }
        return $this;
    }
}
