<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUorg ArrayType
 * @subpackage Arrays
 */
class ArrayOfUorg extends AbstractStructArrayBase
{
    /**
     * The Uorg
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Uorg[]
     */
    public $Uorg;
    /**
     * Constructor method for ArrayOfUorg
     * @uses ArrayOfUorg::setUorg()
     * @param \StructType\Uorg[] $uorg
     */
    public function __construct(array $uorg = array())
    {
        $this
            ->setUorg($uorg);
    }
    /**
     * Get Uorg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Uorg[]|null
     */
    public function getUorg()
    {
        return isset($this->Uorg) ? $this->Uorg : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUorg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUorg method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUorgForArrayConstraintsFromSetUorg(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfUorgUorgItem) {
            // validation for constraint: itemType
            if (!$arrayOfUorgUorgItem instanceof \StructType\Uorg) {
                $invalidValues[] = is_object($arrayOfUorgUorgItem) ? get_class($arrayOfUorgUorgItem) : sprintf('%s(%s)', gettype($arrayOfUorgUorgItem), var_export($arrayOfUorgUorgItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Uorg property can only contain items of type \StructType\Uorg, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Uorg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Uorg[] $uorg
     * @return \ArrayType\ArrayOfUorg
     */
    public function setUorg(array $uorg = array())
    {
        // validation for constraint: array
        if ('' !== ($uorgArrayErrorMessage = self::validateUorgForArrayConstraintsFromSetUorg($uorg))) {
            throw new \InvalidArgumentException($uorgArrayErrorMessage, __LINE__);
        }
        if (is_null($uorg) || (is_array($uorg) && empty($uorg))) {
            unset($this->Uorg);
        } else {
            $this->Uorg = $uorg;
        }
        return $this;
    }
    /**
     * Add item to Uorg value
     * @throws \InvalidArgumentException
     * @param \StructType\Uorg $item
     * @return \ArrayType\ArrayOfUorg
     */
    public function addToUorg(\StructType\Uorg $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Uorg) {
            throw new \InvalidArgumentException(sprintf('The Uorg property can only contain items of type \StructType\Uorg, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Uorg[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Uorg|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Uorg|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Uorg|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Uorg|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Uorg|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Uorg
     */
    public function getAttributeName()
    {
        return 'Uorg';
    }
}
