<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadosDDP StructType
 * @subpackage Structs
 */
class DadosDDP extends AbstractStructBase
{
    /**
     * The categoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $categoria;
    /**
     * The classificacaoContabil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $classificacaoContabil;
    /**
     * The competencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $competencia;
    /**
     * The descricaoRubrica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $descricaoRubrica;
    /**
     * The nivel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nivel;
    /**
     * The rubrica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $rubrica;
    /**
     * The valorRubrica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $valorRubrica;
    /**
     * Constructor method for DadosDDP
     * @uses DadosDDP::setCategoria()
     * @uses DadosDDP::setClassificacaoContabil()
     * @uses DadosDDP::setCompetencia()
     * @uses DadosDDP::setDescricaoRubrica()
     * @uses DadosDDP::setNivel()
     * @uses DadosDDP::setRubrica()
     * @uses DadosDDP::setValorRubrica()
     * @param string $categoria
     * @param string $classificacaoContabil
     * @param string $competencia
     * @param string $descricaoRubrica
     * @param string $nivel
     * @param string $rubrica
     * @param string $valorRubrica
     */
    public function __construct($categoria = null, $classificacaoContabil = null, $competencia = null, $descricaoRubrica = null, $nivel = null, $rubrica = null, $valorRubrica = null)
    {
        $this
            ->setCategoria($categoria)
            ->setClassificacaoContabil($classificacaoContabil)
            ->setCompetencia($competencia)
            ->setDescricaoRubrica($descricaoRubrica)
            ->setNivel($nivel)
            ->setRubrica($rubrica)
            ->setValorRubrica($valorRubrica);
    }
    /**
     * Get categoria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoria()
    {
        return isset($this->categoria) ? $this->categoria : null;
    }
    /**
     * Set categoria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoria
     * @return \StructType\DadosDDP
     */
    public function setCategoria($categoria = null)
    {
        // validation for constraint: string
        if (!is_null($categoria) && !is_string($categoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoria, true), gettype($categoria)), __LINE__);
        }
        if (is_null($categoria) || (is_array($categoria) && empty($categoria))) {
            unset($this->categoria);
        } else {
            $this->categoria = $categoria;
        }
        return $this;
    }
    /**
     * Get classificacaoContabil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClassificacaoContabil()
    {
        return isset($this->classificacaoContabil) ? $this->classificacaoContabil : null;
    }
    /**
     * Set classificacaoContabil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classificacaoContabil
     * @return \StructType\DadosDDP
     */
    public function setClassificacaoContabil($classificacaoContabil = null)
    {
        // validation for constraint: string
        if (!is_null($classificacaoContabil) && !is_string($classificacaoContabil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classificacaoContabil, true), gettype($classificacaoContabil)), __LINE__);
        }
        if (is_null($classificacaoContabil) || (is_array($classificacaoContabil) && empty($classificacaoContabil))) {
            unset($this->classificacaoContabil);
        } else {
            $this->classificacaoContabil = $classificacaoContabil;
        }
        return $this;
    }
    /**
     * Get competencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompetencia()
    {
        return isset($this->competencia) ? $this->competencia : null;
    }
    /**
     * Set competencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $competencia
     * @return \StructType\DadosDDP
     */
    public function setCompetencia($competencia = null)
    {
        // validation for constraint: string
        if (!is_null($competencia) && !is_string($competencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($competencia, true), gettype($competencia)), __LINE__);
        }
        if (is_null($competencia) || (is_array($competencia) && empty($competencia))) {
            unset($this->competencia);
        } else {
            $this->competencia = $competencia;
        }
        return $this;
    }
    /**
     * Get descricaoRubrica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricaoRubrica()
    {
        return isset($this->descricaoRubrica) ? $this->descricaoRubrica : null;
    }
    /**
     * Set descricaoRubrica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricaoRubrica
     * @return \StructType\DadosDDP
     */
    public function setDescricaoRubrica($descricaoRubrica = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoRubrica) && !is_string($descricaoRubrica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoRubrica, true), gettype($descricaoRubrica)), __LINE__);
        }
        if (is_null($descricaoRubrica) || (is_array($descricaoRubrica) && empty($descricaoRubrica))) {
            unset($this->descricaoRubrica);
        } else {
            $this->descricaoRubrica = $descricaoRubrica;
        }
        return $this;
    }
    /**
     * Get nivel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNivel()
    {
        return isset($this->nivel) ? $this->nivel : null;
    }
    /**
     * Set nivel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nivel
     * @return \StructType\DadosDDP
     */
    public function setNivel($nivel = null)
    {
        // validation for constraint: string
        if (!is_null($nivel) && !is_string($nivel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nivel, true), gettype($nivel)), __LINE__);
        }
        if (is_null($nivel) || (is_array($nivel) && empty($nivel))) {
            unset($this->nivel);
        } else {
            $this->nivel = $nivel;
        }
        return $this;
    }
    /**
     * Get rubrica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRubrica()
    {
        return isset($this->rubrica) ? $this->rubrica : null;
    }
    /**
     * Set rubrica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rubrica
     * @return \StructType\DadosDDP
     */
    public function setRubrica($rubrica = null)
    {
        // validation for constraint: string
        if (!is_null($rubrica) && !is_string($rubrica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rubrica, true), gettype($rubrica)), __LINE__);
        }
        if (is_null($rubrica) || (is_array($rubrica) && empty($rubrica))) {
            unset($this->rubrica);
        } else {
            $this->rubrica = $rubrica;
        }
        return $this;
    }
    /**
     * Get valorRubrica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValorRubrica()
    {
        return isset($this->valorRubrica) ? $this->valorRubrica : null;
    }
    /**
     * Set valorRubrica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valorRubrica
     * @return \StructType\DadosDDP
     */
    public function setValorRubrica($valorRubrica = null)
    {
        // validation for constraint: string
        if (!is_null($valorRubrica) && !is_string($valorRubrica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valorRubrica, true), gettype($valorRubrica)), __LINE__);
        }
        if (is_null($valorRubrica) || (is_array($valorRubrica) && empty($valorRubrica))) {
            unset($this->valorRubrica);
        } else {
            $this->valorRubrica = $valorRubrica;
        }
        return $this;
    }
}
