<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrayDadosFinanceiros StructType
 * @subpackage Structs
 */
class ArrayDadosFinanceiros extends AbstractStructBase
{
    /**
     * The codigoOrgao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $codigoOrgao;
    /**
     * The dadosFinanceiros
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDadosFinanceiros
     */
    public $dadosFinanceiros;
    /**
     * The matricula
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $matricula;
    /**
     * The mesAnoPagamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mesAnoPagamento;
    /**
     * Constructor method for ArrayDadosFinanceiros
     * @uses ArrayDadosFinanceiros::setCodigoOrgao()
     * @uses ArrayDadosFinanceiros::setDadosFinanceiros()
     * @uses ArrayDadosFinanceiros::setMatricula()
     * @uses ArrayDadosFinanceiros::setMesAnoPagamento()
     * @param int $codigoOrgao
     * @param \ArrayType\ArrayOfDadosFinanceiros $dadosFinanceiros
     * @param int $matricula
     * @param string $mesAnoPagamento
     */
    public function __construct($codigoOrgao = null, \ArrayType\ArrayOfDadosFinanceiros $dadosFinanceiros = null, $matricula = null, $mesAnoPagamento = null)
    {
        $this
            ->setCodigoOrgao($codigoOrgao)
            ->setDadosFinanceiros($dadosFinanceiros)
            ->setMatricula($matricula)
            ->setMesAnoPagamento($mesAnoPagamento);
    }
    /**
     * Get codigoOrgao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodigoOrgao()
    {
        return isset($this->codigoOrgao) ? $this->codigoOrgao : null;
    }
    /**
     * Set codigoOrgao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codigoOrgao
     * @return \StructType\ArrayDadosFinanceiros
     */
    public function setCodigoOrgao($codigoOrgao = null)
    {
        // validation for constraint: int
        if (!is_null($codigoOrgao) && !(is_int($codigoOrgao) || ctype_digit($codigoOrgao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoOrgao, true), gettype($codigoOrgao)), __LINE__);
        }
        if (is_null($codigoOrgao) || (is_array($codigoOrgao) && empty($codigoOrgao))) {
            unset($this->codigoOrgao);
        } else {
            $this->codigoOrgao = $codigoOrgao;
        }
        return $this;
    }
    /**
     * Get dadosFinanceiros value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDadosFinanceiros|null
     */
    public function getDadosFinanceiros()
    {
        return isset($this->dadosFinanceiros) ? $this->dadosFinanceiros : null;
    }
    /**
     * Set dadosFinanceiros value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDadosFinanceiros $dadosFinanceiros
     * @return \StructType\ArrayDadosFinanceiros
     */
    public function setDadosFinanceiros(\ArrayType\ArrayOfDadosFinanceiros $dadosFinanceiros = null)
    {
        if (is_null($dadosFinanceiros) || (is_array($dadosFinanceiros) && empty($dadosFinanceiros))) {
            unset($this->dadosFinanceiros);
        } else {
            $this->dadosFinanceiros = $dadosFinanceiros;
        }
        return $this;
    }
    /**
     * Get matricula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMatricula()
    {
        return isset($this->matricula) ? $this->matricula : null;
    }
    /**
     * Set matricula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $matricula
     * @return \StructType\ArrayDadosFinanceiros
     */
    public function setMatricula($matricula = null)
    {
        // validation for constraint: int
        if (!is_null($matricula) && !(is_int($matricula) || ctype_digit($matricula))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matricula, true), gettype($matricula)), __LINE__);
        }
        if (is_null($matricula) || (is_array($matricula) && empty($matricula))) {
            unset($this->matricula);
        } else {
            $this->matricula = $matricula;
        }
        return $this;
    }
    /**
     * Get mesAnoPagamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMesAnoPagamento()
    {
        return isset($this->mesAnoPagamento) ? $this->mesAnoPagamento : null;
    }
    /**
     * Set mesAnoPagamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mesAnoPagamento
     * @return \StructType\ArrayDadosFinanceiros
     */
    public function setMesAnoPagamento($mesAnoPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($mesAnoPagamento) && !is_string($mesAnoPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mesAnoPagamento, true), gettype($mesAnoPagamento)), __LINE__);
        }
        if (is_null($mesAnoPagamento) || (is_array($mesAnoPagamento) && empty($mesAnoPagamento))) {
            unset($this->mesAnoPagamento);
        } else {
            $this->mesAnoPagamento = $mesAnoPagamento;
        }
        return $this;
    }
}
