<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named consultaDadosFinanceiros
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \StructType\ArrayDadosFinanceiros|bool
     */
    public function consultaDadosFinanceiros($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosFinanceiros($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosSICAJ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayDadosSICAJ|bool
     */
    public function consultaDadosSICAJ($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosSICAJ($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPensionista
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $cpfPensionista
     * @param string $cpf
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @return \StructType\Pensionista|bool
     */
    public function getPensionista($cpfPensionista, $cpf, $siglaSistema, $nomeSistema, $senha)
    {
        try {
            $this->setResult($this->getSoapClient()->getPensionista($cpfPensionista, $cpf, $siglaSistema, $nomeSistema, $senha));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosEnderecoResidencial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \StructType\DadosEnderecoResidencial|bool
     */
    public function consultaDadosEnderecoResidencial($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosEnderecoResidencial($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosAfastamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \StructType\ArrayDadosAfastamento|bool
     */
    public function consultaDadosAfastamento($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosAfastamento($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosCurriculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \StructType\DadosCurriculo|bool
     */
    public function consultaDadosCurriculo($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosCurriculo($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listaContribuicoesPSS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $codOrgao
     * @param string $matricula
     * @param string $codOrgaoTCU
     * @param string $cpf
     * @param string $anoInicial
     * @param string $anoFinal
     * @return \ArrayType\ArrayOfArrayContribuicoesPSS|bool
     */
    public function listaContribuicoesPSS($siglaSistema, $nomeSistema, $senha, $codOrgao, $matricula, $codOrgaoTCU, $cpf, $anoInicial, $anoFinal)
    {
        try {
            $this->setResult($this->getSoapClient()->listaContribuicoesPSS($siglaSistema, $nomeSistema, $senha, $codOrgao, $matricula, $codOrgaoTCU, $cpf, $anoInicial, $anoFinal));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaTotalizadorVagasOrgao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @return \StructType\TotalVagasOrgao|bool
     */
    public function consultaTotalizadorVagasOrgao($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaTotalizadorVagasOrgao($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listaUpags
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $codUpag
     * @return \ArrayType\ArrayOfUpag|bool
     */
    public function listaUpags($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $codUpag)
    {
        try {
            $this->setResult($this->getSoapClient()->listaUpags($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $codUpag));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dadosUorg
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $codUorg
     * @return \StructType\UorgDados|bool
     */
    public function dadosUorg($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $codUorg)
    {
        try {
            $this->setResult($this->getSoapClient()->dadosUorg($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $codUorg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosPessoais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \StructType\DadosPessoais|bool
     */
    public function consultaDadosPessoais($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosPessoais($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosFinanceirosHistorico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @param string $anoInicial
     * @param string $anoFinal
     * @return \ArrayType\ArrayOfArrayDadosFinanceiros|bool
     */
    public function consultaDadosFinanceirosHistorico($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo, $anoInicial, $anoFinal)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosFinanceirosHistorico($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo, $anoInicial, $anoFinal));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosDDP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $anoMes
     * @param string $codOrgao
     * @param string $nivelSituacaoFuncional
     * @param string $codigoFolhaDDP
     * @param string $tipoConsulta
     * @param string $classificacaoContabil
     * @return \ArrayType\ArrayDadosDDP|bool
     */
    public function consultaDadosDDP($siglaSistema, $nomeSistema, $senha, $cpf, $anoMes, $codOrgao, $nivelSituacaoFuncional, $codigoFolhaDDP, $tipoConsulta, $classificacaoContabil)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosDDP($siglaSistema, $nomeSistema, $senha, $cpf, $anoMes, $codOrgao, $nivelSituacaoFuncional, $codigoFolhaDDP, $tipoConsulta, $classificacaoContabil));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosDocumentacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \StructType\DadosDocumentacao|bool
     */
    public function consultaDadosDocumentacao($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosDocumentacao($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listaServidores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $codUorg
     * @return \ArrayType\ArrayOfServidor|bool
     */
    public function listaServidores($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $codUorg)
    {
        try {
            $this->setResult($this->getSoapClient()->listaServidores($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $codUorg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosFuncionais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayDadosFuncionais|bool
     */
    public function consultaDadosFuncionais($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosFuncionais($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listaInformacoesAposentadoria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $orgao
     * @param string $matricula
     * @return \ArrayType\ArrayOfInformacoesAposentadoria|bool
     */
    public function listaInformacoesAposentadoria($siglaSistema, $nomeSistema, $senha, $cpf, $orgao, $matricula)
    {
        try {
            $this->setResult($this->getSoapClient()->listaInformacoesAposentadoria($siglaSistema, $nomeSistema, $senha, $cpf, $orgao, $matricula));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosEscolares
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \StructType\DadosEscolares|bool
     */
    public function consultaDadosEscolares($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosEscolares($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosBancarios
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayDadosBancarios|bool
     */
    public function consultaDadosBancarios($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosBancarios($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosRepresentanteLegal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayDadosRepresentanteLegal|bool
     */
    public function consultaDadosRepresentanteLegal($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosRepresentanteLegal($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listaServidoresAutorizacaoIRPF
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $data
     * @return \ArrayType\ArrayOfServidorIndicadorAutorizacaoIRPF|bool
     */
    public function listaServidoresAutorizacaoIRPF($siglaSistema, $nomeSistema, $senha, $data)
    {
        try {
            $this->setResult($this->getSoapClient()->listaServidoresAutorizacaoIRPF($siglaSistema, $nomeSistema, $senha, $data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosUorg
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayDadosUorg|bool
     */
    public function consultaDadosUorg($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosUorg($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named verificaVinculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayDadosVinculo|bool
     */
    public function verificaVinculo($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->verificaVinculo($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosDependentes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayDadosDependentes|bool
     */
    public function consultaDadosDependentes($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosDependentes($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosPA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayDadosPA|bool
     */
    public function consultaDadosPA($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosPA($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listaUorgs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $codUorg
     * @return \ArrayType\ArrayOfUorg|bool
     */
    public function listaUorgs($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $codUorg)
    {
        try {
            $this->setResult($this->getSoapClient()->listaUorgs($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $codUorg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaDadosAfastamentoHistorico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @param string $anoInicial
     * @param string $mesInicial
     * @param string $anoFinal
     * @param string $mesFinal
     * @return \ArrayType\ArrayOfArrayDadosAfastamento|bool
     */
    public function consultaDadosAfastamentoHistorico($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo, $anoInicial, $mesInicial, $anoFinal, $mesFinal)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaDadosAfastamentoHistorico($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo, $anoInicial, $mesInicial, $anoFinal, $mesFinal));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named verificaVinculoEmpresas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayVinculo|bool
     */
    public function verificaVinculoEmpresas($siglaSistema, $nomeSistema, $senha, $cpf, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->verificaVinculoEmpresas($siglaSistema, $nomeSistema, $senha, $cpf, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaPensaoRecebida
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayPensaoRecebida|bool
     */
    public function consultaPensaoRecebida($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaPensaoRecebida($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterVersao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @return string|bool
     */
    public function obterVersao($siglaSistema)
    {
        try {
            $this->setResult($this->getSoapClient()->obterVersao($siglaSistema));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaHistoricoPCA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codigoOrgao
     * @return \ArrayType\ArrayOfCargoPca|bool
     */
    public function consultaHistoricoPCA($siglaSistema, $nomeSistema, $senha, $cpf, $codigoOrgao)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaHistoricoPCA($siglaSistema, $nomeSistema, $senha, $cpf, $codigoOrgao));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultaPensoesInstituidas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $siglaSistema
     * @param string $nomeSistema
     * @param string $senha
     * @param string $cpf
     * @param string $codOrgao
     * @param string $parmExistPag
     * @param string $parmTipoVinculo
     * @return \ArrayType\ArrayPensoesInstituidas|bool
     */
    public function consultaPensoesInstituidas($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo)
    {
        try {
            $this->setResult($this->getSoapClient()->consultaPensoesInstituidas($siglaSistema, $nomeSistema, $senha, $cpf, $codOrgao, $parmExistPag, $parmTipoVinculo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\ArrayType\ArrayDadosBancarios|\ArrayType\ArrayDadosDDP|\ArrayType\ArrayDadosDependentes|\ArrayType\ArrayDadosFuncionais|\ArrayType\ArrayDadosPA|\ArrayType\ArrayDadosRepresentanteLegal|\ArrayType\ArrayDadosSICAJ|\ArrayType\ArrayDadosUorg|\ArrayType\ArrayDadosVinculo|\ArrayType\ArrayOfArrayContribuicoesPSS|\ArrayType\ArrayOfArrayDadosAfastamento|\ArrayType\ArrayOfArrayDadosFinanceiros|\ArrayType\ArrayOfCargoPca|\ArrayType\ArrayOfInformacoesAposentadoria|\ArrayType\ArrayOfServidor|\ArrayType\ArrayOfServidorIndicadorAutorizacaoIRPF|\ArrayType\ArrayOfUorg|\ArrayType\ArrayOfUpag|\ArrayType\ArrayPensaoRecebida|\ArrayType\ArrayPensoesInstituidas|\ArrayType\ArrayVinculo|\StructType\ArrayDadosAfastamento|\StructType\ArrayDadosFinanceiros|\StructType\DadosCurriculo|\StructType\DadosDocumentacao|\StructType\DadosEnderecoResidencial|\StructType\DadosEscolares|\StructType\DadosPessoais|\StructType\Pensionista|\StructType\TotalVagasOrgao|\StructType\UorgDados
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
