<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVinculo ArrayType
 * @subpackage Arrays
 */
class ArrayOfVinculo extends AbstractStructArrayBase
{
    /**
     * The Vinculo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Vinculo[]
     */
    public $Vinculo;
    /**
     * Constructor method for ArrayOfVinculo
     * @uses ArrayOfVinculo::setVinculo()
     * @param \StructType\Vinculo[] $vinculo
     */
    public function __construct(array $vinculo = array())
    {
        $this
            ->setVinculo($vinculo);
    }
    /**
     * Get Vinculo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Vinculo[]|null
     */
    public function getVinculo()
    {
        return isset($this->Vinculo) ? $this->Vinculo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVinculo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVinculo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVinculoForArrayConstraintsFromSetVinculo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfVinculoVinculoItem) {
            // validation for constraint: itemType
            if (!$arrayOfVinculoVinculoItem instanceof \StructType\Vinculo) {
                $invalidValues[] = is_object($arrayOfVinculoVinculoItem) ? get_class($arrayOfVinculoVinculoItem) : sprintf('%s(%s)', gettype($arrayOfVinculoVinculoItem), var_export($arrayOfVinculoVinculoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vinculo property can only contain items of type \StructType\Vinculo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vinculo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Vinculo[] $vinculo
     * @return \ArrayType\ArrayOfVinculo
     */
    public function setVinculo(array $vinculo = array())
    {
        // validation for constraint: array
        if ('' !== ($vinculoArrayErrorMessage = self::validateVinculoForArrayConstraintsFromSetVinculo($vinculo))) {
            throw new \InvalidArgumentException($vinculoArrayErrorMessage, __LINE__);
        }
        if (is_null($vinculo) || (is_array($vinculo) && empty($vinculo))) {
            unset($this->Vinculo);
        } else {
            $this->Vinculo = $vinculo;
        }
        return $this;
    }
    /**
     * Add item to Vinculo value
     * @throws \InvalidArgumentException
     * @param \StructType\Vinculo $item
     * @return \ArrayType\ArrayOfVinculo
     */
    public function addToVinculo(\StructType\Vinculo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Vinculo) {
            throw new \InvalidArgumentException(sprintf('The Vinculo property can only contain items of type \StructType\Vinculo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vinculo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Vinculo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Vinculo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Vinculo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Vinculo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Vinculo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Vinculo
     */
    public function getAttributeName()
    {
        return 'Vinculo';
    }
}
