<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUpag ArrayType
 * @subpackage Arrays
 */
class ArrayOfUpag extends AbstractStructArrayBase
{
    /**
     * The Upag
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Upag[]
     */
    public $Upag;
    /**
     * Constructor method for ArrayOfUpag
     * @uses ArrayOfUpag::setUpag()
     * @param \StructType\Upag[] $upag
     */
    public function __construct(array $upag = array())
    {
        $this
            ->setUpag($upag);
    }
    /**
     * Get Upag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Upag[]|null
     */
    public function getUpag()
    {
        return isset($this->Upag) ? $this->Upag : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUpag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUpag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUpagForArrayConstraintsFromSetUpag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfUpagUpagItem) {
            // validation for constraint: itemType
            if (!$arrayOfUpagUpagItem instanceof \StructType\Upag) {
                $invalidValues[] = is_object($arrayOfUpagUpagItem) ? get_class($arrayOfUpagUpagItem) : sprintf('%s(%s)', gettype($arrayOfUpagUpagItem), var_export($arrayOfUpagUpagItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Upag property can only contain items of type \StructType\Upag, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Upag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Upag[] $upag
     * @return \ArrayType\ArrayOfUpag
     */
    public function setUpag(array $upag = array())
    {
        // validation for constraint: array
        if ('' !== ($upagArrayErrorMessage = self::validateUpagForArrayConstraintsFromSetUpag($upag))) {
            throw new \InvalidArgumentException($upagArrayErrorMessage, __LINE__);
        }
        if (is_null($upag) || (is_array($upag) && empty($upag))) {
            unset($this->Upag);
        } else {
            $this->Upag = $upag;
        }
        return $this;
    }
    /**
     * Add item to Upag value
     * @throws \InvalidArgumentException
     * @param \StructType\Upag $item
     * @return \ArrayType\ArrayOfUpag
     */
    public function addToUpag(\StructType\Upag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Upag) {
            throw new \InvalidArgumentException(sprintf('The Upag property can only contain items of type \StructType\Upag, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Upag[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Upag|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Upag|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Upag|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Upag|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Upag|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Upag
     */
    public function getAttributeName()
    {
        return 'Upag';
    }
}
