<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServidor ArrayType
 * @subpackage Arrays
 */
class ArrayOfServidor extends AbstractStructArrayBase
{
    /**
     * The Servidor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Servidor[]
     */
    public $Servidor;
    /**
     * Constructor method for ArrayOfServidor
     * @uses ArrayOfServidor::setServidor()
     * @param \StructType\Servidor[] $servidor
     */
    public function __construct(array $servidor = array())
    {
        $this
            ->setServidor($servidor);
    }
    /**
     * Get Servidor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Servidor[]|null
     */
    public function getServidor()
    {
        return isset($this->Servidor) ? $this->Servidor : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServidor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServidor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServidorForArrayConstraintsFromSetServidor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfServidorServidorItem) {
            // validation for constraint: itemType
            if (!$arrayOfServidorServidorItem instanceof \StructType\Servidor) {
                $invalidValues[] = is_object($arrayOfServidorServidorItem) ? get_class($arrayOfServidorServidorItem) : sprintf('%s(%s)', gettype($arrayOfServidorServidorItem), var_export($arrayOfServidorServidorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Servidor property can only contain items of type \StructType\Servidor, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Servidor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Servidor[] $servidor
     * @return \ArrayType\ArrayOfServidor
     */
    public function setServidor(array $servidor = array())
    {
        // validation for constraint: array
        if ('' !== ($servidorArrayErrorMessage = self::validateServidorForArrayConstraintsFromSetServidor($servidor))) {
            throw new \InvalidArgumentException($servidorArrayErrorMessage, __LINE__);
        }
        if (is_null($servidor) || (is_array($servidor) && empty($servidor))) {
            unset($this->Servidor);
        } else {
            $this->Servidor = $servidor;
        }
        return $this;
    }
    /**
     * Add item to Servidor value
     * @throws \InvalidArgumentException
     * @param \StructType\Servidor $item
     * @return \ArrayType\ArrayOfServidor
     */
    public function addToServidor(\StructType\Servidor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Servidor) {
            throw new \InvalidArgumentException(sprintf('The Servidor property can only contain items of type \StructType\Servidor, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Servidor[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Servidor|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Servidor|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Servidor|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Servidor|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Servidor|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Servidor
     */
    public function getAttributeName()
    {
        return 'Servidor';
    }
}
