<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayVinculo ArrayType
 * @subpackage Arrays
 */
class ArrayVinculo extends AbstractStructArrayBase
{
    /**
     * The dadosVinculos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfVinculo
     */
    public $dadosVinculos;
    /**
     * Constructor method for ArrayVinculo
     * @uses ArrayVinculo::setDadosVinculos()
     * @param \ArrayType\ArrayOfVinculo $dadosVinculos
     */
    public function __construct(\ArrayType\ArrayOfVinculo $dadosVinculos = null)
    {
        $this
            ->setDadosVinculos($dadosVinculos);
    }
    /**
     * Get dadosVinculos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfVinculo|null
     */
    public function getDadosVinculos()
    {
        return isset($this->dadosVinculos) ? $this->dadosVinculos : null;
    }
    /**
     * Set dadosVinculos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfVinculo $dadosVinculos
     * @return \ArrayType\ArrayVinculo
     */
    public function setDadosVinculos(\ArrayType\ArrayOfVinculo $dadosVinculos = null)
    {
        if (is_null($dadosVinculos) || (is_array($dadosVinculos) && empty($dadosVinculos))) {
            unset($this->dadosVinculos);
        } else {
            $this->dadosVinculos = $dadosVinculos;
        }
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ArrayType\ArrayOfVinculo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ArrayType\ArrayOfVinculo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ArrayType\ArrayOfVinculo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ArrayType\ArrayOfVinculo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ArrayType\ArrayOfVinculo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string dadosVinculos
     */
    public function getAttributeName()
    {
        return 'dadosVinculos';
    }
}
