<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCursos ArrayType
 * @subpackage Arrays
 */
class ArrayOfCursos extends AbstractStructArrayBase
{
    /**
     * The Cursos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Cursos[]
     */
    public $Cursos;
    /**
     * Constructor method for ArrayOfCursos
     * @uses ArrayOfCursos::setCursos()
     * @param \StructType\Cursos[] $cursos
     */
    public function __construct(array $cursos = array())
    {
        $this
            ->setCursos($cursos);
    }
    /**
     * Get Cursos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Cursos[]|null
     */
    public function getCursos()
    {
        return isset($this->Cursos) ? $this->Cursos : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCursos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCursos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCursosForArrayConstraintsFromSetCursos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCursosCursosItem) {
            // validation for constraint: itemType
            if (!$arrayOfCursosCursosItem instanceof \StructType\Cursos) {
                $invalidValues[] = is_object($arrayOfCursosCursosItem) ? get_class($arrayOfCursosCursosItem) : sprintf('%s(%s)', gettype($arrayOfCursosCursosItem), var_export($arrayOfCursosCursosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cursos property can only contain items of type \StructType\Cursos, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cursos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Cursos[] $cursos
     * @return \ArrayType\ArrayOfCursos
     */
    public function setCursos(array $cursos = array())
    {
        // validation for constraint: array
        if ('' !== ($cursosArrayErrorMessage = self::validateCursosForArrayConstraintsFromSetCursos($cursos))) {
            throw new \InvalidArgumentException($cursosArrayErrorMessage, __LINE__);
        }
        if (is_null($cursos) || (is_array($cursos) && empty($cursos))) {
            unset($this->Cursos);
        } else {
            $this->Cursos = $cursos;
        }
        return $this;
    }
    /**
     * Add item to Cursos value
     * @throws \InvalidArgumentException
     * @param \StructType\Cursos $item
     * @return \ArrayType\ArrayOfCursos
     */
    public function addToCursos(\StructType\Cursos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cursos) {
            throw new \InvalidArgumentException(sprintf('The Cursos property can only contain items of type \StructType\Cursos, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cursos[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Cursos|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Cursos|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Cursos|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Cursos|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Cursos|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Cursos
     */
    public function getAttributeName()
    {
        return 'Cursos';
    }
}
