<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdiomas ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdiomas extends AbstractStructArrayBase
{
    /**
     * The Idiomas
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Idiomas[]
     */
    public $Idiomas;
    /**
     * Constructor method for ArrayOfIdiomas
     * @uses ArrayOfIdiomas::setIdiomas()
     * @param \StructType\Idiomas[] $idiomas
     */
    public function __construct(array $idiomas = array())
    {
        $this
            ->setIdiomas($idiomas);
    }
    /**
     * Get Idiomas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Idiomas[]|null
     */
    public function getIdiomas()
    {
        return isset($this->Idiomas) ? $this->Idiomas : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdiomas method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdiomas method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdiomasForArrayConstraintsFromSetIdiomas(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfIdiomasIdiomasItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdiomasIdiomasItem instanceof \StructType\Idiomas) {
                $invalidValues[] = is_object($arrayOfIdiomasIdiomasItem) ? get_class($arrayOfIdiomasIdiomasItem) : sprintf('%s(%s)', gettype($arrayOfIdiomasIdiomasItem), var_export($arrayOfIdiomasIdiomasItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Idiomas property can only contain items of type \StructType\Idiomas, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Idiomas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Idiomas[] $idiomas
     * @return \ArrayType\ArrayOfIdiomas
     */
    public function setIdiomas(array $idiomas = array())
    {
        // validation for constraint: array
        if ('' !== ($idiomasArrayErrorMessage = self::validateIdiomasForArrayConstraintsFromSetIdiomas($idiomas))) {
            throw new \InvalidArgumentException($idiomasArrayErrorMessage, __LINE__);
        }
        if (is_null($idiomas) || (is_array($idiomas) && empty($idiomas))) {
            unset($this->Idiomas);
        } else {
            $this->Idiomas = $idiomas;
        }
        return $this;
    }
    /**
     * Add item to Idiomas value
     * @throws \InvalidArgumentException
     * @param \StructType\Idiomas $item
     * @return \ArrayType\ArrayOfIdiomas
     */
    public function addToIdiomas(\StructType\Idiomas $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Idiomas) {
            throw new \InvalidArgumentException(sprintf('The Idiomas property can only contain items of type \StructType\Idiomas, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Idiomas[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Idiomas|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Idiomas|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Idiomas|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Idiomas|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Idiomas|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Idiomas
     */
    public function getAttributeName()
    {
        return 'Idiomas';
    }
}
