<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBeneficio ArrayType
 * @subpackage Arrays
 */
class ArrayOfBeneficio extends AbstractStructArrayBase
{
    /**
     * The Beneficio
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Beneficio[]
     */
    public $Beneficio;
    /**
     * Constructor method for ArrayOfBeneficio
     * @uses ArrayOfBeneficio::setBeneficio()
     * @param \StructType\Beneficio[] $beneficio
     */
    public function __construct(array $beneficio = array())
    {
        $this
            ->setBeneficio($beneficio);
    }
    /**
     * Get Beneficio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Beneficio[]|null
     */
    public function getBeneficio()
    {
        return isset($this->Beneficio) ? $this->Beneficio : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBeneficio method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeneficio method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeneficioForArrayConstraintsFromSetBeneficio(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBeneficioBeneficioItem) {
            // validation for constraint: itemType
            if (!$arrayOfBeneficioBeneficioItem instanceof \StructType\Beneficio) {
                $invalidValues[] = is_object($arrayOfBeneficioBeneficioItem) ? get_class($arrayOfBeneficioBeneficioItem) : sprintf('%s(%s)', gettype($arrayOfBeneficioBeneficioItem), var_export($arrayOfBeneficioBeneficioItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Beneficio property can only contain items of type \StructType\Beneficio, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Beneficio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Beneficio[] $beneficio
     * @return \ArrayType\ArrayOfBeneficio
     */
    public function setBeneficio(array $beneficio = array())
    {
        // validation for constraint: array
        if ('' !== ($beneficioArrayErrorMessage = self::validateBeneficioForArrayConstraintsFromSetBeneficio($beneficio))) {
            throw new \InvalidArgumentException($beneficioArrayErrorMessage, __LINE__);
        }
        if (is_null($beneficio) || (is_array($beneficio) && empty($beneficio))) {
            unset($this->Beneficio);
        } else {
            $this->Beneficio = $beneficio;
        }
        return $this;
    }
    /**
     * Add item to Beneficio value
     * @throws \InvalidArgumentException
     * @param \StructType\Beneficio $item
     * @return \ArrayType\ArrayOfBeneficio
     */
    public function addToBeneficio(\StructType\Beneficio $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Beneficio) {
            throw new \InvalidArgumentException(sprintf('The Beneficio property can only contain items of type \StructType\Beneficio, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Beneficio[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Beneficio|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Beneficio|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Beneficio|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Beneficio|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Beneficio|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Beneficio
     */
    public function getAttributeName()
    {
        return 'Beneficio';
    }
}
