<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderInfoHeader StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderInfoHeader
 * @subpackage Structs
 */
class OrderInfoHeader extends AbstractStructBase
{
    /**
     * The AccountAddressId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountAddressId;
    /**
     * The AccountContractId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountContractId;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountId;
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ApplicationId;
    /**
     * The ApplicationVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The AuditCreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditCreateDate;
    /**
     * The AuditCreateUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreateUnitId;
    /**
     * The AuditCreatedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreatedBy;
    /**
     * The AuditDeleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditDeleted;
    /**
     * The AuditModifiedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifiedBy;
    /**
     * The AuditModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditModifyDate;
    /**
     * The AuditModifyUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifyUnitId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsPiecedAccepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsPiecedAccepted;
    /**
     * The IsVolumeAccepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsVolumeAccepted;
    /**
     * The LovPayorTypeOrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LovPayorTypeOrderId;
    /**
     * Constructor method for OrderInfoHeader
     * @uses OrderInfoHeader::setAccountAddressId()
     * @uses OrderInfoHeader::setAccountContractId()
     * @uses OrderInfoHeader::setAccountId()
     * @uses OrderInfoHeader::setApplicationId()
     * @uses OrderInfoHeader::setApplicationVersion()
     * @uses OrderInfoHeader::setAuditCreateDate()
     * @uses OrderInfoHeader::setAuditCreateUnitId()
     * @uses OrderInfoHeader::setAuditCreatedBy()
     * @uses OrderInfoHeader::setAuditDeleted()
     * @uses OrderInfoHeader::setAuditModifiedBy()
     * @uses OrderInfoHeader::setAuditModifyDate()
     * @uses OrderInfoHeader::setAuditModifyUnitId()
     * @uses OrderInfoHeader::setId()
     * @uses OrderInfoHeader::setIsPiecedAccepted()
     * @uses OrderInfoHeader::setIsVolumeAccepted()
     * @uses OrderInfoHeader::setLovPayorTypeOrderId()
     * @param string $accountAddressId
     * @param string $accountContractId
     * @param string $accountId
     * @param int $applicationId
     * @param string $applicationVersion
     * @param string $auditCreateDate
     * @param int $auditCreateUnitId
     * @param int $auditCreatedBy
     * @param string $auditDeleted
     * @param int $auditModifiedBy
     * @param string $auditModifyDate
     * @param int $auditModifyUnitId
     * @param string $id
     * @param string $isPiecedAccepted
     * @param string $isVolumeAccepted
     * @param int $lovPayorTypeOrderId
     */
    public function __construct($accountAddressId = null, $accountContractId = null, $accountId = null, $applicationId = null, $applicationVersion = null, $auditCreateDate = null, $auditCreateUnitId = null, $auditCreatedBy = null, $auditDeleted = null, $auditModifiedBy = null, $auditModifyDate = null, $auditModifyUnitId = null, $id = null, $isPiecedAccepted = null, $isVolumeAccepted = null, $lovPayorTypeOrderId = null)
    {
        $this
            ->setAccountAddressId($accountAddressId)
            ->setAccountContractId($accountContractId)
            ->setAccountId($accountId)
            ->setApplicationId($applicationId)
            ->setApplicationVersion($applicationVersion)
            ->setAuditCreateDate($auditCreateDate)
            ->setAuditCreateUnitId($auditCreateUnitId)
            ->setAuditCreatedBy($auditCreatedBy)
            ->setAuditDeleted($auditDeleted)
            ->setAuditModifiedBy($auditModifiedBy)
            ->setAuditModifyDate($auditModifyDate)
            ->setAuditModifyUnitId($auditModifyUnitId)
            ->setId($id)
            ->setIsPiecedAccepted($isPiecedAccepted)
            ->setIsVolumeAccepted($isVolumeAccepted)
            ->setLovPayorTypeOrderId($lovPayorTypeOrderId);
    }
    /**
     * Get AccountAddressId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountAddressId()
    {
        return isset($this->AccountAddressId) ? $this->AccountAddressId : null;
    }
    /**
     * Set AccountAddressId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountAddressId
     * @return \StructType\OrderInfoHeader
     */
    public function setAccountAddressId($accountAddressId = null)
    {
        // validation for constraint: string
        if (!is_null($accountAddressId) && !is_string($accountAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAddressId, true), gettype($accountAddressId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountAddressId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountAddressId, true)), __LINE__);
        }
        if (is_null($accountAddressId) || (is_array($accountAddressId) && empty($accountAddressId))) {
            unset($this->AccountAddressId);
        } else {
            $this->AccountAddressId = $accountAddressId;
        }
        return $this;
    }
    /**
     * Get AccountContractId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountContractId()
    {
        return isset($this->AccountContractId) ? $this->AccountContractId : null;
    }
    /**
     * Set AccountContractId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountContractId
     * @return \StructType\OrderInfoHeader
     */
    public function setAccountContractId($accountContractId = null)
    {
        // validation for constraint: string
        if (!is_null($accountContractId) && !is_string($accountContractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountContractId, true), gettype($accountContractId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountContractId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountContractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountContractId, true)), __LINE__);
        }
        if (is_null($accountContractId) || (is_array($accountContractId) && empty($accountContractId))) {
            unset($this->AccountContractId);
        } else {
            $this->AccountContractId = $accountContractId;
        }
        return $this;
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \StructType\OrderInfoHeader
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $applicationId
     * @return \StructType\OrderInfoHeader
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: int
        if (!is_null($applicationId) && !(is_int($applicationId) || ctype_digit($applicationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return isset($this->ApplicationVersion) ? $this->ApplicationVersion : null;
    }
    /**
     * Set ApplicationVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationVersion
     * @return \StructType\OrderInfoHeader
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationVersion, true), gettype($applicationVersion)), __LINE__);
        }
        if (is_null($applicationVersion) || (is_array($applicationVersion) && empty($applicationVersion))) {
            unset($this->ApplicationVersion);
        } else {
            $this->ApplicationVersion = $applicationVersion;
        }
        return $this;
    }
    /**
     * Get AuditCreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditCreateDate()
    {
        return isset($this->AuditCreateDate) ? $this->AuditCreateDate : null;
    }
    /**
     * Set AuditCreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditCreateDate
     * @return \StructType\OrderInfoHeader
     */
    public function setAuditCreateDate($auditCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditCreateDate) && !is_string($auditCreateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditCreateDate, true), gettype($auditCreateDate)), __LINE__);
        }
        if (is_null($auditCreateDate) || (is_array($auditCreateDate) && empty($auditCreateDate))) {
            unset($this->AuditCreateDate);
        } else {
            $this->AuditCreateDate = $auditCreateDate;
        }
        return $this;
    }
    /**
     * Get AuditCreateUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreateUnitId()
    {
        return isset($this->AuditCreateUnitId) ? $this->AuditCreateUnitId : null;
    }
    /**
     * Set AuditCreateUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreateUnitId
     * @return \StructType\OrderInfoHeader
     */
    public function setAuditCreateUnitId($auditCreateUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreateUnitId) && !(is_int($auditCreateUnitId) || ctype_digit($auditCreateUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreateUnitId, true), gettype($auditCreateUnitId)), __LINE__);
        }
        if (is_null($auditCreateUnitId) || (is_array($auditCreateUnitId) && empty($auditCreateUnitId))) {
            unset($this->AuditCreateUnitId);
        } else {
            $this->AuditCreateUnitId = $auditCreateUnitId;
        }
        return $this;
    }
    /**
     * Get AuditCreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreatedBy()
    {
        return isset($this->AuditCreatedBy) ? $this->AuditCreatedBy : null;
    }
    /**
     * Set AuditCreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreatedBy
     * @return \StructType\OrderInfoHeader
     */
    public function setAuditCreatedBy($auditCreatedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreatedBy) && !(is_int($auditCreatedBy) || ctype_digit($auditCreatedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreatedBy, true), gettype($auditCreatedBy)), __LINE__);
        }
        if (is_null($auditCreatedBy) || (is_array($auditCreatedBy) && empty($auditCreatedBy))) {
            unset($this->AuditCreatedBy);
        } else {
            $this->AuditCreatedBy = $auditCreatedBy;
        }
        return $this;
    }
    /**
     * Get AuditDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditDeleted()
    {
        return isset($this->AuditDeleted) ? $this->AuditDeleted : null;
    }
    /**
     * Set AuditDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditDeleted
     * @return \StructType\OrderInfoHeader
     */
    public function setAuditDeleted($auditDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($auditDeleted) && !is_string($auditDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditDeleted, true), gettype($auditDeleted)), __LINE__);
        }
        if (is_null($auditDeleted) || (is_array($auditDeleted) && empty($auditDeleted))) {
            unset($this->AuditDeleted);
        } else {
            $this->AuditDeleted = $auditDeleted;
        }
        return $this;
    }
    /**
     * Get AuditModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifiedBy()
    {
        return isset($this->AuditModifiedBy) ? $this->AuditModifiedBy : null;
    }
    /**
     * Set AuditModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifiedBy
     * @return \StructType\OrderInfoHeader
     */
    public function setAuditModifiedBy($auditModifiedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifiedBy) && !(is_int($auditModifiedBy) || ctype_digit($auditModifiedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifiedBy, true), gettype($auditModifiedBy)), __LINE__);
        }
        if (is_null($auditModifiedBy) || (is_array($auditModifiedBy) && empty($auditModifiedBy))) {
            unset($this->AuditModifiedBy);
        } else {
            $this->AuditModifiedBy = $auditModifiedBy;
        }
        return $this;
    }
    /**
     * Get AuditModifyDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditModifyDate()
    {
        return isset($this->AuditModifyDate) ? $this->AuditModifyDate : null;
    }
    /**
     * Set AuditModifyDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditModifyDate
     * @return \StructType\OrderInfoHeader
     */
    public function setAuditModifyDate($auditModifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditModifyDate) && !is_string($auditModifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditModifyDate, true), gettype($auditModifyDate)), __LINE__);
        }
        if (is_null($auditModifyDate) || (is_array($auditModifyDate) && empty($auditModifyDate))) {
            unset($this->AuditModifyDate);
        } else {
            $this->AuditModifyDate = $auditModifyDate;
        }
        return $this;
    }
    /**
     * Get AuditModifyUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifyUnitId()
    {
        return isset($this->AuditModifyUnitId) ? $this->AuditModifyUnitId : null;
    }
    /**
     * Set AuditModifyUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifyUnitId
     * @return \StructType\OrderInfoHeader
     */
    public function setAuditModifyUnitId($auditModifyUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifyUnitId) && !(is_int($auditModifyUnitId) || ctype_digit($auditModifyUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifyUnitId, true), gettype($auditModifyUnitId)), __LINE__);
        }
        if (is_null($auditModifyUnitId) || (is_array($auditModifyUnitId) && empty($auditModifyUnitId))) {
            unset($this->AuditModifyUnitId);
        } else {
            $this->AuditModifyUnitId = $auditModifyUnitId;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\OrderInfoHeader
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsPiecedAccepted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsPiecedAccepted()
    {
        return isset($this->IsPiecedAccepted) ? $this->IsPiecedAccepted : null;
    }
    /**
     * Set IsPiecedAccepted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isPiecedAccepted
     * @return \StructType\OrderInfoHeader
     */
    public function setIsPiecedAccepted($isPiecedAccepted = null)
    {
        // validation for constraint: string
        if (!is_null($isPiecedAccepted) && !is_string($isPiecedAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPiecedAccepted, true), gettype($isPiecedAccepted)), __LINE__);
        }
        if (is_null($isPiecedAccepted) || (is_array($isPiecedAccepted) && empty($isPiecedAccepted))) {
            unset($this->IsPiecedAccepted);
        } else {
            $this->IsPiecedAccepted = $isPiecedAccepted;
        }
        return $this;
    }
    /**
     * Get IsVolumeAccepted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsVolumeAccepted()
    {
        return isset($this->IsVolumeAccepted) ? $this->IsVolumeAccepted : null;
    }
    /**
     * Set IsVolumeAccepted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isVolumeAccepted
     * @return \StructType\OrderInfoHeader
     */
    public function setIsVolumeAccepted($isVolumeAccepted = null)
    {
        // validation for constraint: string
        if (!is_null($isVolumeAccepted) && !is_string($isVolumeAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isVolumeAccepted, true), gettype($isVolumeAccepted)), __LINE__);
        }
        if (is_null($isVolumeAccepted) || (is_array($isVolumeAccepted) && empty($isVolumeAccepted))) {
            unset($this->IsVolumeAccepted);
        } else {
            $this->IsVolumeAccepted = $isVolumeAccepted;
        }
        return $this;
    }
    /**
     * Get LovPayorTypeOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLovPayorTypeOrderId()
    {
        return isset($this->LovPayorTypeOrderId) ? $this->LovPayorTypeOrderId : null;
    }
    /**
     * Set LovPayorTypeOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lovPayorTypeOrderId
     * @return \StructType\OrderInfoHeader
     */
    public function setLovPayorTypeOrderId($lovPayorTypeOrderId = null)
    {
        // validation for constraint: int
        if (!is_null($lovPayorTypeOrderId) && !(is_int($lovPayorTypeOrderId) || ctype_digit($lovPayorTypeOrderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lovPayorTypeOrderId, true), gettype($lovPayorTypeOrderId)), __LINE__);
        }
        if (is_null($lovPayorTypeOrderId) || (is_array($lovPayorTypeOrderId) && empty($lovPayorTypeOrderId))) {
            unset($this->LovPayorTypeOrderId);
        } else {
            $this->LovPayorTypeOrderId = $lovPayorTypeOrderId;
        }
        return $this;
    }
}
