<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HintCity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HintCity
 * @subpackage Structs
 */
class HintCity extends AbstractStructBase
{
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ApplicationId;
    /**
     * The ApplicationVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The AuditCreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditCreateDate;
    /**
     * The AuditCreateUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreateUnitId;
    /**
     * The AuditCreatedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreatedBy;
    /**
     * The AuditDeleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditDeleted;
    /**
     * The AuditModifiedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifiedBy;
    /**
     * The AuditModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditModifyDate;
    /**
     * The AuditModifyUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifyUnitId;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The DM_OldCityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DM_OldCityId;
    /**
     * The HintCityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HintCityId;
    /**
     * The HintCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HintCountry
     */
    public $HintCountry;
    /**
     * The HintTownList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHintTown
     */
    public $HintTownList;
    /**
     * Constructor method for HintCity
     * @uses HintCity::setApplicationId()
     * @uses HintCity::setApplicationVersion()
     * @uses HintCity::setAuditCreateDate()
     * @uses HintCity::setAuditCreateUnitId()
     * @uses HintCity::setAuditCreatedBy()
     * @uses HintCity::setAuditDeleted()
     * @uses HintCity::setAuditModifiedBy()
     * @uses HintCity::setAuditModifyDate()
     * @uses HintCity::setAuditModifyUnitId()
     * @uses HintCity::setCity()
     * @uses HintCity::setDM_OldCityId()
     * @uses HintCity::setHintCityId()
     * @uses HintCity::setHintCountry()
     * @uses HintCity::setHintTownList()
     * @param int $applicationId
     * @param string $applicationVersion
     * @param string $auditCreateDate
     * @param int $auditCreateUnitId
     * @param int $auditCreatedBy
     * @param string $auditDeleted
     * @param int $auditModifiedBy
     * @param string $auditModifyDate
     * @param int $auditModifyUnitId
     * @param string $city
     * @param string $dM_OldCityId
     * @param string $hintCityId
     * @param \StructType\HintCountry $hintCountry
     * @param \ArrayType\ArrayOfHintTown $hintTownList
     */
    public function __construct($applicationId = null, $applicationVersion = null, $auditCreateDate = null, $auditCreateUnitId = null, $auditCreatedBy = null, $auditDeleted = null, $auditModifiedBy = null, $auditModifyDate = null, $auditModifyUnitId = null, $city = null, $dM_OldCityId = null, $hintCityId = null, \StructType\HintCountry $hintCountry = null, \ArrayType\ArrayOfHintTown $hintTownList = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setApplicationVersion($applicationVersion)
            ->setAuditCreateDate($auditCreateDate)
            ->setAuditCreateUnitId($auditCreateUnitId)
            ->setAuditCreatedBy($auditCreatedBy)
            ->setAuditDeleted($auditDeleted)
            ->setAuditModifiedBy($auditModifiedBy)
            ->setAuditModifyDate($auditModifyDate)
            ->setAuditModifyUnitId($auditModifyUnitId)
            ->setCity($city)
            ->setDM_OldCityId($dM_OldCityId)
            ->setHintCityId($hintCityId)
            ->setHintCountry($hintCountry)
            ->setHintTownList($hintTownList);
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $applicationId
     * @return \StructType\HintCity
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: int
        if (!is_null($applicationId) && !(is_int($applicationId) || ctype_digit($applicationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return isset($this->ApplicationVersion) ? $this->ApplicationVersion : null;
    }
    /**
     * Set ApplicationVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationVersion
     * @return \StructType\HintCity
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationVersion, true), gettype($applicationVersion)), __LINE__);
        }
        if (is_null($applicationVersion) || (is_array($applicationVersion) && empty($applicationVersion))) {
            unset($this->ApplicationVersion);
        } else {
            $this->ApplicationVersion = $applicationVersion;
        }
        return $this;
    }
    /**
     * Get AuditCreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditCreateDate()
    {
        return isset($this->AuditCreateDate) ? $this->AuditCreateDate : null;
    }
    /**
     * Set AuditCreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditCreateDate
     * @return \StructType\HintCity
     */
    public function setAuditCreateDate($auditCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditCreateDate) && !is_string($auditCreateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditCreateDate, true), gettype($auditCreateDate)), __LINE__);
        }
        if (is_null($auditCreateDate) || (is_array($auditCreateDate) && empty($auditCreateDate))) {
            unset($this->AuditCreateDate);
        } else {
            $this->AuditCreateDate = $auditCreateDate;
        }
        return $this;
    }
    /**
     * Get AuditCreateUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreateUnitId()
    {
        return isset($this->AuditCreateUnitId) ? $this->AuditCreateUnitId : null;
    }
    /**
     * Set AuditCreateUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreateUnitId
     * @return \StructType\HintCity
     */
    public function setAuditCreateUnitId($auditCreateUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreateUnitId) && !(is_int($auditCreateUnitId) || ctype_digit($auditCreateUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreateUnitId, true), gettype($auditCreateUnitId)), __LINE__);
        }
        if (is_null($auditCreateUnitId) || (is_array($auditCreateUnitId) && empty($auditCreateUnitId))) {
            unset($this->AuditCreateUnitId);
        } else {
            $this->AuditCreateUnitId = $auditCreateUnitId;
        }
        return $this;
    }
    /**
     * Get AuditCreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreatedBy()
    {
        return isset($this->AuditCreatedBy) ? $this->AuditCreatedBy : null;
    }
    /**
     * Set AuditCreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreatedBy
     * @return \StructType\HintCity
     */
    public function setAuditCreatedBy($auditCreatedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreatedBy) && !(is_int($auditCreatedBy) || ctype_digit($auditCreatedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreatedBy, true), gettype($auditCreatedBy)), __LINE__);
        }
        if (is_null($auditCreatedBy) || (is_array($auditCreatedBy) && empty($auditCreatedBy))) {
            unset($this->AuditCreatedBy);
        } else {
            $this->AuditCreatedBy = $auditCreatedBy;
        }
        return $this;
    }
    /**
     * Get AuditDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditDeleted()
    {
        return isset($this->AuditDeleted) ? $this->AuditDeleted : null;
    }
    /**
     * Set AuditDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditDeleted
     * @return \StructType\HintCity
     */
    public function setAuditDeleted($auditDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($auditDeleted) && !is_string($auditDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditDeleted, true), gettype($auditDeleted)), __LINE__);
        }
        if (is_null($auditDeleted) || (is_array($auditDeleted) && empty($auditDeleted))) {
            unset($this->AuditDeleted);
        } else {
            $this->AuditDeleted = $auditDeleted;
        }
        return $this;
    }
    /**
     * Get AuditModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifiedBy()
    {
        return isset($this->AuditModifiedBy) ? $this->AuditModifiedBy : null;
    }
    /**
     * Set AuditModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifiedBy
     * @return \StructType\HintCity
     */
    public function setAuditModifiedBy($auditModifiedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifiedBy) && !(is_int($auditModifiedBy) || ctype_digit($auditModifiedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifiedBy, true), gettype($auditModifiedBy)), __LINE__);
        }
        if (is_null($auditModifiedBy) || (is_array($auditModifiedBy) && empty($auditModifiedBy))) {
            unset($this->AuditModifiedBy);
        } else {
            $this->AuditModifiedBy = $auditModifiedBy;
        }
        return $this;
    }
    /**
     * Get AuditModifyDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditModifyDate()
    {
        return isset($this->AuditModifyDate) ? $this->AuditModifyDate : null;
    }
    /**
     * Set AuditModifyDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditModifyDate
     * @return \StructType\HintCity
     */
    public function setAuditModifyDate($auditModifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditModifyDate) && !is_string($auditModifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditModifyDate, true), gettype($auditModifyDate)), __LINE__);
        }
        if (is_null($auditModifyDate) || (is_array($auditModifyDate) && empty($auditModifyDate))) {
            unset($this->AuditModifyDate);
        } else {
            $this->AuditModifyDate = $auditModifyDate;
        }
        return $this;
    }
    /**
     * Get AuditModifyUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifyUnitId()
    {
        return isset($this->AuditModifyUnitId) ? $this->AuditModifyUnitId : null;
    }
    /**
     * Set AuditModifyUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifyUnitId
     * @return \StructType\HintCity
     */
    public function setAuditModifyUnitId($auditModifyUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifyUnitId) && !(is_int($auditModifyUnitId) || ctype_digit($auditModifyUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifyUnitId, true), gettype($auditModifyUnitId)), __LINE__);
        }
        if (is_null($auditModifyUnitId) || (is_array($auditModifyUnitId) && empty($auditModifyUnitId))) {
            unset($this->AuditModifyUnitId);
        } else {
            $this->AuditModifyUnitId = $auditModifyUnitId;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\HintCity
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get DM_OldCityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDM_OldCityId()
    {
        return isset($this->DM_OldCityId) ? $this->DM_OldCityId : null;
    }
    /**
     * Set DM_OldCityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dM_OldCityId
     * @return \StructType\HintCity
     */
    public function setDM_OldCityId($dM_OldCityId = null)
    {
        // validation for constraint: string
        if (!is_null($dM_OldCityId) && !is_string($dM_OldCityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dM_OldCityId, true), gettype($dM_OldCityId)), __LINE__);
        }
        if (is_null($dM_OldCityId) || (is_array($dM_OldCityId) && empty($dM_OldCityId))) {
            unset($this->DM_OldCityId);
        } else {
            $this->DM_OldCityId = $dM_OldCityId;
        }
        return $this;
    }
    /**
     * Get HintCityId value
     * @return string|null
     */
    public function getHintCityId()
    {
        return $this->HintCityId;
    }
    /**
     * Set HintCityId value
     * @param string $hintCityId
     * @return \StructType\HintCity
     */
    public function setHintCityId($hintCityId = null)
    {
        // validation for constraint: string
        if (!is_null($hintCityId) && !is_string($hintCityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintCityId, true), gettype($hintCityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hintCityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hintCityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hintCityId, true)), __LINE__);
        }
        $this->HintCityId = $hintCityId;
        return $this;
    }
    /**
     * Get HintCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HintCountry|null
     */
    public function getHintCountry()
    {
        return isset($this->HintCountry) ? $this->HintCountry : null;
    }
    /**
     * Set HintCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HintCountry $hintCountry
     * @return \StructType\HintCity
     */
    public function setHintCountry(\StructType\HintCountry $hintCountry = null)
    {
        if (is_null($hintCountry) || (is_array($hintCountry) && empty($hintCountry))) {
            unset($this->HintCountry);
        } else {
            $this->HintCountry = $hintCountry;
        }
        return $this;
    }
    /**
     * Get HintTownList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHintTown|null
     */
    public function getHintTownList()
    {
        return isset($this->HintTownList) ? $this->HintTownList : null;
    }
    /**
     * Set HintTownList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHintTown $hintTownList
     * @return \StructType\HintCity
     */
    public function setHintTownList(\ArrayType\ArrayOfHintTown $hintTownList = null)
    {
        if (is_null($hintTownList) || (is_array($hintTownList) && empty($hintTownList))) {
            unset($this->HintTownList);
        } else {
            $this->HintTownList = $hintTownList;
        }
        return $this;
    }
}
