<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountAddress ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAccountAddress
 * @subpackage Arrays
 */
class ArrayOfAccountAddress extends AbstractStructArrayBase
{
    /**
     * The AccountAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountAddress[]
     */
    public $AccountAddress;
    /**
     * Constructor method for ArrayOfAccountAddress
     * @uses ArrayOfAccountAddress::setAccountAddress()
     * @param \StructType\AccountAddress[] $accountAddress
     */
    public function __construct(array $accountAddress = array())
    {
        $this
            ->setAccountAddress($accountAddress);
    }
    /**
     * Get AccountAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountAddress[]|null
     */
    public function getAccountAddress()
    {
        return isset($this->AccountAddress) ? $this->AccountAddress : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountAddressForArrayConstraintsFromSetAccountAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAccountAddressAccountAddressItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountAddressAccountAddressItem instanceof \StructType\AccountAddress) {
                $invalidValues[] = is_object($arrayOfAccountAddressAccountAddressItem) ? get_class($arrayOfAccountAddressAccountAddressItem) : sprintf('%s(%s)', gettype($arrayOfAccountAddressAccountAddressItem), var_export($arrayOfAccountAddressAccountAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountAddress property can only contain items of type \StructType\AccountAddress, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountAddress[] $accountAddress
     * @return \ArrayType\ArrayOfAccountAddress
     */
    public function setAccountAddress(array $accountAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($accountAddressArrayErrorMessage = self::validateAccountAddressForArrayConstraintsFromSetAccountAddress($accountAddress))) {
            throw new \InvalidArgumentException($accountAddressArrayErrorMessage, __LINE__);
        }
        if (is_null($accountAddress) || (is_array($accountAddress) && empty($accountAddress))) {
            unset($this->AccountAddress);
        } else {
            $this->AccountAddress = $accountAddress;
        }
        return $this;
    }
    /**
     * Add item to AccountAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountAddress $item
     * @return \ArrayType\ArrayOfAccountAddress
     */
    public function addToAccountAddress(\StructType\AccountAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountAddress) {
            throw new \InvalidArgumentException(sprintf('The AccountAddress property can only contain items of type \StructType\AccountAddress, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountAddress[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccountAddress|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccountAddress|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccountAddress|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccountAddress|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccountAddress|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountAddress
     */
    public function getAttributeName()
    {
        return 'AccountAddress';
    }
}
