<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderInfoViewModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderInfoViewModel
 * @subpackage Structs
 */
class OrderInfoViewModel extends AbstractStructBase
{
    /**
     * The CodeExpireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeExpireDate;
    /**
     * The CollectionPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CollectionPrice;
    /**
     * The ConfigurationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfigurationId;
    /**
     * The ExtProductList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfExtProductModel
     */
    public $ExtProductList;
    /**
     * The ExtServiceCodeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ExtServiceCodeList;
    /**
     * The IntegrationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntegrationCode;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The LovCollectionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LovCollectionType;
    /**
     * The LovPayOrType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LovPayOrType;
    /**
     * The MainServiceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MainServiceCode;
    /**
     * The PieceCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PieceCount;
    /**
     * The ReceiverAddressInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressInfoViewModel
     */
    public $ReceiverAddressInfo;
    /**
     * The SenderAddressInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressInfoViewModel
     */
    public $SenderAddressInfo;
    /**
     * The TradingWaybillNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TradingWaybillNumber;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Volume;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Weight;
    /**
     * Constructor method for OrderInfoViewModel
     * @uses OrderInfoViewModel::setCodeExpireDate()
     * @uses OrderInfoViewModel::setCollectionPrice()
     * @uses OrderInfoViewModel::setConfigurationId()
     * @uses OrderInfoViewModel::setExtProductList()
     * @uses OrderInfoViewModel::setExtServiceCodeList()
     * @uses OrderInfoViewModel::setIntegrationCode()
     * @uses OrderInfoViewModel::setInvoiceNumber()
     * @uses OrderInfoViewModel::setLovCollectionType()
     * @uses OrderInfoViewModel::setLovPayOrType()
     * @uses OrderInfoViewModel::setMainServiceCode()
     * @uses OrderInfoViewModel::setPieceCount()
     * @uses OrderInfoViewModel::setReceiverAddressInfo()
     * @uses OrderInfoViewModel::setSenderAddressInfo()
     * @uses OrderInfoViewModel::setTradingWaybillNumber()
     * @uses OrderInfoViewModel::setVolume()
     * @uses OrderInfoViewModel::setWeight()
     * @param string $codeExpireDate
     * @param float $collectionPrice
     * @param string $configurationId
     * @param \ArrayType\ArrayOfExtProductModel $extProductList
     * @param \ArrayType\ArrayOfstring $extServiceCodeList
     * @param string $integrationCode
     * @param string $invoiceNumber
     * @param int $lovCollectionType
     * @param int $lovPayOrType
     * @param string $mainServiceCode
     * @param int $pieceCount
     * @param \StructType\AddressInfoViewModel $receiverAddressInfo
     * @param \StructType\AddressInfoViewModel $senderAddressInfo
     * @param string $tradingWaybillNumber
     * @param float $volume
     * @param float $weight
     */
    public function __construct($codeExpireDate = null, $collectionPrice = null, $configurationId = null, \ArrayType\ArrayOfExtProductModel $extProductList = null, \ArrayType\ArrayOfstring $extServiceCodeList = null, $integrationCode = null, $invoiceNumber = null, $lovCollectionType = null, $lovPayOrType = null, $mainServiceCode = null, $pieceCount = null, \StructType\AddressInfoViewModel $receiverAddressInfo = null, \StructType\AddressInfoViewModel $senderAddressInfo = null, $tradingWaybillNumber = null, $volume = null, $weight = null)
    {
        $this
            ->setCodeExpireDate($codeExpireDate)
            ->setCollectionPrice($collectionPrice)
            ->setConfigurationId($configurationId)
            ->setExtProductList($extProductList)
            ->setExtServiceCodeList($extServiceCodeList)
            ->setIntegrationCode($integrationCode)
            ->setInvoiceNumber($invoiceNumber)
            ->setLovCollectionType($lovCollectionType)
            ->setLovPayOrType($lovPayOrType)
            ->setMainServiceCode($mainServiceCode)
            ->setPieceCount($pieceCount)
            ->setReceiverAddressInfo($receiverAddressInfo)
            ->setSenderAddressInfo($senderAddressInfo)
            ->setTradingWaybillNumber($tradingWaybillNumber)
            ->setVolume($volume)
            ->setWeight($weight);
    }
    /**
     * Get CodeExpireDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeExpireDate()
    {
        return isset($this->CodeExpireDate) ? $this->CodeExpireDate : null;
    }
    /**
     * Set CodeExpireDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeExpireDate
     * @return \StructType\OrderInfoViewModel
     */
    public function setCodeExpireDate($codeExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($codeExpireDate) && !is_string($codeExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeExpireDate, true), gettype($codeExpireDate)), __LINE__);
        }
        if (is_null($codeExpireDate) || (is_array($codeExpireDate) && empty($codeExpireDate))) {
            unset($this->CodeExpireDate);
        } else {
            $this->CodeExpireDate = $codeExpireDate;
        }
        return $this;
    }
    /**
     * Get CollectionPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCollectionPrice()
    {
        return isset($this->CollectionPrice) ? $this->CollectionPrice : null;
    }
    /**
     * Set CollectionPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $collectionPrice
     * @return \StructType\OrderInfoViewModel
     */
    public function setCollectionPrice($collectionPrice = null)
    {
        // validation for constraint: float
        if (!is_null($collectionPrice) && !(is_float($collectionPrice) || is_numeric($collectionPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($collectionPrice, true), gettype($collectionPrice)), __LINE__);
        }
        if (is_null($collectionPrice) || (is_array($collectionPrice) && empty($collectionPrice))) {
            unset($this->CollectionPrice);
        } else {
            $this->CollectionPrice = $collectionPrice;
        }
        return $this;
    }
    /**
     * Get ConfigurationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigurationId()
    {
        return isset($this->ConfigurationId) ? $this->ConfigurationId : null;
    }
    /**
     * Set ConfigurationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $configurationId
     * @return \StructType\OrderInfoViewModel
     */
    public function setConfigurationId($configurationId = null)
    {
        // validation for constraint: string
        if (!is_null($configurationId) && !is_string($configurationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurationId, true), gettype($configurationId)), __LINE__);
        }
        if (is_null($configurationId) || (is_array($configurationId) && empty($configurationId))) {
            unset($this->ConfigurationId);
        } else {
            $this->ConfigurationId = $configurationId;
        }
        return $this;
    }
    /**
     * Get ExtProductList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfExtProductModel|null
     */
    public function getExtProductList()
    {
        return isset($this->ExtProductList) ? $this->ExtProductList : null;
    }
    /**
     * Set ExtProductList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfExtProductModel $extProductList
     * @return \StructType\OrderInfoViewModel
     */
    public function setExtProductList(\ArrayType\ArrayOfExtProductModel $extProductList = null)
    {
        if (is_null($extProductList) || (is_array($extProductList) && empty($extProductList))) {
            unset($this->ExtProductList);
        } else {
            $this->ExtProductList = $extProductList;
        }
        return $this;
    }
    /**
     * Get ExtServiceCodeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getExtServiceCodeList()
    {
        return isset($this->ExtServiceCodeList) ? $this->ExtServiceCodeList : null;
    }
    /**
     * Set ExtServiceCodeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $extServiceCodeList
     * @return \StructType\OrderInfoViewModel
     */
    public function setExtServiceCodeList(\ArrayType\ArrayOfstring $extServiceCodeList = null)
    {
        if (is_null($extServiceCodeList) || (is_array($extServiceCodeList) && empty($extServiceCodeList))) {
            unset($this->ExtServiceCodeList);
        } else {
            $this->ExtServiceCodeList = $extServiceCodeList;
        }
        return $this;
    }
    /**
     * Get IntegrationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return isset($this->IntegrationCode) ? $this->IntegrationCode : null;
    }
    /**
     * Set IntegrationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $integrationCode
     * @return \StructType\OrderInfoViewModel
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationCode, true), gettype($integrationCode)), __LINE__);
        }
        if (is_null($integrationCode) || (is_array($integrationCode) && empty($integrationCode))) {
            unset($this->IntegrationCode);
        } else {
            $this->IntegrationCode = $integrationCode;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceNumber
     * @return \StructType\OrderInfoViewModel
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get LovCollectionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLovCollectionType()
    {
        return isset($this->LovCollectionType) ? $this->LovCollectionType : null;
    }
    /**
     * Set LovCollectionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lovCollectionType
     * @return \StructType\OrderInfoViewModel
     */
    public function setLovCollectionType($lovCollectionType = null)
    {
        // validation for constraint: int
        if (!is_null($lovCollectionType) && !(is_int($lovCollectionType) || ctype_digit($lovCollectionType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lovCollectionType, true), gettype($lovCollectionType)), __LINE__);
        }
        if (is_null($lovCollectionType) || (is_array($lovCollectionType) && empty($lovCollectionType))) {
            unset($this->LovCollectionType);
        } else {
            $this->LovCollectionType = $lovCollectionType;
        }
        return $this;
    }
    /**
     * Get LovPayOrType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLovPayOrType()
    {
        return isset($this->LovPayOrType) ? $this->LovPayOrType : null;
    }
    /**
     * Set LovPayOrType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lovPayOrType
     * @return \StructType\OrderInfoViewModel
     */
    public function setLovPayOrType($lovPayOrType = null)
    {
        // validation for constraint: int
        if (!is_null($lovPayOrType) && !(is_int($lovPayOrType) || ctype_digit($lovPayOrType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lovPayOrType, true), gettype($lovPayOrType)), __LINE__);
        }
        if (is_null($lovPayOrType) || (is_array($lovPayOrType) && empty($lovPayOrType))) {
            unset($this->LovPayOrType);
        } else {
            $this->LovPayOrType = $lovPayOrType;
        }
        return $this;
    }
    /**
     * Get MainServiceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMainServiceCode()
    {
        return isset($this->MainServiceCode) ? $this->MainServiceCode : null;
    }
    /**
     * Set MainServiceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mainServiceCode
     * @return \StructType\OrderInfoViewModel
     */
    public function setMainServiceCode($mainServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($mainServiceCode) && !is_string($mainServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainServiceCode, true), gettype($mainServiceCode)), __LINE__);
        }
        if (is_null($mainServiceCode) || (is_array($mainServiceCode) && empty($mainServiceCode))) {
            unset($this->MainServiceCode);
        } else {
            $this->MainServiceCode = $mainServiceCode;
        }
        return $this;
    }
    /**
     * Get PieceCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPieceCount()
    {
        return isset($this->PieceCount) ? $this->PieceCount : null;
    }
    /**
     * Set PieceCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pieceCount
     * @return \StructType\OrderInfoViewModel
     */
    public function setPieceCount($pieceCount = null)
    {
        // validation for constraint: int
        if (!is_null($pieceCount) && !(is_int($pieceCount) || ctype_digit($pieceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pieceCount, true), gettype($pieceCount)), __LINE__);
        }
        if (is_null($pieceCount) || (is_array($pieceCount) && empty($pieceCount))) {
            unset($this->PieceCount);
        } else {
            $this->PieceCount = $pieceCount;
        }
        return $this;
    }
    /**
     * Get ReceiverAddressInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressInfoViewModel|null
     */
    public function getReceiverAddressInfo()
    {
        return isset($this->ReceiverAddressInfo) ? $this->ReceiverAddressInfo : null;
    }
    /**
     * Set ReceiverAddressInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AddressInfoViewModel $receiverAddressInfo
     * @return \StructType\OrderInfoViewModel
     */
    public function setReceiverAddressInfo(\StructType\AddressInfoViewModel $receiverAddressInfo = null)
    {
        if (is_null($receiverAddressInfo) || (is_array($receiverAddressInfo) && empty($receiverAddressInfo))) {
            unset($this->ReceiverAddressInfo);
        } else {
            $this->ReceiverAddressInfo = $receiverAddressInfo;
        }
        return $this;
    }
    /**
     * Get SenderAddressInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressInfoViewModel|null
     */
    public function getSenderAddressInfo()
    {
        return isset($this->SenderAddressInfo) ? $this->SenderAddressInfo : null;
    }
    /**
     * Set SenderAddressInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AddressInfoViewModel $senderAddressInfo
     * @return \StructType\OrderInfoViewModel
     */
    public function setSenderAddressInfo(\StructType\AddressInfoViewModel $senderAddressInfo = null)
    {
        if (is_null($senderAddressInfo) || (is_array($senderAddressInfo) && empty($senderAddressInfo))) {
            unset($this->SenderAddressInfo);
        } else {
            $this->SenderAddressInfo = $senderAddressInfo;
        }
        return $this;
    }
    /**
     * Get TradingWaybillNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTradingWaybillNumber()
    {
        return isset($this->TradingWaybillNumber) ? $this->TradingWaybillNumber : null;
    }
    /**
     * Set TradingWaybillNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tradingWaybillNumber
     * @return \StructType\OrderInfoViewModel
     */
    public function setTradingWaybillNumber($tradingWaybillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tradingWaybillNumber) && !is_string($tradingWaybillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tradingWaybillNumber, true), gettype($tradingWaybillNumber)), __LINE__);
        }
        if (is_null($tradingWaybillNumber) || (is_array($tradingWaybillNumber) && empty($tradingWaybillNumber))) {
            unset($this->TradingWaybillNumber);
        } else {
            $this->TradingWaybillNumber = $tradingWaybillNumber;
        }
        return $this;
    }
    /**
     * Get Volume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVolume()
    {
        return isset($this->Volume) ? $this->Volume : null;
    }
    /**
     * Set Volume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $volume
     * @return \StructType\OrderInfoViewModel
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        if (is_null($volume) || (is_array($volume) && empty($volume))) {
            unset($this->Volume);
        } else {
            $this->Volume = $volume;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $weight
     * @return \StructType\OrderInfoViewModel
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
}
